/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.genBank.Feature;
import org.snpeff.genBank.FeatureCoordinates;
import org.snpeff.genBank.Features;
import org.snpeff.genBank.FeaturesFile;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CircularCorrection;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.factory.SnpEffPredictorFactory;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public abstract class SnpEffPredictorFactoryFeatures
extends SnpEffPredictorFactory {
    public static final int OFFSET = 1;
    Chromosome chromosome;
    FeaturesFile featuresFile;
    Map<String, String> proteinByTrId = new HashMap<String, String>();

    public SnpEffPredictorFactoryFeatures(Config config) {
        super(config, 1);
    }

    Transcript addCds(Feature fcds, Gene geneLatest, List<Transcript> trLatest) {
        Transcript tr = this.findTrForCds(fcds, geneLatest, trLatest);
        if (fcds.getAasequence() != null) {
            tr.setProteinCoding(true);
        }
        if (fcds.get("ribosomal_slippage") != null) {
            tr.setRibosomalSlippage(true);
        }
        if (fcds.hasMultipleCoordinates()) {
            for (FeatureCoordinates fc : fcds) {
                int cdsStart = fc.start - this.inOffset;
                int cdsEnd = fc.end - this.inOffset;
                Cds cds = new Cds(tr, cdsStart, cdsEnd, fcds.isComplement(), "CDS_" + tr.getId());
                this.add(cds);
            }
            CircularCorrection cc = new CircularCorrection(tr);
            cc.correct();
        } else {
            Cds cds = new Cds(tr, fcds.getStart() - this.inOffset, fcds.getEnd() - this.inOffset, fcds.isComplement(), "CDS_" + tr.getId());
            this.add(cds);
        }
        this.proteinByTrId.put(tr.getId(), fcds.getAasequence());
        return tr;
    }

    protected void addFeatures(Features features) {
        for (Feature f2 : features.getFeatures()) {
            int start = f2.getStart() - this.inOffset;
            int end = f2.getEnd() - this.inOffset;
            if (f2.getType() != Feature.Type.SOURCE) continue;
            if (this.chromosome == null) {
                String chrName = this.chromoName(features, f2);
                this.chromosome = new Chromosome(this.genome, start, end, chrName);
                this.add(this.chromosome);
                continue;
            }
            if (!this.debug) continue;
            System.err.println("Warnign: 'SOURCE' already assigned to chromosome. Ignoring feature:\n" + f2);
        }
        if (this.chromosome == null) {
            String chrName = this.chromoName(features, null);
            int chrSize = this.sequence(features).length();
            this.chromosome = new Chromosome(this.genome, 0, chrSize, chrName);
            this.add(this.chromosome);
        }
        if (this.chromosome == null) {
            throw new RuntimeException("Could not find SOURCE feature");
        }
        if (this.verbose) {
            System.err.println("Chromosome: '" + this.chromosome.getId() + "'\tlength: " + this.chromosome.size());
        }
        Gene geneLatest = null;
        ArrayList<Transcript> trLatest = null;
        for (Feature f3 : features.getFeatures()) {
            if (f3.getType() == Feature.Type.GENE) {
                geneLatest = this.findOrCreateGene(f3, this.chromosome, false);
                trLatest = null;
                continue;
            }
            Transcript trl = null;
            if (f3.getType() == Feature.Type.MRNA) {
                trl = this.addMrna(f3, geneLatest);
            } else if (f3.getType() == Feature.Type.CDS) {
                trl = this.addCds(f3, geneLatest, trLatest);
            }
            if (trl == null) continue;
            if (geneLatest == null || trLatest == null || !trl.getParent().getId().equals(geneLatest.getId())) {
                trLatest = new ArrayList<Transcript>();
                trLatest.add(trl);
            } else {
                trLatest.add(trl);
            }
            geneLatest = (Gene)trl.getParent();
        }
    }

    Transcript addMrna(Feature f2, Gene geneLatest) {
        if (this.debug) {
            Gpr.debug("Feature:" + f2);
        }
        int start = f2.getStart() - this.inOffset;
        int end = f2.getEnd() - this.inOffset;
        Gene gene = null;
        gene = geneLatest != null && geneLatest.intersects(start, end) ? geneLatest : this.findOrCreateGene(f2, this.chromosome, false);
        String trId = f2.getTranscriptId();
        Transcript tr = new Transcript(gene, start, end, f2.isComplement(), trId);
        if (f2.hasMultipleCoordinates()) {
            int exNum = 1;
            for (FeatureCoordinates fc : f2) {
                Exon e = new Exon(tr, fc.start - this.inOffset, fc.end - this.inOffset, fc.complement, tr.getId() + "_" + exNum, exNum);
                tr.add(e);
                ++exNum;
            }
        }
        this.add(tr);
        return tr;
    }

    boolean cdsMatchesGene(Feature fcds, Gene gene) {
        if (gene == null) {
            return false;
        }
        int start = fcds.getStart() - this.inOffset;
        int end = fcds.getEnd() - this.inOffset;
        if (start < gene.getStart() || gene.getEnd() < end) {
            return false;
        }
        String geneName = fcds.getGeneName();
        return geneName != null && gene != null && gene.getGeneName().equals(geneName);
    }

    boolean cdsMatchesTr(Feature fcds, Transcript tr) {
        if (tr == null) {
            return false;
        }
        int start = fcds.getStart() - this.inOffset;
        int end = fcds.getEnd() - this.inOffset;
        if (start < tr.getStart() || tr.getEnd() < end) {
            return false;
        }
        if (fcds.hasMultipleCoordinates() && !tr.subIntervals().isEmpty()) {
            return this.cdsMatchesTrExons(fcds, tr);
        }
        return true;
    }

    boolean cdsMatchesTrExons(Feature fcds, Transcript tr) {
        ArrayList<Exon> cdsExons = new ArrayList<Exon>();
        for (FeatureCoordinates fc : fcds) {
            Exon e = new Exon(tr, fc.start - this.inOffset, fc.end - this.inOffset, fc.complement, "", -1);
            cdsExons.add(e);
        }
        Collections.sort(cdsExons);
        ArrayList<Exon> trExons = new ArrayList<Exon>();
        trExons.addAll(tr.subIntervals());
        Collections.sort(trExons);
        if (cdsExons.size() > trExons.size()) {
            return false;
        }
        return this.cdsMatchesTrExons(cdsExons, trExons, tr);
    }

    boolean cdsMatchesTrExons(List<Exon> cdsExons, List<Exon> trExons, Transcript tr) {
        if (cdsExons.size() == 1) {
            Exon cdsEx = cdsExons.get(0);
            Exon trEx = tr.findExon(cdsEx);
            return trEx != null && trEx.includes(cdsEx);
        }
        int cdsExIdx = 0;
        int trExIdx = 0;
        Exon cdsEx = cdsExons.get(cdsExIdx);
        Exon trEx = trExons.get(trExIdx);
        while (cdsEx.getStart() > trEx.getEnd()) {
            if (++trExIdx >= trExons.size()) {
                return false;
            }
            trEx = trExons.get(trExIdx);
        }
        if (trEx.getStart() > cdsEx.getStart() || trEx.getEnd() != cdsEx.getEnd()) {
            return false;
        }
        while (cdsExIdx < cdsExons.size() - 2) {
            ++cdsExIdx;
            if (++trExIdx >= trExons.size()) {
                return false;
            }
            cdsEx = cdsExons.get(cdsExIdx);
            trEx = trExons.get(trExIdx);
            if (trEx.getStart() == cdsEx.getStart() && trEx.getEnd() == cdsEx.getEnd()) continue;
            return false;
        }
        ++trExIdx;
        if (++cdsExIdx >= cdsExons.size()) {
            return true;
        }
        if (trExIdx >= trExons.size()) {
            return false;
        }
        cdsEx = cdsExons.get(cdsExIdx);
        trEx = trExons.get(trExIdx);
        return trEx.getStart() == cdsEx.getStart() && trEx.getEnd() >= cdsEx.getEnd();
    }

    String chromoName(Features features, Feature sourceFeature) {
        String chrName;
        if (sourceFeature != null) {
            if (sourceFeature.getType() != Feature.Type.SOURCE) {
                throw new RuntimeException("Cannot find chromosome name in a non-SOURCE feature");
            }
            chrName = sourceFeature.get("chromosome");
            if (chrName != null) {
                return chrName;
            }
        }
        if ((chrName = features.getLocusName()) != null) {
            return chrName;
        }
        return this.genome.getId();
    }

    @Override
    public SnpEffectPredictor create() {
        try {
            for (Features features : this.featuresFile) {
                this.chromosome = null;
                this.addFeatures(features);
                this.beforeExonSequences();
                String sequence2 = this.sequence(features);
                this.addSequences(this.chromosome.getId(), sequence2);
            }
            this.finishUp();
        }
        catch (Exception e) {
            if (this.verbose) {
                e.printStackTrace();
            }
            throw new RuntimeException("Error reading file '" + this.fileName + "'\n" + e);
        }
        return this.snpEffectPredictor;
    }

    Gene findOrCreateGene(Feature f2, Chromosome chr, boolean warn) {
        int start = f2.getStart() - this.inOffset;
        int end = f2.getEnd() - this.inOffset;
        String geneId = this.geneId(f2, start, end);
        String geneName = this.geneName(f2, start, end);
        Gene gene = this.findGene(geneId);
        if (gene == null) {
            gene = new Gene(chr, start, end, f2.isComplement(), geneId, geneName, null);
            this.add(gene);
            if (this.debug) {
                System.err.println("WARNING: Gene '" + geneId + "' not found: created.");
            }
        }
        return gene;
    }

    Transcript findTrForCds(Feature fcds, Gene geneLatest, List<Transcript> trLatest) {
        Transcript trLatestMatch = this.findTrFromLatest(fcds, geneLatest, trLatest);
        if (trLatestMatch != null) {
            return trLatestMatch;
        }
        String trId = fcds.getTranscriptId();
        Transcript tr = this.findTranscript(trId);
        if (tr != null) {
            return tr;
        }
        int start = fcds.getStart() - this.inOffset;
        int end = fcds.getEnd() - this.inOffset;
        Gene gene = null;
        gene = this.cdsMatchesGene(fcds, geneLatest) ? geneLatest : this.findOrCreateGene(fcds, this.chromosome, false);
        if (trId == null) {
            trId = "Tr_" + start + "_" + end;
        }
        if ((tr = this.findTranscript(trId)) == null) {
            if (this.debug) {
                System.err.println("Transcript '" + trId + "' not found. Creating new transcript for gene '" + gene.getId() + "'.\n" + fcds);
            }
            tr = new Transcript(gene, start, end, fcds.isComplement(), trId);
            this.add(tr);
        }
        return tr;
    }

    Transcript findTrFromLatest(Feature fcds, Gene geneLatest, List<Transcript> trLatest) {
        if (trLatest == null) {
            return null;
        }
        if (this.cdsMatchesGene(fcds, geneLatest)) {
            for (Transcript tr : trLatest) {
                if (!tr.getCds().isEmpty() || !this.cdsMatchesTr(fcds, tr)) continue;
                return tr;
            }
        }
        return null;
    }

    protected String geneId(Feature f2, int start, int end) {
        String geneId = f2.getGeneId();
        if (geneId != null) {
            return geneId;
        }
        return "Gene_" + start + "_" + end;
    }

    protected String geneName(Feature f2, int start, int end) {
        String geneName = f2.getGeneName();
        if (geneName != null) {
            return geneName;
        }
        return "Gene_" + start + "_" + end;
    }

    @Override
    public Map<String, String> getProteinByTrId() {
        return this.proteinByTrId;
    }

    String sequence(Features features) {
        String seq2 = features.getSequence();
        if (seq2 != null && !seq2.isEmpty()) {
            return seq2;
        }
        if (this.verbose) {
            System.out.println("No sequence found in feature file.");
        }
        for (String fastaFile : this.config.getFileListGenomeFasta()) {
            if (this.verbose) {
                System.out.println("\tTrying fasta file '" + fastaFile + "'");
            }
            if (!Gpr.canRead(fastaFile) || (seq2 = GprSeq.fastaSimpleRead(fastaFile)) == null || seq2.isEmpty()) continue;
            return seq2;
        }
        throw new RuntimeException("Cannot find sequence for '" + this.config.getGenome().getVersion() + "'");
    }
}

