/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.SAMFileReader;
import org.snpeff.SnpEff;
import org.snpeff.coverage.CountReadsOnMarkers;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.stats.ReadsOnMarkersModel;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdCount
extends SnpEff {
    boolean calcProbModel;
    String outputBaseNames;
    CountReadsOnMarkers countReadsOnMarkers;
    SnpEffectPredictor snpEffectPredictor;
    List<String> fileNames = new ArrayList<String>();

    int countTotalReads(String samFileName) {
        try {
            if (this.verbose) {
                Timer.showStdErr("Counting reads on file: " + samFileName);
            }
            SAMFileReader samReader = new SAMFileReader(new File(samFileName));
            AbstractBAMFileIndex index = (AbstractBAMFileIndex)samReader.getIndex();
            int count2 = 0;
            for (int i = 0; i < index.getNumberOfReferences(); ++i) {
                BAMIndexMetaData meta = index.getMetaData(i);
                count2 += meta.getAlignedRecordCount();
            }
            samReader.close();
            if (this.verbose) {
                Timer.showStdErr("Total " + count2 + " reads.");
            }
            return count2;
        }
        catch (Exception e) {
            System.err.println("ERROR! BAM file not indexed?");
            return -1;
        }
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                this.calcProbModel = true;
                continue;
            }
            if (args[i].equals("-n")) {
                this.outputBaseNames = args[++i];
                continue;
            }
            if (this.genomeVer == null || this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            this.fileNames.add(args[i]);
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genome version");
        }
        if (this.fileNames.size() < 1) {
            this.usage("Missing input file/s");
        }
        for (String file : this.fileNames) {
            if (Gpr.canRead(file)) continue;
            this.fatalError("Cannot read input file '" + file + "'");
        }
        for (String file : this.customIntervalFiles) {
            if (Gpr.canRead(file)) continue;
            this.fatalError("Cannot read custom intervals file '" + file + "'");
        }
        if (this.noGenome && this.customIntervalFiles.isEmpty()) {
            this.usage("No user defined intervals were defined (mandatory if '-noGenome' option is enabled)");
        }
    }

    ReadsOnMarkersModel pvalues() {
        int readLength = this.countReadsOnMarkers.getReadLengthAvg();
        if (this.verbose) {
            Timer.showStdErr("Calculating probability model for read length " + readLength);
        }
        ReadsOnMarkersModel readsOnMarkersModel = new ReadsOnMarkersModel(this.snpEffectPredictor);
        readsOnMarkersModel.setReadLength(readLength);
        readsOnMarkersModel.setVerbose(this.verbose);
        readsOnMarkersModel.setMarkerTypes(this.countReadsOnMarkers.getMarkerTypes());
        readsOnMarkersModel.run();
        Timer.showStdErr("Probability model:\n" + readsOnMarkersModel.toString());
        return readsOnMarkersModel;
    }

    @Override
    public boolean run() {
        this.loadConfig();
        this.loadDb();
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.snpEffectPredictor.buildForest();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        this.countReadsOnMarkers = new CountReadsOnMarkers(this.snpEffectPredictor);
        this.countReadsOnMarkers.setVerbose(this.verbose);
        for (String file : this.fileNames) {
            this.countReadsOnMarkers.addFile(file);
        }
        this.countReadsOnMarkers.count();
        if (!this.quiet) {
            if (this.outputBaseNames != null) {
                String detailsFile = this.outputBaseNames + ".txt";
                if (this.verbose) {
                    Timer.showStdErr("Saving counts by marker to file '" + detailsFile + "'");
                }
                Gpr.toFile(detailsFile, this.countReadsOnMarkers);
            } else {
                System.out.println(this.countReadsOnMarkers);
            }
            ReadsOnMarkersModel readsOnMarkersModel = new ReadsOnMarkersModel(this.snpEffectPredictor);
            if (this.calcProbModel) {
                readsOnMarkersModel = this.pvalues();
            }
            if (this.outputBaseNames != null) {
                String summaryFile = this.outputBaseNames + ".summary.txt";
                if (this.verbose) {
                    Timer.showStdErr("Saving summary to file '" + summaryFile + "'");
                }
                Gpr.toFile(summaryFile, "# Summary\n" + this.countReadsOnMarkers.probabilityTable(readsOnMarkersModel.getProb()));
            } else {
                System.err.println("# Summary\n" + this.countReadsOnMarkers.probabilityTable(readsOnMarkersModel.getProb()));
            }
            String htmlFile = "snpeff.count.html";
            if (this.outputBaseNames != null) {
                htmlFile = this.outputBaseNames + ".summary.html";
            }
            if (this.verbose) {
                Timer.showStdErr("Saving charts to file : " + htmlFile);
            }
            Gpr.toFile(htmlFile, this.countReadsOnMarkers.html());
        }
        return true;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + VERSION);
        System.err.println("Usage: snpEff count [options] genome file_1 file_2 ...  file_N");
        System.err.println("\t-n name          : Output file base name. ");
        System.err.println("\t-p               : Calculate probability model (binomial). Default: " + this.calcProbModel);
        System.err.println("\tfile             : A file contianing intervals or reads. Either BAM, SAM, VCF, BED or BigBed format.");
        this.usageGenericAndDb();
        System.exit(-1);
    }
}

