/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import java.util.Iterator;
import java.util.List;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChangeDel;
import org.snpeff.interval.codonChange.CodonChangeDup;
import org.snpeff.interval.codonChange.CodonChangeIns;
import org.snpeff.interval.codonChange.CodonChangeInterval;
import org.snpeff.interval.codonChange.CodonChangeInv;
import org.snpeff.interval.codonChange.CodonChangeMixed;
import org.snpeff.interval.codonChange.CodonChangeMnp;
import org.snpeff.interval.codonChange.CodonChangeSnp;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public class CodonChange {
    public static boolean showCodonChange = true;
    public static final int CODON_SIZE = 3;
    boolean returnNow = false;
    boolean requireNetCdsChange = false;
    Variant variant;
    Transcript transcript;
    Exon exon = null;
    VariantEffects variantEffects;
    int codonStartNum = -1;
    int codonStartIndex = -1;
    String codonsRef = "";
    String codonsAlt = "";
    String netCdsChange = "";

    public static CodonChange factory(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        switch (variant.getVariantType()) {
            case SNP: {
                return new CodonChangeSnp(variant, transcript, variantEffects);
            }
            case INS: {
                return new CodonChangeIns(variant, transcript, variantEffects);
            }
            case DEL: {
                return new CodonChangeDel(variant, transcript, variantEffects);
            }
            case MNP: {
                return new CodonChangeMnp(variant, transcript, variantEffects);
            }
            case MIXED: {
                return new CodonChangeMixed(variant, transcript, variantEffects);
            }
            case DUP: {
                return new CodonChangeDup(variant, transcript, variantEffects);
            }
            case INV: {
                return new CodonChangeInv(variant, transcript, variantEffects);
            }
            case INTERVAL: {
                return new CodonChangeInterval(variant, transcript, variantEffects);
            }
        }
        throw new RuntimeException("Unimplemented factory for variant type '" + (Object)((Object)variant.getVariantType()) + "', variant: " + variant);
    }

    protected CodonChange(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        this.transcript = transcript;
        this.variantEffects = variantEffects;
        this.variant = variant;
    }

    protected EffectType additionalEffect(String codonsOld, String codonsNew, int codonNum, int codonIndex, String aaOld, String aaNew) {
        EffectType newEffectType = null;
        CodonTable codonTable = this.transcript.codonTable();
        if (this.variant.isSnp() || this.variant.isMnp()) {
            newEffectType = aaOld.equals(aaNew) ? (codonNum == 0 && codonTable.isStartFirst(codonsOld) ? (codonTable.isStartFirst(codonsNew) ? EffectType.SYNONYMOUS_START : EffectType.START_LOST) : (codonTable.isStop(codonsOld) ? (codonTable.isStop(codonsNew) ? EffectType.SYNONYMOUS_STOP : EffectType.STOP_LOST) : EffectType.SYNONYMOUS_CODING)) : (codonNum == 0 && codonTable.isStartFirst(codonsOld) ? (codonTable.isStartFirst(codonsNew) ? EffectType.NON_SYNONYMOUS_START : EffectType.START_LOST) : (codonTable.isStop(codonsOld) ? (codonTable.isStop(codonsNew) ? EffectType.NON_SYNONYMOUS_STOP : EffectType.STOP_LOST) : (codonTable.isStop(codonsNew) ? EffectType.STOP_GAINED : EffectType.NON_SYNONYMOUS_CODING)));
        } else if (codonNum == 0 && codonTable.isStartFirst(codonsOld) && !codonTable.isStartFirst(codonsNew)) {
            newEffectType = EffectType.START_LOST;
        } else if (codonTable.isStop(codonsOld) && !codonTable.isStop(codonsNew)) {
            newEffectType = EffectType.STOP_LOST;
        } else if (!codonTable.isStop(codonsOld) && codonTable.isStop(codonsNew)) {
            newEffectType = EffectType.STOP_GAINED;
        }
        return newEffectType;
    }

    protected int cdsBaseNumber(int pos) {
        int cdsbn = this.transcript.baseNumberCds(pos, true);
        if (cdsbn < 0) {
            if (pos <= this.transcript.getCdsStart()) {
                if (this.transcript.isStrandPlus()) {
                    return 0;
                }
                return this.transcript.cds().length();
            }
            if (this.transcript.isStrandPlus()) {
                return this.transcript.cds().length();
            }
            return 0;
        }
        return cdsbn;
    }

    public void codonChange() {
        if (!this.transcript.intersects(this.variant)) {
            return;
        }
        int cdsStart = this.transcript.getCdsStart();
        this.netCdsChange = this.netCdsChange();
        if (this.requireNetCdsChange && this.netCdsChange.isEmpty()) {
            this.codonsAlt = "";
            this.codonsRef = "";
            return;
        }
        int firstCdsBaseInExon = 0;
        List exons = this.transcript.sortedStrand();
        Iterator iterator2 = exons.iterator();
        while (iterator2.hasNext()) {
            Exon exon;
            this.exon = exon = (Exon)iterator2.next();
            if (exon.intersects(this.variant)) {
                int cdsBaseInExon = -1;
                if (this.transcript.isStrandPlus()) {
                    int firstvariantBaseInExon = Math.max(this.variant.getStart(), Math.max(exon.getStart(), cdsStart));
                    cdsBaseInExon = firstvariantBaseInExon - Math.max(exon.getStart(), cdsStart);
                } else {
                    int lastvariantBaseInExon = Math.min(this.variant.getEnd(), Math.min(exon.getEnd(), cdsStart));
                    cdsBaseInExon = Math.min(exon.getEnd(), cdsStart) - lastvariantBaseInExon;
                }
                if (cdsBaseInExon < 0) {
                    cdsBaseInExon = 0;
                }
                if (this.codonStartNum < 0) {
                    this.codonStartNum = (firstCdsBaseInExon + cdsBaseInExon) / 3;
                    this.codonStartIndex = (firstCdsBaseInExon + cdsBaseInExon) % 3;
                }
                boolean hasChanged = false;
                hasChanged = this.codonChange(exon);
                if (hasChanged && !this.variantEffects.hasMarker()) {
                    this.variantEffects.setMarker(exon);
                }
                if (this.returnNow) {
                    return;
                }
            }
            if (this.transcript.isStrandPlus()) {
                firstCdsBaseInExon += Math.max(0, exon.getEnd() - Math.max(exon.getStart(), cdsStart) + 1);
                continue;
            }
            firstCdsBaseInExon += Math.max(0, Math.min(cdsStart, exon.getEnd()) - exon.getStart() + 1);
        }
    }

    protected boolean codonChange(Exon exon) {
        throw new RuntimeException("Unimplemented method codonChangeSingle() for\n\t\tVariant type : " + (Object)((Object)this.variant.getType()) + "\n\t\tClass        : " + this.getClass().getSimpleName() + "\n\t\tVariant      : " + this.variant);
    }

    protected String codonsAlt() {
        throw new RuntimeException("Unimplemented method for this thype of CodonChange: " + this.getClass().getSimpleName());
    }

    protected String codonsRef() {
        return this.codonsRef(1);
    }

    protected String codonsRef(int numCodons) {
        String cds = this.transcript.cds();
        String codon = "";
        int start = this.codonStartNum * 3;
        int end = start + numCodons * 3;
        int len = cds.length();
        if (start >= cds.length()) {
            start = len;
        }
        if (end >= cds.length()) {
            end = len;
        }
        if ((codon = cds.substring(start, end)).length() % 3 == 1) {
            codon = codon + "NN";
        } else if (codon.length() % 3 == 2) {
            codon = codon + "N";
        }
        return codon;
    }

    protected VariantEffect effect(Marker marker, EffectType effectType, boolean allowReplace) {
        return this.effect(marker, effectType, effectType.effectImpact(), this.codonsRef, this.codonsAlt, this.codonStartNum, this.codonStartIndex, allowReplace);
    }

    private VariantEffect effect(Marker marker, EffectType effectType, VariantEffect.EffectImpact effectImpact, String codonsOld, String codonsNew, int codonNum, int codonIndex, boolean allowReplace) {
        int cDnaPos = this.transcript.baseNumber2MRnaPos(this.variant.getStart());
        VariantEffect varEff = new VariantEffect(this.variant, marker, effectType, effectImpact, codonsOld, codonsNew, codonNum, codonIndex, cDnaPos);
        this.variantEffects.add(varEff);
        EffectType addEffType = this.additionalEffect(codonsOld, codonsNew, codonNum, codonIndex, varEff.getAaRef(), varEff.getAaAlt());
        if (addEffType != null && addEffType != effectType) {
            if (allowReplace && addEffType.compareTo(effectType) < 0) {
                varEff.setEffect(addEffType);
            } else {
                varEff.addEffect(addEffType);
            }
        }
        return varEff;
    }

    protected VariantEffect effectNoCodon(Marker marker, EffectType effectType) {
        return this.effect(marker, effectType, effectType.effectImpact(), "", "", -1, -1, false);
    }

    protected VariantEffect effectNoCodon(Marker marker, EffectType effectType, VariantEffect.EffectImpact effectImpact) {
        return this.effect(marker, effectType, effectImpact, "", "", -1, -1, false);
    }

    protected boolean intersectsExons() {
        for (Exon ex : this.transcript) {
            if (!this.variant.intersects(ex)) continue;
            return true;
        }
        return false;
    }

    protected String netCdsChange() {
        if (!this.requireNetCdsChange) {
            return "";
        }
        if (this.variant.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Exon exon : this.transcript.sortedStrand()) {
                sb.append(this.variant.netChange(exon));
            }
            return sb.toString();
        }
        return this.variant.netChange(this.transcript.isStrandMinus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transcript : " + this.transcript.getId() + "\n");
        sb.append("Variant    : " + this.variant + "\n");
        sb.append("Codons     : " + this.codonsRef + "/" + this.codonsAlt + "\tnum: " + this.codonStartNum + "\tidx: " + this.codonStartIndex + "\n");
        sb.append("Effects    :\n");
        for (VariantEffect veff : this.variantEffects) {
            sb.append("\t" + veff.getEffectTypeString(false) + "\t" + veff.getCodonsRef() + "/" + veff.getCodonsAlt() + "\t" + veff.getAaRef() + "/" + veff.getAaAlt() + "\n");
        }
        return sb.toString();
    }
}

