/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.LinkedList;
import java.util.List;
import org.snpeff.interval.Marker;
import org.snpeff.interval.ProteinProteinInteractionLocus;
import org.snpeff.interval.ProteinStructuralInteractionLocus;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public abstract class ProteinInteractionLocus
extends Marker {
    private static final long serialVersionUID = 1L;
    public static final boolean debug = false;

    private static ProteinInteractionLocus factory(Transcript tr, int start, int end, Transcript trInteract, String id) {
        String geneId1 = tr.getParent().getId();
        String geneId2 = trInteract.getParent().getId();
        int s = Math.min(start, end);
        int e = Math.max(start, end);
        if (geneId1.equals(geneId2)) {
            return new ProteinStructuralInteractionLocus(tr, s, e, id);
        }
        return new ProteinProteinInteractionLocus(tr, s, e, trInteract, id);
    }

    public static List<ProteinInteractionLocus> factory(Transcript tr, int aaPos, Transcript trInteract, String id) {
        int start;
        LinkedList<ProteinInteractionLocus> list2 = new LinkedList<ProteinInteractionLocus>();
        int[] codon2pos = tr.codonNumber2Pos(aaPos);
        int j = tr.isStrandPlus() ? 0 : 2;
        int step2 = tr.isStrandPlus() ? 1 : -1;
        int prev = start = codon2pos[j];
        int pos = start;
        j += step2;
        while (0 <= j && j <= 2) {
            pos = codon2pos[j];
            if (pos != prev + step2) {
                list2.add(ProteinInteractionLocus.factory(tr, start, prev, trInteract, id));
                start = pos;
            }
            j += step2;
            prev = pos;
        }
        list2.add(ProteinInteractionLocus.factory(tr, start, pos, trInteract, id));
        return list2;
    }

    public ProteinInteractionLocus() {
    }

    public ProteinInteractionLocus(Transcript parent, int start, int end, String id) {
        super(parent, start, end, false, id);
    }

    @Override
    public ProteinInteractionLocus cloneShallow() {
        ProteinInteractionLocus clone2 = (ProteinInteractionLocus)super.cloneShallow();
        return clone2;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        variantEffects.add(variant, this, this.type, VariantEffect.EffectImpact.HIGH, "");
        return true;
    }
}

