/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.snpeff.interval.Interval;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.serializer.MarkerSerializer;

public class IntervalAndSubIntervals<T extends Marker>
extends Marker
implements Iterable<T> {
    private static final long serialVersionUID = 1636197649250882952L;
    Map<String, T> subIntervals;
    List<T> sorted;
    List<T> sortedStrand;

    public IntervalAndSubIntervals() {
        this.reset();
    }

    public IntervalAndSubIntervals(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.reset();
    }

    public synchronized void add(T t) {
        if (this.subIntervals.put(((Interval)t).getId(), t) != null) {
            throw new RuntimeException(t.getClass().getSimpleName() + " '" + ((Interval)t).getId() + "' is already in " + this.getClass().getSimpleName() + " '" + this.id + "'");
        }
        this.invalidateSorted();
    }

    public void addAll(Iterable<T> ts) {
        for (Marker t : ts) {
            this.add(t);
        }
        this.invalidateSorted();
    }

    public void addAll(Markers markers) {
        for (Marker m : markers) {
            this.add(m);
        }
        this.invalidateSorted();
    }

    @Override
    public IntervalAndSubIntervals<T> apply(Variant variant) {
        if (!this.shouldApply(variant)) {
            return this;
        }
        IntervalAndSubIntervals newMarker = (IntervalAndSubIntervals)super.apply(variant);
        if (newMarker == null) {
            return null;
        }
        newMarker.reset();
        for (Marker m : this) {
            Marker mcopy;
            if (variant.isDup() && variant.includes(m)) {
                mcopy = m.cloneShallow();
                mcopy.setId(mcopy.getId() + ".dup");
                mcopy.setParent(newMarker);
                newMarker.add(mcopy);
            }
            if ((mcopy = m.apply(variant)) == null) continue;
            if (mcopy == m) {
                mcopy = m.cloneShallow();
            }
            mcopy.setParent(newMarker);
            newMarker.add(mcopy);
        }
        return newMarker;
    }

    @Override
    public IntervalAndSubIntervals<T> clone() {
        IntervalAndSubIntervals copy = (IntervalAndSubIntervals)super.clone();
        copy.reset();
        for (Marker m : this) {
            Marker mcopy = m.clone();
            mcopy.setParent(copy);
            copy.add(mcopy);
        }
        return copy;
    }

    @Override
    public IntervalAndSubIntervals<T> cloneShallow() {
        IntervalAndSubIntervals clone2 = (IntervalAndSubIntervals)super.cloneShallow();
        clone2.reset();
        return clone2;
    }

    public boolean containsId(String id) {
        return this.subIntervals.containsKey(id);
    }

    public T get(String id) {
        return (T)((Marker)this.subIntervals.get(id));
    }

    protected void invalidateSorted() {
        this.sortedStrand = null;
        this.sorted = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.subIntervals().iterator();
    }

    public Markers markers() {
        Markers markers = new Markers();
        markers.addAll((Collection<? extends Marker>)this.subIntervals());
        return markers;
    }

    public int numChilds() {
        return this.subIntervals != null ? this.subIntervals.size() : 0;
    }

    @Override
    public Markers query(Marker marker) {
        Markers markers = new Markers();
        for (Marker m : this) {
            if (!m.intersects(marker)) continue;
            markers.add(m);
            Markers subMarkers = m.query(marker);
            if (subMarkers == null) continue;
            markers.add(subMarkers);
        }
        return markers;
    }

    public synchronized void remove(T t) {
        this.subIntervals.remove(((Interval)t).getId());
        this.invalidateSorted();
    }

    public synchronized void reset() {
        this.subIntervals = new HashMap<String, T>();
        this.invalidateSorted();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        Markers markers = markerSerializer.getNextFieldMarkers();
        for (Marker m : markers) {
            this.add(m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + markerSerializer.save(this.subIntervals());
    }

    @Override
    public void setStrandMinus(boolean strandMinus) {
        this.strandMinus = strandMinus;
        for (Marker t : this) {
            t.setStrandMinus(strandMinus);
        }
        this.invalidateSorted();
    }

    @Override
    public void shiftCoordinates(int shift) {
        super.shiftCoordinates(shift);
        for (Marker m : this.subIntervals()) {
            m.shiftCoordinates(shift);
        }
    }

    public synchronized List<T> sorted() {
        if (this.sorted != null) {
            return this.sorted;
        }
        ArrayList<T> sorted2 = new ArrayList<T>();
        sorted2.addAll(this.subIntervals());
        Collections.sort(sorted2);
        this.sorted = sorted2;
        return sorted2;
    }

    public synchronized List<T> sortedStrand() {
        if (this.sortedStrand != null) {
            return this.sortedStrand;
        }
        ArrayList<T> sortedStrand = new ArrayList<T>();
        sortedStrand.addAll(this.subIntervals());
        if (this.isStrandPlus()) {
            Collections.sort(sortedStrand, new IntervalComparatorByStart());
        } else {
            Collections.sort(sortedStrand, new IntervalComparatorByEnd(true));
        }
        this.sortedStrand = sortedStrand;
        return sortedStrand;
    }

    public Collection<T> subIntervals() {
        return this.subIntervals.values();
    }
}

