/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.uuid;

import com.eaio.util.lang.Hex;
import com.eaio.uuid.UUIDGen;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class UUID
implements Comparable<UUID>,
Serializable,
Cloneable {
    static final long serialVersionUID = 7435962790062944603L;
    public long time;
    public long clockSeqAndNode;

    public UUID() {
        this(UUIDGen.newTime(), UUIDGen.getClockSeqAndNode());
    }

    public UUID(long l, long l2) {
        this.time = l;
        this.clockSeqAndNode = l2;
    }

    public UUID(UUID uUID) {
        this(uUID.time, uUID.clockSeqAndNode);
    }

    public UUID(CharSequence charSequence) {
        this(Hex.parseLong(charSequence.subSequence(0, 18)), Hex.parseLong(charSequence.subSequence(19, 36)));
    }

    @Override
    public int compareTo(UUID uUID) {
        if (this == uUID) {
            return 0;
        }
        if (this.time > uUID.time) {
            return 1;
        }
        if (this.time < uUID.time) {
            return -1;
        }
        if (this.clockSeqAndNode > uUID.clockSeqAndNode) {
            return 1;
        }
        if (this.clockSeqAndNode < uUID.clockSeqAndNode) {
            return -1;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.time);
        objectOutputStream.writeLong(this.clockSeqAndNode);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.time = objectInputStream.readLong();
        this.clockSeqAndNode = objectInputStream.readLong();
    }

    public final String toString() {
        return this.toAppendable(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        if (stringBuffer2 == null) {
            stringBuffer2 = new StringBuffer(36);
        } else {
            stringBuffer2.ensureCapacity(stringBuffer2.length() + 36);
        }
        return (StringBuffer)this.toAppendable(stringBuffer2);
    }

    public Appendable toAppendable(Appendable appendable) {
        Appendable appendable2 = appendable;
        if (appendable2 == null) {
            appendable2 = new StringBuilder(36);
        }
        try {
            Hex.append(appendable2, (int)(this.time >> 32)).append('-');
            Hex.append(appendable2, (short)(this.time >> 16)).append('-');
            Hex.append(appendable2, (short)this.time).append('-');
            Hex.append(appendable2, (short)(this.clockSeqAndNode >> 48)).append('-');
            Hex.append(appendable2, this.clockSeqAndNode, 12);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable2;
    }

    public int hashCode() {
        return (int)(this.time >> 32 ^ this.time ^ this.clockSeqAndNode >> 32 ^ this.clockSeqAndNode);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final long getTime() {
        return this.time;
    }

    public final long getClockSeqAndNode() {
        return this.clockSeqAndNode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UUID)) {
            return false;
        }
        return this.compareTo((UUID)object) == 0;
    }

    public static UUID nilUUID() {
        return new UUID(0L, 0L);
    }
}

