/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class GammaDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -3239549463135430361L;
    private final double alpha;
    private final double beta;
    private final double solverAbsoluteAccuracy;

    public GammaDistribution(double alpha, double beta) {
        this(alpha, beta, 1.0E-9);
    }

    public GammaDistribution(double alpha, double beta, double inverseCumAccuracy) throws NotStrictlyPositiveException {
        if (alpha <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.ALPHA, alpha);
        }
        if (beta <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.BETA, beta);
        }
        this.alpha = alpha;
        this.beta = beta;
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double probability(double x) {
        return 0.0;
    }

    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return FastMath.pow(x / this.beta, this.alpha - 1.0) / this.beta * FastMath.exp(-x / this.beta) / FastMath.exp(Gamma.logGamma(this.alpha));
    }

    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.alpha, x / this.beta);
        return ret;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        return this.getAlpha() * this.getBeta();
    }

    public double getNumericalVariance() {
        double b = this.getBeta();
        return this.getAlpha() * b * b;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

