/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.imports.CaseKeeper;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class CleanUpAction
extends AbstractWorker {
    private Logger logger = Logger.getLogger(CleanUpAction.class.getName());
    public static final String AKS_AUTO_NAMING_PDFS_AGAIN = "AskAutoNamingPDFsAgain";
    public static final String CLEANUP_DOI = "CleanUpDOI";
    public static final String CLEANUP_MONTH = "CleanUpMonth";
    public static final String CLEANUP_PAGENUMBERS = "CleanUpPageNumbers";
    public static final String CLEANUP_MAKEPATHSRELATIVE = "CleanUpMakePathsRelative";
    public static final String CLEANUP_RENAMEPDF = "CleanUpRenamePDF";
    public static final String CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS = "CleanUpRenamePDFonlyRelativePaths";
    public static final String CLEANUP_UPGRADE_EXTERNAL_LINKS = "CleanUpUpgradeExternalLinks";
    public static final String CLEANUP_SUPERSCRIPTS = "CleanUpSuperscripts";
    public static final String CLEANUP_HTML = "CleanUpHTML";
    public static final String CLEANUP_CASE = "CleanUpCase";
    public static final String CLEANUP_LATEX = "CleanUpLaTeX";
    private JCheckBox cleanUpSuperscrips;
    private JCheckBox cleanUpDOI;
    private JCheckBox cleanUpMonth;
    private JCheckBox cleanUpPageNumbers;
    private JCheckBox cleanUpMakePathsRelative;
    private JCheckBox cleanUpRenamePDF;
    private JCheckBox cleanUpRenamePDFonlyRelativePaths;
    private JCheckBox cleanUpUpgradeExternalLinks;
    private JCheckBox cleanUpHTML;
    private JCheckBox cleanUpCase;
    private JCheckBox cleanUpLaTeX;
    private JPanel optionsPanel = new JPanel();
    private BasePanel panel;
    private JabRefFrame frame;
    int unsuccesfullRenames = 0;
    boolean cancelled;
    int modifiedEntriesCount;
    int numSelected;

    public static void putDefaults(HashMap<String, Object> defaults) {
        defaults.put(AKS_AUTO_NAMING_PDFS_AGAIN, Boolean.TRUE);
        defaults.put(CLEANUP_SUPERSCRIPTS, Boolean.TRUE);
        defaults.put(CLEANUP_DOI, Boolean.TRUE);
        defaults.put(CLEANUP_MONTH, Boolean.TRUE);
        defaults.put(CLEANUP_PAGENUMBERS, Boolean.TRUE);
        defaults.put(CLEANUP_MAKEPATHSRELATIVE, Boolean.TRUE);
        defaults.put(CLEANUP_RENAMEPDF, Boolean.TRUE);
        defaults.put(CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS, Boolean.FALSE);
        defaults.put(CLEANUP_UPGRADE_EXTERNAL_LINKS, Boolean.FALSE);
        defaults.put(CLEANUP_MAKEPATHSRELATIVE, Boolean.TRUE);
        defaults.put(CLEANUP_HTML, Boolean.TRUE);
        defaults.put(CLEANUP_CASE, Boolean.TRUE);
        defaults.put(CLEANUP_LATEX, Boolean.TRUE);
    }

    public CleanUpAction(BasePanel panel) {
        this.panel = panel;
        this.frame = panel.frame();
        this.initOptionsPanel();
    }

    private void initOptionsPanel() {
        this.cleanUpSuperscrips = new JCheckBox(Globals.lang("Convert 1st, 2nd, ... to real superscripts"));
        this.cleanUpDOI = new JCheckBox(Globals.lang("Move DOIs from note and URL field to DOI field and remove http prefix"));
        this.cleanUpMonth = new JCheckBox(Globals.lang("Format content of month field to #mon#"));
        this.cleanUpPageNumbers = new JCheckBox(Globals.lang("Ensure that page ranges are of the form num1--num2"));
        this.cleanUpMakePathsRelative = new JCheckBox(Globals.lang("Make paths of linked files relative (if possible)"));
        this.cleanUpRenamePDF = new JCheckBox(Globals.lang("Rename PDFs to given file name format pattern"));
        this.cleanUpRenamePDF.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                CleanUpAction.this.cleanUpRenamePDFonlyRelativePaths.setEnabled(CleanUpAction.this.cleanUpRenamePDF.isSelected());
            }
        });
        this.cleanUpRenamePDFonlyRelativePaths = new JCheckBox(Globals.lang("Rename only PDFs having a relative path"));
        this.cleanUpUpgradeExternalLinks = new JCheckBox(Globals.lang("Upgrade external PDF/PS links to use the '%0' field.", "file"));
        this.cleanUpHTML = new JCheckBox(Globals.lang("Run HTML converter on title"));
        this.cleanUpCase = new JCheckBox(Globals.lang("Run filter on title keeping the case of selected words"));
        this.cleanUpLaTeX = new JCheckBox(Globals.lang("Remove unneccessary $, {, and }"));
        this.optionsPanel = new JPanel();
        this.retrieveSettings();
        FormLayout layout = new FormLayout("left:15dlu,pref:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, this.optionsPanel);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.cleanUpHTML, cc.xyw(1, 1, 2));
        builder.add((Component)this.cleanUpCase, cc.xyw(1, 2, 2));
        builder.add((Component)this.cleanUpLaTeX, cc.xyw(1, 3, 2));
        builder.add((Component)this.cleanUpSuperscrips, cc.xyw(1, 4, 2));
        builder.add((Component)this.cleanUpDOI, cc.xyw(1, 5, 2));
        builder.add((Component)this.cleanUpMonth, cc.xyw(1, 6, 2));
        builder.add((Component)this.cleanUpPageNumbers, cc.xyw(1, 7, 2));
        builder.add((Component)this.cleanUpUpgradeExternalLinks, cc.xyw(1, 8, 2));
        builder.add((Component)this.cleanUpMakePathsRelative, cc.xyw(1, 9, 2));
        builder.add((Component)this.cleanUpRenamePDF, cc.xyw(1, 10, 2));
        String currentPattern = Globals.lang("File name format pattern").concat(": ").concat(Globals.prefs.get("importFileNamePattern"));
        builder.add((Component)new JLabel(currentPattern), cc.xyw(2, 11, 1));
        builder.add((Component)this.cleanUpRenamePDFonlyRelativePaths, cc.xyw(2, 12, 1));
    }

    private void retrieveSettings() {
        this.cleanUpSuperscrips.setSelected(Globals.prefs.getBoolean(CLEANUP_SUPERSCRIPTS));
        this.cleanUpDOI.setSelected(Globals.prefs.getBoolean(CLEANUP_DOI));
        this.cleanUpMonth.setSelected(Globals.prefs.getBoolean(CLEANUP_MONTH));
        this.cleanUpPageNumbers.setSelected(Globals.prefs.getBoolean(CLEANUP_PAGENUMBERS));
        this.cleanUpMakePathsRelative.setSelected(Globals.prefs.getBoolean(CLEANUP_MAKEPATHSRELATIVE));
        this.cleanUpRenamePDF.setSelected(Globals.prefs.getBoolean(CLEANUP_RENAMEPDF));
        this.cleanUpRenamePDFonlyRelativePaths.setSelected(Globals.prefs.getBoolean(CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS));
        this.cleanUpRenamePDFonlyRelativePaths.setEnabled(this.cleanUpRenamePDF.isSelected());
        this.cleanUpUpgradeExternalLinks.setSelected(Globals.prefs.getBoolean(CLEANUP_UPGRADE_EXTERNAL_LINKS));
        this.cleanUpHTML.setSelected(Globals.prefs.getBoolean(CLEANUP_HTML));
        this.cleanUpCase.setSelected(Globals.prefs.getBoolean(CLEANUP_CASE));
        this.cleanUpLaTeX.setSelected(Globals.prefs.getBoolean(CLEANUP_LATEX));
    }

    private void storeSettings() {
        Globals.prefs.putBoolean(CLEANUP_SUPERSCRIPTS, this.cleanUpSuperscrips.isSelected());
        Globals.prefs.putBoolean(CLEANUP_DOI, this.cleanUpDOI.isSelected());
        Globals.prefs.putBoolean(CLEANUP_MONTH, this.cleanUpMonth.isSelected());
        Globals.prefs.putBoolean(CLEANUP_PAGENUMBERS, this.cleanUpPageNumbers.isSelected());
        Globals.prefs.putBoolean(CLEANUP_MAKEPATHSRELATIVE, this.cleanUpMakePathsRelative.isSelected());
        Globals.prefs.putBoolean(CLEANUP_RENAMEPDF, this.cleanUpRenamePDF.isSelected());
        Globals.prefs.putBoolean(CLEANUP_RENAMEPDF_ONLYRELATIVE_PATHS, this.cleanUpRenamePDFonlyRelativePaths.isSelected());
        Globals.prefs.putBoolean(CLEANUP_UPGRADE_EXTERNAL_LINKS, this.cleanUpUpgradeExternalLinks.isSelected());
        Globals.prefs.putBoolean(CLEANUP_HTML, this.cleanUpHTML.isSelected());
        Globals.prefs.putBoolean(CLEANUP_CASE, this.cleanUpCase.isSelected());
        Globals.prefs.putBoolean(CLEANUP_LATEX, this.cleanUpLaTeX.isSelected());
    }

    private int showCleanUpDialog() {
        String dialogTitle = Globals.lang("Cleanup entries");
        Object[] messages = new Object[]{Globals.lang("What would you like to clean up?"), this.optionsPanel};
        return JOptionPane.showConfirmDialog(this.frame, messages, dialogTitle, 2, 3);
    }

    @Override
    public void init() {
        this.cancelled = false;
        this.modifiedEntriesCount = 0;
        int numSelected = this.panel.getSelectedEntries().length;
        if (numSelected == 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("First select entries to clean up."), Globals.lang("Cleanup entry"), 1);
            this.cancelled = true;
            return;
        }
        this.frame.block();
        this.panel.output(Globals.lang("Doing a cleanup for %0 entries...", Integer.toString(numSelected)));
    }

    @Override
    public void run() {
        NamedCompound ce;
        if (this.cancelled) {
            return;
        }
        int choice = this.showCleanUpDialog();
        if (choice != 0) {
            this.cancelled = true;
            return;
        }
        this.storeSettings();
        boolean choiceCleanUpSuperscripts = this.cleanUpSuperscrips.isSelected();
        boolean choiceCleanUpDOI = this.cleanUpDOI.isSelected();
        boolean choiceCleanUpMonth = this.cleanUpMonth.isSelected();
        boolean choiceCleanUpPageNumbers = this.cleanUpPageNumbers.isSelected();
        boolean choiceCleanUpUpgradeExternalLinks = this.cleanUpUpgradeExternalLinks.isSelected();
        boolean choiceMakePathsRelative = this.cleanUpMakePathsRelative.isSelected();
        boolean choiceRenamePDF = this.cleanUpRenamePDF.isSelected();
        boolean choiceConvertHTML = this.cleanUpHTML.isSelected();
        boolean choiceConvertCase = this.cleanUpCase.isSelected();
        boolean choiceConvertLaTeX = this.cleanUpLaTeX.isSelected();
        if (choiceRenamePDF && Globals.prefs.getBoolean(AKS_AUTO_NAMING_PDFS_AGAIN)) {
            CheckBoxMessage cbm = new CheckBoxMessage(Globals.lang("Auto-generating PDF-Names does not support undo. Continue?"), Globals.lang("Disable this confirmation dialog"), false);
            int answer = JOptionPane.showConfirmDialog(this.frame, cbm, Globals.lang("Autogenerate PDF Names"), 0);
            if (cbm.isSelected()) {
                Globals.prefs.putBoolean(AKS_AUTO_NAMING_PDFS_AGAIN, false);
            }
            if (answer == 1) {
                this.cancelled = true;
                return;
            }
        }
        if (choiceCleanUpUpgradeExternalLinks && (ce = Util.upgradePdfPsToFile(Arrays.asList(this.panel.getSelectedEntries()), new String[]{"pdf", "ps"})).hasEdits()) {
            this.panel.undoManager.addEdit(ce);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
            this.panel.output(Globals.lang("Upgraded links."));
        }
        for (BibtexEntry entry : this.panel.getSelectedEntries()) {
            NamedCompound ce2 = new NamedCompound(Globals.lang("Cleanup entry"));
            if (choiceCleanUpSuperscripts) {
                this.doCleanUpSuperscripts(entry, ce2);
            }
            if (choiceCleanUpDOI) {
                this.doCleanUpDOI(entry, ce2);
            }
            if (choiceCleanUpMonth) {
                this.doCleanUpMonth(entry, ce2);
            }
            if (choiceCleanUpPageNumbers) {
                this.doCleanUpPageNumbers(entry, ce2);
            }
            this.fixWrongFileEntries(entry, ce2);
            if (choiceMakePathsRelative) {
                this.doMakePathsRelative(entry, ce2);
            }
            if (choiceRenamePDF) {
                this.doRenamePDFs(entry, ce2);
            }
            if (choiceConvertHTML) {
                this.doConvertHTML(entry, ce2);
            }
            if (choiceConvertCase) {
                this.doConvertCase(entry, ce2);
            }
            if (choiceConvertLaTeX) {
                this.doConvertLaTeX(entry, ce2);
            }
            ce2.end();
            if (!ce2.hasEdits()) continue;
            ++this.modifiedEntriesCount;
            this.panel.undoManager.addEdit(ce2);
        }
    }

    @Override
    public void update() {
        String message;
        if (this.cancelled) {
            this.frame.unblock();
            return;
        }
        if (this.unsuccesfullRenames > 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("File rename failed for") + " " + this.unsuccesfullRenames + " " + Globals.lang("entries") + ".", Globals.lang("Autogenerate PDF Names"), 1);
        }
        if (this.modifiedEntriesCount > 0) {
            this.panel.updateEntryEditorIfShowing();
            this.panel.markBaseChanged();
        }
        switch (this.modifiedEntriesCount) {
            case 0: {
                message = Globals.lang("No entry needed a clean up");
                break;
            }
            case 1: {
                message = Globals.lang("One entry needed a clean up");
                break;
            }
            default: {
                message = Globals.lang("%0 entries needed a clean up", Integer.toString(this.modifiedEntriesCount));
            }
        }
        this.panel.output(message);
        this.frame.unblock();
    }

    private void doCleanUpSuperscripts(BibtexEntry entry, NamedCompound ce) {
        String field = "booktitle";
        String oldValue = entry.getField("booktitle");
        if (oldValue == null) {
            return;
        }
        String newValue = oldValue.replaceAll(" (\\d+)(st|nd|rd|th) ", " $1\\\\textsuperscript{$2} ");
        if (!oldValue.equals(newValue)) {
            entry.setField("booktitle", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "booktitle", oldValue, newValue));
        }
    }

    private void doCleanUpDOI(BibtexEntry bes, NamedCompound ce) {
        block4: {
            String[] fields;
            block3: {
                fields = new String[]{"note", "url", "ee"};
                if (bes.getField("doi") == null) break block3;
                String doiFieldValue = bes.getField("doi");
                if (Util.checkForDOIwithHTTPprefix(doiFieldValue)) {
                    String newValue = Util.getDOI(doiFieldValue);
                    ce.addEdit(new UndoableFieldChange(bes, "doi", doiFieldValue, newValue));
                    bes.setField("doi", newValue);
                }
                if (!Util.checkForPlainDOI(doiFieldValue)) break block4;
                for (String field : fields) {
                    if (!Util.checkForPlainDOI(bes.getField(field))) continue;
                    Util.removeDOIfromBibtexEntryField(bes, field, ce);
                }
                break block4;
            }
            for (String field : fields) {
                if (!Util.checkForPlainDOI(bes.getField(field))) continue;
                String oldValue = bes.getField("doi");
                String newValue = Util.getDOI(bes.getField(field));
                ce.addEdit(new UndoableFieldChange(bes, "doi", oldValue, newValue));
                bes.setField("doi", newValue);
                Util.removeDOIfromBibtexEntryField(bes, field, ce);
            }
        }
    }

    private void doCleanUpMonth(BibtexEntry entry, NamedCompound ce) {
        String newValue;
        String oldValue;
        block4: {
            oldValue = entry.getField("month");
            if (oldValue == null) {
                return;
            }
            newValue = oldValue;
            try {
                int month = Integer.parseInt(newValue);
                newValue = new StringBuffer("#").append(Globals.MONTHS[month - 1]).append('#').toString();
            }
            catch (NumberFormatException e) {
                String testString = newValue.substring(0, 3).toLowerCase();
                if (!Globals.MONTH_STRINGS.containsKey(testString)) break block4;
                newValue = new StringBuffer("#").append(testString).append('#').toString();
            }
        }
        if (!oldValue.equals(newValue)) {
            entry.setField("month", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "month", oldValue, newValue));
        }
    }

    private void doCleanUpPageNumbers(BibtexEntry entry, NamedCompound ce) {
        String oldValue = entry.getField("pages");
        if (oldValue == null) {
            return;
        }
        String newValue = oldValue.replaceAll(" *(\\d+) *- *(\\d+) *", "$1--$2");
        if (!oldValue.equals(newValue)) {
            entry.setField("pages", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "pages", oldValue, newValue));
        }
    }

    private void fixWrongFileEntries(BibtexEntry entry, NamedCompound ce) {
        String oldValue = entry.getField("file");
        if (oldValue == null) {
            return;
        }
        FileListTableModel flModel = new FileListTableModel();
        flModel.setContent(oldValue);
        if (flModel.getRowCount() == 0) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < flModel.getRowCount(); ++i) {
            FileListEntry flEntry = flModel.getEntry(i);
            String link = flEntry.getLink();
            String description = flEntry.getDescription();
            if (!link.equals("") || description.equals("")) continue;
            flEntry.setLink(flEntry.getDescription());
            flEntry.setDescription("");
            changed = true;
        }
        if (changed) {
            String newValue = flModel.getStringRepresentation();
            assert (!oldValue.equals(newValue));
            entry.setField("file", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "file", oldValue, newValue));
        }
    }

    private void doMakePathsRelative(BibtexEntry entry, NamedCompound ce) {
        String oldValue = entry.getField("file");
        if (oldValue == null) {
            return;
        }
        FileListTableModel flModel = new FileListTableModel();
        flModel.setContent(oldValue);
        if (flModel.getRowCount() == 0) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < flModel.getRowCount(); ++i) {
            String newFileName;
            FileListEntry flEntry = flModel.getEntry(i);
            String oldFileName = flEntry.getLink();
            if (oldFileName.equals(newFileName = Util.shortenFileName(new File(oldFileName), this.panel.metaData().getFileDirectory("file")).toString())) continue;
            flEntry.setLink(newFileName);
            changed = true;
        }
        if (changed) {
            String newValue = flModel.getStringRepresentation();
            assert (!oldValue.equals(newValue));
            entry.setField("file", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "file", oldValue, newValue));
        }
    }

    private void doRenamePDFs(BibtexEntry entry, NamedCompound ce) {
        String oldValue = entry.getField("file");
        if (oldValue == null) {
            return;
        }
        FileListTableModel flModel = new FileListTableModel();
        flModel.setContent(oldValue);
        if (flModel.getRowCount() == 0) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < flModel.getRowCount(); ++i) {
            String newPath;
            String realOldFilename = flModel.getEntry(i).getLink();
            if (this.cleanUpRenamePDFonlyRelativePaths.isSelected() && new File(realOldFilename).isAbsolute()) continue;
            String newFilename = Util.getLinkedFileName(this.panel.database(), entry);
            newFilename = newFilename + "." + flModel.getEntry(i).getType().getExtension();
            File expandedOldFile = Util.expandFilename(realOldFilename, this.panel.metaData().getFileDirectory("file"));
            if (expandedOldFile.getParent() == null || new File(newPath = expandedOldFile.getParent().concat(System.getProperty("file.separator")).concat(newFilename)).exists()) continue;
            boolean renameSuccesfull = Util.renameFile(expandedOldFile.toString(), newPath);
            if (renameSuccesfull) {
                changed = true;
                String description = flModel.getEntry(i).getDescription();
                ExternalFileType type = flModel.getEntry(i).getType();
                flModel.removeEntry(i);
                File parent = new File(realOldFilename).getParentFile();
                String newFileEntryFileName = parent == null ? newFilename : parent.toString().concat(System.getProperty("file.separator")).concat(newFilename);
                flModel.addEntry(i, new FileListEntry(description, newFileEntryFileName, type));
                continue;
            }
            ++this.unsuccesfullRenames;
        }
        if (changed) {
            String newValue = flModel.getStringRepresentation();
            assert (!oldValue.equals(newValue));
            entry.setField("file", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "file", oldValue, newValue));
        }
    }

    private void doConvertHTML(BibtexEntry entry, NamedCompound ce) {
        String field = "title";
        String oldValue = entry.getField("title");
        if (oldValue == null) {
            return;
        }
        HTMLConverter htmlConverter = new HTMLConverter();
        String newValue = htmlConverter.format(oldValue);
        if (!oldValue.equals(newValue)) {
            entry.setField("title", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "title", oldValue, newValue));
        }
    }

    private void doConvertCase(BibtexEntry entry, NamedCompound ce) {
        String field = "title";
        String oldValue = entry.getField("title");
        if (oldValue == null) {
            return;
        }
        CaseKeeper caseKeeper = new CaseKeeper();
        String newValue = caseKeeper.format(oldValue);
        if (!oldValue.equals(newValue)) {
            entry.setField("title", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "title", oldValue, newValue));
        }
    }

    private void doConvertLaTeX(BibtexEntry entry, NamedCompound ce) {
        String field = "title";
        String oldValue = entry.getField("title");
        if (oldValue == null) {
            return;
        }
        String newValue = oldValue;
        if (!oldValue.equals(newValue = newValue.replace("$$", "").replaceAll("(?<!\\\\[\\p{Alpha}]{0,100}\\{[^\\}]{0,100})\\}([-/ ]?)\\{", "$1"))) {
            entry.setField("title", newValue);
            ce.addEdit(new UndoableFieldChange(entry, "title", oldValue, newValue));
        }
    }
}

