/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import org.apache.felix.scr.impl.Activator;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;

public abstract class ComponentActivatorTask
implements Runnable {
    private final String taskName;
    private final AbstractComponentManager component;

    protected ComponentActivatorTask(String taskName, AbstractComponentManager component) {
        this.taskName = taskName;
        this.component = component;
    }

    protected abstract void doRun();

    public void run() {
        if (this.component.getState() == 256) {
            Activator.log(2, null, "Cannot run task '" + this + "': Component has already been disposed", null);
        } else if (!ComponentRegistry.isBundleActive(this.component.getBundle())) {
            Activator.log(2, this.component.getBundle(), "Cannot run task '" + this + "': Declaring bundle is not active", null);
        } else {
            this.doRun();
        }
    }

    public String toString() {
        return this.taskName + " " + this.component;
    }
}

