/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.internal.legacy;

import net.xmind.verify.internal.LicenseKeyHeader;
import net.xmind.verify.internal.legacy.LegacyValidity;

public class XMindLicenseVerifier {
    private static final int LICENSE2012_KEY_LENGTH = 213;
    private static final int LICENSE_KEY_LENGTH = 225;
    private static final int HEADER_LENGTH = 12;

    public int verifyLicenseKey(String licenseKey) {
        String trimmedLicenseKey = XMindLicenseVerifier.trimLicenseKey(licenseKey);
        if (trimmedLicenseKey.length() == 213) {
            return LegacyValidity.LegacyVersion.XMIND_2012.getValue();
        }
        if (trimmedLicenseKey.length() == 225) {
            int minorVersion;
            String headerStr = trimmedLicenseKey.substring(0, 12);
            LicenseKeyHeader header = LicenseKeyHeader.decode(headerStr);
            String licenseType = header.getLicenseType();
            int majorVersion = header.getMajorVersionNumber();
            boolean matchVersion2013 = this.match2013(majorVersion, minorVersion = header.getMinorVersionNumber());
            if (matchVersion2013 && "A".equals(licenseType)) {
                return LegacyValidity.LegacyVersion.XMIND_2013_PRO.getValue();
            }
            if (matchVersion2013 && "B".equals(licenseType)) {
                return LegacyValidity.LegacyVersion.XMIND_2013_PLUS.getValue();
            }
            boolean matchVersion6 = this.match6(majorVersion, minorVersion);
            if (matchVersion6 && "A".equals(licenseType)) {
                return LegacyValidity.LegacyVersion.XMIND_6_PRO.getValue();
            }
            if (matchVersion6 && "B".equals(licenseType)) {
                return LegacyValidity.LegacyVersion.XMIND_6_PLUS.getValue();
            }
            boolean matchVersion7 = this.match7(majorVersion, minorVersion);
            if (matchVersion7 && "A".equals(licenseType)) {
                return LegacyValidity.LegacyVersion.XMIND_7_PRO.getValue();
            }
            if (matchVersion7 && "B".equals(licenseType)) {
                return LegacyValidity.LegacyVersion.XMIND_7_PLUS.getValue();
            }
        }
        return 0;
    }

    private boolean match2013(int majorVersion, int minorVersion) {
        return majorVersion == 3 && minorVersion == 4;
    }

    private boolean match6(int majorVersion, int minorVersion) {
        return majorVersion == 3 && minorVersion == 5;
    }

    private boolean match7(int majorVersion, int minorVersion) {
        return majorVersion == 3 && minorVersion == 6;
    }

    private static String trimLicenseKey(String key) {
        int startIndex = (key = key.toUpperCase()).indexOf("---BEGIN LICENSE KEY---");
        startIndex = startIndex < 0 ? 0 : (startIndex += 23);
        int endIndex = key.indexOf("---END LICENSE KEY---");
        if (endIndex < 0) {
            endIndex = key.length();
        }
        key = key.substring(startIndex, endIndex).replaceAll("[^A-Z0-9]", "");
        return key;
    }
}

