/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.ui.internal.auth;

import net.xmind.signin.XMindNet;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.Messages;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.resources.ColorUtils;

public class CredentialsInput
extends Composite {
    public static final int DETAIL_USER_NAME = 1;
    public static final int DETAIL_PASSWORD = 2;
    private Text nameField;
    private Text passwordField;

    public CredentialsInput(Composite parent) {
        super(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 12;
        layout.horizontalSpacing = 7;
        super.setLayout((Layout)layout);
        this.fillContents(this);
    }

    public void setLayout(Layout layout) {
    }

    public void setMargins(int top, int left, int bottom, int right) {
        GridLayout layout = (GridLayout)this.getLayout();
        layout.marginTop = top;
        layout.marginLeft = left;
        layout.marginBottom = bottom;
        layout.marginRight = right;
    }

    public void setSpacings(int vertical, int horizontal) {
        GridLayout layout = (GridLayout)this.getLayout();
        layout.verticalSpacing = vertical;
        layout.horizontalSpacing = horizontal;
    }

    public void setInputWidth(int width) {
        ((GridData)this.nameField.getLayoutData()).widthHint = width;
        ((GridData)this.passwordField.getLayoutData()).widthHint = width;
    }

    private void fillContents(Composite parent) {
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(Messages.SignInDialog_NameField_text);
        nameLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().withStyle(1)));
        nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.nameField = new Text(parent, 2052);
        this.nameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CredentialsInput.this.fireModifyEvent(event, 1);
            }
        });
        this.nameField.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                CredentialsInput.this.nameField.selectAll();
            }
        });
        this.nameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label passwordLabel = new Label(parent, 0);
        passwordLabel.setText(Messages.SignInDialog_PasswordField_text);
        passwordLabel.setFont((Font)resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().withStyle(1)));
        passwordLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.passwordField = new Text(parent, 0x400804);
        this.passwordField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CredentialsInput.this.fireModifyEvent(event, 2);
            }
        });
        this.passwordField.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                CredentialsInput.this.passwordField.selectAll();
            }
        });
        this.passwordField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label emptyPlaceholder = new Label(parent, 0);
        emptyPlaceholder.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Hyperlink forgotPasswordLink = new Hyperlink(parent, 0);
        forgotPasswordLink.setForeground((Color)resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
        forgotPasswordLink.setUnderlined(true);
        forgotPasswordLink.setText(Messages.SignInDialog_ForgotPassword_text);
        forgotPasswordLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                XMindNet.gotoURL(Activator.URL_FORGOT_PASSWORD, new Object[0]);
            }
        });
        forgotPasswordLink.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)forgotPasswordLink.getLayoutData()).verticalIndent = -10;
    }

    public void setUserName(String userName) {
        if (userName == null) {
            userName = "";
        }
        this.nameField.setText(userName);
    }

    public String getUserName() {
        return this.nameField.getText();
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    private void fireModifyEvent(Event source, int detail) {
        Event event = new Event();
        event.widget = this;
        event.display = source.display;
        event.time = source.time;
        event.data = source.data;
        event.detail = detail;
        this.notifyListeners(24, event);
    }

    public boolean setFocus() {
        String name = this.nameField.getText();
        if (name == null || "".equals(name)) {
            return this.nameField.setFocus();
        }
        return this.passwordField.setFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.nameField.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
    }
}

