/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.dialogs;

import java.util.Arrays;

public class Polygon {
    private int[] points;
    private int size = 0;

    public Polygon() {
        this(100);
    }

    public Polygon(int initialSize) {
        this.points = new int[initialSize];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void lineTo(int x, int y) {
        if (this.size >= 2 && this.points[this.size - 2] == x && this.points[this.size - 1] == y) {
            return;
        }
        if (this.points.length < this.size + 2) {
            this.points = Arrays.copyOf(this.points, this.size + 20);
        }
        this.points[this.size++] = x;
        this.points[this.size++] = y;
    }

    public void cubicTo(int cx1, int cy1, int cx2, int cy2, int x2, int y2) {
        if (this.size >= 2) {
            this.cubicTo(this.points[this.size - 2], this.points[this.size - 1], cx1, cy1, cx2, cy2, x2, y2);
        }
        this.lineTo(x2, y2);
    }

    private void cubicTo(int x1, int y1, int cx1, int cy1, int cx2, int cy2, int x2, int y2) {
        int total = Math.abs(x1 - cx1) + Math.abs(cx1 - cx2) + Math.abs(x2 - cx2) + Math.abs(y1 - cy1) + Math.abs(cy2 - cy1) + Math.abs(y2 - cy2);
        if (total > 0) {
            int i = 0;
            while (i < total) {
                double t = (double)i / (double)total;
                double tt = 1.0 - t;
                int x = (int)Math.round(tt * tt * tt * (double)x1 + tt * tt * t * (double)cx1 * 3.0 + tt * t * t * (double)cx2 * 3.0 + t * t * t * (double)x2);
                int y = (int)Math.round(tt * tt * tt * (double)y1 + tt * tt * t * (double)cy1 * 3.0 + tt * t * t * (double)cy2 * 3.0 + t * t * t * (double)y2);
                this.lineTo(x, y);
                ++i;
            }
        }
    }

    public void quadTo(int cx, int cy, int x2, int y2) {
        if (this.size >= 2) {
            int x1 = this.points[this.size - 2];
            int y1 = this.points[this.size - 1];
            int total = Math.abs(x1 - cx) + Math.abs(x2 - cx) + Math.abs(y1 - cy) + Math.abs(y2 - cy);
            if (total > 0) {
                int i = 0;
                while (i < total) {
                    double t = (double)i / (double)total;
                    double tt = 1.0 - t;
                    int x = (int)Math.round(tt * tt * (double)x1 + tt * t * (double)cx * 2.0 + t * t * (double)x2);
                    int y = (int)Math.round(tt * tt * (double)y1 + tt * t * (double)cy * 2.0 + t * t * (double)y2);
                    this.lineTo(x, y);
                    ++i;
                }
            }
        }
        this.lineTo(x2, y2);
    }

    public void roundCornerTo(int px, int py, int x2, int y2) {
        if (this.size >= 2) {
            int x1 = this.points[this.size - 2];
            int y1 = this.points[this.size - 1];
            this.cubicTo(x1, y1, (int)Math.round((double)x1 * 0.25 + (double)px * 0.75), (int)Math.round((double)y1 * 0.25 + (double)py * 0.75), (int)Math.round((double)x2 * 0.25 + (double)px * 0.75), (int)Math.round((double)y2 * 0.25 + (double)py * 0.75), x2, y2);
        }
        this.lineTo(x2, y2);
    }

    public int getSize() {
        return this.size;
    }

    public int[] toPointList() {
        return Arrays.copyOf(this.points, this.size);
    }
}

