/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.xmind.core.net.http.HttpException;
import org.xmind.seawind.internal.core.SeawindClient;
import org.xmind.seawind.internal.core.SeawindHttpException;

public class SeawindErrorCodes {
    public static final int INVALID_WORKBOOK_CONTENT = 1001;

    private SeawindErrorCodes() {
    }

    public static int parse(Throwable exception) {
        if ((exception = SeawindErrorCodes.unwrapCause(exception)) instanceof SeawindHttpException) {
            int code = ((SeawindHttpException)exception).getSubCode();
            if (code <= 0) {
                code = ((SeawindHttpException)exception).getCode();
            }
            return code;
        }
        if (exception instanceof HttpException) {
            return ((HttpException)exception).getCode();
        }
        if (exception instanceof SeawindClient.MissingFileException || exception.getCause() instanceof SeawindClient.MissingFileException) {
            return 8001;
        }
        if (SeawindErrorCodes.findTracedMethod(exception.getStackTrace(), "org.xmind.ui.internal.seawind.SeawindWorkbookRef", "doLoadWorkbookFromURI")) {
            return 1001;
        }
        return -1;
    }

    private static boolean findTracedMethod(StackTraceElement[] stack, String className, String methodName) {
        int i = 0;
        while (i < stack.length) {
            StackTraceElement element = stack[i];
            if (className.equals(element.getClassName()) && methodName.equals(element.getMethodName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Throwable unwrapCause(Throwable e) {
        while (true) {
            Throwable cause;
            IStatus status;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getCause();
                continue;
            }
            if (!(e instanceof CoreException) || (status = ((CoreException)e).getStatus()) == null || (cause = status.getException()) == null) break;
            e = cause;
        }
        return e;
    }
}

