/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.Collections;
import java.util.List;
import org.xmind.core.IIdentifiable;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Topic;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.Ranges;

public class Summary
implements ISummary,
ICoreEventSource {
    private final Workbook ownerWorkbook;
    private final String id;
    private Topic parentTopic;
    private boolean orphan;
    private String styleId;
    private long modificationTime;
    private String modifiedBy;
    private int startIndex;
    private int endIndex;
    private String topicId;

    public Summary(Workbook ownerWorkbook, String id) {
        this.ownerWorkbook = ownerWorkbook;
        this.id = id;
        this.parentTopic = null;
        this.orphan = true;
        this.styleId = null;
        this.modificationTime = 0L;
        this.modifiedBy = null;
        this.startIndex = -1;
        this.endIndex = -1;
        this.topicId = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.ownerWorkbook);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public ITopic getParent() {
        return this.parentTopic;
    }

    public ISheet getOwnedSheet() {
        return this.parentTopic == null ? null : this.parentTopic.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public List<ITopic> getEnclosingTopics() {
        List children;
        ITopic parent;
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        if (startIndex >= 0 && endIndex >= 0 && endIndex >= startIndex && (parent = this.getParent()) != null && !(children = parent.getChildren("attached")).isEmpty()) {
            return Summary.getSubtopics(startIndex, endIndex, children);
        }
        return Collections.emptyList();
    }

    private static List<ITopic> getSubtopics(int startIndex, int endIndex, List<ITopic> children) {
        startIndex = Math.min(startIndex, children.size() - 1);
        endIndex = Math.min(endIndex, children.size() - 1);
        return children.subList(startIndex, endIndex + 1);
    }

    public boolean encloses(ITopic subtopic) {
        if (subtopic == null) {
            return false;
        }
        ITopic parent = subtopic.getParent();
        if (parent == null || !parent.equals(this.getParent())) {
            return false;
        }
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        int subIndex = subtopic.getIndex();
        return subIndex >= startIndex && subIndex <= endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setStartIndex(int index) {
        int oldIndex = this.startIndex;
        if (index == oldIndex) {
            return;
        }
        String oldRange = Ranges.toRange(this);
        this.startIndex = index;
        String newRange = Ranges.toRange(this);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "startIndex", (Object)Summary.eventValueForIndex(oldIndex), (Object)Summary.eventValueForIndex(index));
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "range", (Object)oldRange, (Object)newRange);
    }

    public void setEndIndex(int index) {
        int oldIndex = this.endIndex;
        if (index == oldIndex) {
            return;
        }
        String oldRange = Ranges.toRange(this);
        this.endIndex = index;
        String newRange = Ranges.toRange(this);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "endIndex", (Object)Summary.eventValueForIndex(oldIndex), (Object)Summary.eventValueForIndex(index));
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "range", (Object)oldRange, (Object)newRange);
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        String oldStyleId = this.styleId;
        if (styleId == oldStyleId || styleId != null && styleId.equals(oldStyleId)) {
            return;
        }
        this.styleId = styleId;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "style", (Object)oldStyleId, (Object)styleId);
    }

    public String getStyleType() {
        return "summary";
    }

    public long getModifiedTime() {
        return this.modificationTime;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        String oldTopicId = this.topicId;
        if (topicId == oldTopicId || topicId != null && topicId.equals(oldTopicId)) {
            return;
        }
        this.topicId = topicId;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "topicRefId", (Object)oldTopicId, (Object)topicId);
    }

    public ITopic getTopic() {
        String topicId = this.getTopicId();
        return topicId == null ? null : this.ownerWorkbook.findTopic(topicId);
    }

    protected void setParent(Topic parentTopic) {
        this.parentTopic = parentTopic;
    }

    protected void onParented() {
        this.orphan = false;
        this.ownerWorkbook.getObjectRegistry().register(this);
    }

    protected void onOrphan() {
        this.ownerWorkbook.getObjectRegistry().unregister((IIdentifiable)this);
        this.orphan = true;
    }

    private static Integer eventValueForIndex(int index) {
        return index < 0 ? null : Integer.valueOf(index);
    }
}

