/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.plain.Topic;
import org.xmind.core.plain.Workbook;

public class MarkerRef
implements IMarkerRef {
    private final Workbook ownerWorkbook;
    private final String markerId;
    private Topic parent;
    private boolean orphan;

    public MarkerRef(Workbook ownerWorkbook, String markerId) {
        this.ownerWorkbook = ownerWorkbook;
        this.markerId = markerId;
        this.parent = null;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.parent != null) {
            return this.parent.getAdapter(adapter);
        }
        return null;
    }

    public ITopic getParent() {
        return this.parent;
    }

    protected void setParent(Topic parent) {
        this.parent = parent;
    }

    public ISheet getOwnedSheet() {
        return this.parent == null ? null : this.parent.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public String getMarkerId() {
        return this.markerId;
    }

    public IMarker getMarker() {
        return this.ownerWorkbook.getMarkerSheet().findMarker(this.getMarkerId());
    }

    public String getDescription() {
        String name;
        String description;
        ISheet sheet = this.getOwnedSheet();
        if (sheet != null && (description = sheet.getLegend().getMarkerDescription(this.getMarkerId())) != null) {
            return description;
        }
        IMarker marker = this.getMarker();
        if (marker != null && (name = marker.getName()) != null) {
            return name;
        }
        return "";
    }

    protected void onParented() {
        this.orphan = false;
    }

    protected void onOrphan() {
        this.orphan = true;
    }
}

