/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.ui.internal.dnd.MindMapDNDClientBase;
import org.xmind.ui.internal.ideafactory.DeleteIdeaCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryViewer;
import org.xmind.ui.internal.ideafactory.IdeaTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaDndClient
extends MindMapDNDClientBase {
    private final IdeaTransfer transfer = IdeaTransfer.getInstance();
    private final Map<ITopic, ITopicExtensionElement> exElements = new HashMap<ITopic, ITopicExtensionElement>();

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        return null;
    }

    protected Object[] toViewerElements(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent) {
        if (transferData instanceof Object[] && workbook != null) {
            ArrayList<ITopic> elements = new ArrayList<ITopic>();
            Object[] objectArray = (Object[])transferData;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ITopicExtensionElement[]) {
                    ITopicExtensionElement[] ideas;
                    ITopicExtensionElement[] iTopicExtensionElementArray = ideas = (ITopicExtensionElement[])obj;
                    int n3 = ideas.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ITopicExtensionElement idea = iTopicExtensionElementArray[n4];
                        ITopic topic = workbook.createTopic();
                        topic.setTitleText(idea.getTextContent());
                        this.exElements.put(topic, idea);
                        elements.add(topic);
                        ++n4;
                    }
                }
                ++n2;
            }
            return elements.toArray();
        }
        return null;
    }

    protected void makeDNDCommands(Request request, IWorkbook workbook, ITopic targetParent, Object[] elements, List<Command> commands, boolean floating, boolean dropInParent) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        ISheet sheet = (ISheet)request.getTargetViewer().getAdapter(ISheet.class);
        if (sheet == null) {
            return;
        }
        IdeaFactoryViewer sourceViewer = this.transfer.getSourceViewer();
        if (sourceViewer != null && !sourceViewer.getControl().isDisposed()) {
            sourceViewer.checkGroup();
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ITopicExtensionElement deletedIdea;
            Object topic = objectArray[n2];
            if (topic != null && (deletedIdea = this.exElements.get(topic)) != null) {
                commands.add((Command)new DeleteIdeaCommand(sheet.getRootTopic(), deletedIdea));
            }
            ++n2;
        }
        super.makeDNDCommands(request, workbook, targetParent, elements, commands, floating, dropInParent);
    }
}

