/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IResourceRef;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.audio.CoreAudio;
import org.xmind.core.audio.CoreAudioClient;
import org.xmind.core.audio.FileAudioTarget;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;
import org.xmind.core.audio.ICoreAudioClient;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesUtils;
import org.xmind.ui.internal.audionotes.FileEntryAudioSource;
import org.xmind.ui.internal.audionotes.IAudioNotesAgentListener;
import org.xmind.ui.internal.audionotes.ITopicAudioClient;
import org.xmind.ui.internal.audionotes.Messages;

public class AudioNotesAgent {
    private static final String RECORDER_ID = "org.xmind.audio.recorder.lame";
    private static final String PLAYER_ID = "org.xmind.audio.player.mp3javalayer";
    double pauseAt = -1.0;
    static final double INVALID_PAUSE_AT = -1.0;
    volatile boolean windowOpened = false;
    private static final List<Object> EMPTY_TOPICS = Collections.emptyList();
    private ITopicAudioClient currentClient = null;
    private Map<ITopic, List<IAudioNotesAgentListener>> listeners = null;

    public ITopicAudioClient getCurrentClient() {
        return this.currentClient;
    }

    public String getCurrentSessionId() {
        return this.currentClient == null ? null : this.currentClient.getSessionId();
    }

    public ITopic getCurrentTopic() {
        return this.currentClient == null ? null : this.currentClient.getTopic();
    }

    public boolean isRecording() {
        if (this.currentClient == null) {
            return false;
        }
        if (!RECORDER_ID.equals(this.currentClient.getRequestedDeviceId())) {
            return false;
        }
        return CoreAudio.getService().isSessionActive(this.currentClient.getSessionId());
    }

    public boolean isPlaying() {
        if (this.currentClient == null) {
            return false;
        }
        if (!PLAYER_ID.equals(this.currentClient.getRequestedDeviceId())) {
            return false;
        }
        return CoreAudio.getService().isSessionActive(this.currentClient.getSessionId());
    }

    public void startRecord(ITopic topic) {
        if (topic == null) {
            return;
        }
        if (this.isRecording()) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        this.createAndExecuteStartRecordingCommand(topic);
        VerifyUI20141031.getUsageDataCollector().increase("AudioNotesRecordCount");
    }

    private void createAndExecuteStartRecordingCommand(ITopic topic) {
        StartRecordingCommand command = new StartRecordingCommand(topic);
        this.getCommandStack(topic).execute((Command)command);
    }

    private ICommandStack getCommandStack(ITopic topic) {
        IGraphicalEditor editor = (IGraphicalEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null) {
            return editor.getCommandStack();
        }
        return ICommandStack.NULL;
    }

    public void createRecordClientAndStartSession(ITopic topic) throws Exception {
        this.stop();
        if (!CoreAudio.getService().isDeviceAvailable(RECORDER_ID)) {
            throw new Exception(Messages.AudioDeviceNotAvailable);
        }
        File tempFile = this.createTempFileForRecording();
        RecorderClient client = new RecorderClient(Display.getCurrent(), topic, tempFile);
        String sessionId = CoreAudio.getService().start((ICoreAudioClient)client);
        this.currentClient = client;
        client.setSessionId(sessionId);
    }

    private File createTempFileForRecording() {
        String tempDir = Core.getWorkspace().getTempDir("recording");
        try {
            return File.createTempFile("record", ".mp3", new File(tempDir));
        }
        catch (IOException iOException) {
            return new File(tempDir, String.format("record_%1$tY%1$tm%1$td%1$tH%1$tM%1$tS.mp3", Calendar.getInstance()));
        }
    }

    private void addPreSaveActions(ITopic topic) {
        if (topic == null) {
            return;
        }
        IWorkbook workbook = topic.getOwnedWorkbook();
        if (workbook instanceof ICoreEventSource2) {
            ((ICoreEventSource2)workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
        }
    }

    public void startPlay(ITopic topic) {
        if (this.isRecording()) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        this.createPlaybackClientAndStartSession(topic);
    }

    private boolean createPlaybackClientAndStartSession(ITopic topic) {
        String sessionId;
        if (topic == null) {
            return false;
        }
        String entryPath = AudioNotesUtils.getAudioEntryPath(topic);
        if (entryPath == null) {
            return false;
        }
        IWorkbook workbook = topic.getOwnedWorkbook();
        IFileEntry entry = workbook.getManifest().getFileEntry(entryPath);
        if (entry == null) {
            return false;
        }
        if (!CoreAudio.getService().isDeviceAvailable(PLAYER_ID)) {
            File tempFile = this.createTempFileForPlaying(topic, workbook, entry, entryPath);
            if (tempFile == null || !tempFile.exists()) {
                return false;
            }
            Program.launch((String)tempFile.getAbsolutePath());
            this.fireStarted(Display.getCurrent(), topic, false);
            this.currentClient = null;
            return true;
        }
        FileEntryAudioSource source = null;
        source = new FileEntryAudioSource(entry);
        PlaybackClient client = new PlaybackClient(Display.getCurrent(), topic, source);
        try {
            sessionId = CoreAudio.getService().start((ICoreAudioClient)client);
        }
        catch (Throwable e) {
            AudioNotesPlugin.log(e, "Failed to start audio client.");
            return false;
        }
        this.currentClient = client;
        client.setSessionId(sessionId);
        return true;
    }

    private File createTempFileForPlaying(ITopic topic, IWorkbook workbook, IFileEntry entry, String entryPath) {
        String tempDir = Core.getWorkspace().getTempDir("playing");
        File file = FileUtils.ensureFileParent((File)new File(tempDir, entryPath));
        if (file.exists()) {
            return file;
        }
        InputStream is = null;
        try {
            is = entry.openInputStream();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (is == null) {
            return null;
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
        }
        catch (IOException iOException) {
            return null;
        }
        return file;
    }

    public void stop() {
        if (this.currentClient != null && CoreAudio.getService().isSessionActive(this.currentClient.getSessionId())) {
            try {
                CoreAudio.getService().stop(this.currentClient.getSessionId());
            }
            catch (Throwable e) {
                AudioNotesPlugin.log(e, "Error occurred while stopping audio process");
            }
            this.currentClient = null;
        }
    }

    public void jumpTo(double rate) {
        if (this.currentClient != null) {
            String sessionId = this.currentClient.getSessionId();
            if (CoreAudio.getService().isSessionActive(sessionId)) {
                try {
                    CoreAudio.getService().jumpTo(sessionId, rate);
                }
                catch (Throwable e) {
                    AudioNotesPlugin.log(e, "Error occurred while jumping audio process");
                }
            }
        }
    }

    private void transferTempIntoWorkbook(ITopic topic, File tempFile) {
        IFileEntry entry;
        IWorkbook workbook = topic.getOwnedWorkbook();
        IManifest manifest = workbook.getManifest();
        try {
            entry = manifest.createAttachmentFromFilePath(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            AudioNotesPlugin.log(e, "Error occurred while copying temp file into workbook: " + tempFile.getAbsolutePath());
            return;
        }
        String entryPath = entry.getPath();
        ITopicExtension ext = topic.createExtension("org.xmind.ui.audionotes");
        IResourceRef resRef = workbook.createResourceRef("file-entry", entryPath);
        ext.addResourceRef(resRef);
        ext.getContent().setAttribute("recording", null);
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchTargetChange((ICoreEventSource)topic, "org.xmind.core.event.audioNotesRecorded", (Object)topic);
        }
    }

    public void addAudioListener(ITopic topic, IAudioNotesAgentListener listener) {
        List<IAudioNotesAgentListener> list;
        if (this.listeners == null) {
            this.listeners = new HashMap<ITopic, List<IAudioNotesAgentListener>>();
        }
        if ((list = this.listeners.get(topic)) == null) {
            list = new ArrayList<IAudioNotesAgentListener>();
            this.listeners.put(topic, list);
        }
        list.add(listener);
    }

    public void removeAudioListener(ITopic topic, IAudioNotesAgentListener listener) {
        if (this.listeners == null) {
            return;
        }
        List<IAudioNotesAgentListener> list = this.listeners.get(topic);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.listeners.remove(topic);
        }
    }

    public void addAudioListener(IAudioNotesAgentListener listener) {
        this.addAudioListener(null, listener);
    }

    public void removeAudioListener(IAudioNotesAgentListener listener) {
        this.removeAudioListener(null, listener);
    }

    protected void fireStarted(Display display, ITopic topic, boolean recordOrPlayback) {
        this.fireStarted(display, topic, topic, recordOrPlayback);
        this.fireStarted(display, null, topic, recordOrPlayback);
    }

    private void fireStarted(Display display, ITopic key, final ITopic topic, final boolean recordOrPlayback) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        List<IAudioNotesAgentListener> list = this.listeners.get(key);
        if (list == null) {
            return;
        }
        final Object[] ls = list.toArray();
        display.asyncExec(new Runnable(){

            public void run() {
                Object[] objectArray = ls;
                int n = ls.length;
                int n2 = 0;
                while (n2 < n) {
                    Object l = objectArray[n2];
                    ((IAudioNotesAgentListener)l).started(topic, recordOrPlayback);
                    ++n2;
                }
            }
        });
    }

    protected void fireStopped(Display display, ITopic topic, boolean recordOrPlayback) {
        if (display == null || display.isDisposed()) {
            return;
        }
        this.fireStopped(display, topic, topic, recordOrPlayback);
        this.fireStopped(display, null, topic, recordOrPlayback);
    }

    private void fireStopped(Display display, ITopic key, final ITopic topic, final boolean recordOrPlayback) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        List<IAudioNotesAgentListener> list = this.listeners.get(key);
        if (list == null) {
            return;
        }
        final Object[] ls = list.toArray();
        display.asyncExec(new Runnable(){

            public void run() {
                Object[] objectArray = ls;
                int n = ls.length;
                int n2 = 0;
                while (n2 < n) {
                    Object l = objectArray[n2];
                    ((IAudioNotesAgentListener)l).stopped(topic, recordOrPlayback);
                    ++n2;
                }
            }
        });
    }

    protected void fireValuesChanged(Display display, ITopic topic, AudioValues values, boolean recordOrPlayback) {
        if (display == null || display.isDisposed()) {
            return;
        }
        this.fireValueChanged(display, topic, topic, values, recordOrPlayback);
        this.fireValueChanged(display, null, topic, values, recordOrPlayback);
    }

    private void fireValueChanged(Display display, ITopic key, final ITopic topic, final AudioValues values, final boolean recordOrPlayback) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        List<IAudioNotesAgentListener> list = this.listeners.get(key);
        if (list == null) {
            return;
        }
        final Object[] ls = list.toArray();
        display.asyncExec(new Runnable(){

            public void run() {
                Object[] objectArray = ls;
                int n = ls.length;
                int n2 = 0;
                while (n2 < n) {
                    Object l = objectArray[n2];
                    ((IAudioNotesAgentListener)l).valuesChanged(topic, values, recordOrPlayback);
                    ++n2;
                }
            }
        });
    }

    public double getCurrentRate(ITopic topic) {
        if (this.currentClient instanceof PlaybackClient) {
            long startTime = this.currentClient.getStartTime();
            long currentTime = System.currentTimeMillis();
            long total = this.getTotalSeconds(topic) * 1000L;
            if (total == 0L) {
                return -1.0;
            }
            if (this.pauseAt != -1.0) {
                return (double)(currentTime - startTime) / (double)total + this.pauseAt;
            }
            return (double)(currentTime - startTime) / (double)total;
        }
        return -1.0;
    }

    long getTotalSeconds(ITopic topic) {
        long base = 1L;
        long total = 0L;
        if (topic != null) {
            String duration = AudioNotesUtils.formatTime(AudioNotesUtils.getDuration(topic));
            if (duration != null) {
                String[] parts = duration.split(":");
                int i = parts.length - 1;
                while (i >= 0) {
                    total += base * Long.parseLong(parts[i]);
                    base *= 60L;
                    --i;
                }
                return total;
            }
            return 0L;
        }
        return 0L;
    }

    ITopic getPlayingTopic() {
        if (this.currentClient instanceof PlaybackClient) {
            return this.getCurrentClient().getTopic();
        }
        return null;
    }

    private class PlaybackClient
    extends CoreAudioClient
    implements ITopicAudioClient {
        private Display display;
        private ITopic topic;
        private String sessionId;
        private long startTime;

        public PlaybackClient(Display display, ITopic topic, IAudioSource source) {
            super(AudioNotesAgent.PLAYER_ID, source, null);
            this.startTime = -1L;
            this.display = display;
            this.topic = topic;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public ITopic getTopic() {
            return this.topic;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
            this.startTime = System.currentTimeMillis();
            AudioNotesAgent.this.fireStarted(this.display, this.topic, false);
        }

        public void notifyStopped(String sessionId) {
            AudioNotesAgent.this.fireStopped(this.display, this.topic, false);
        }

        public void notifyValueChanged(String sessionId, AudioValues values) {
            AudioNotesAgent.this.fireValuesChanged(this.display, this.topic, values, false);
        }
    }

    protected class RecorderClient
    extends CoreAudioClient
    implements ITopicAudioClient {
        private Display display;
        private ITopic topic;
        private File tempFile;
        private String sessionId;
        private long startTime;
        private long endTime;

        public RecorderClient(Display display, ITopic topic, File tempFile) {
            super(AudioNotesAgent.RECORDER_ID, null, (IAudioTarget)new FileAudioTarget(tempFile));
            this.startTime = -1L;
            this.endTime = -1L;
            this.display = display;
            this.topic = topic;
            this.tempFile = tempFile;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public File getTempFile() {
            return this.tempFile;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public ITopic getTopic() {
            return this.topic;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
            this.startTime = System.currentTimeMillis();
            AudioNotesAgent.this.fireStarted(this.display, this.topic, true);
        }

        public void notifyStopped(String sessionId) {
            this.endTime = System.currentTimeMillis();
            this.display.asyncExec(new Runnable(){

                public void run() {
                    RecorderClient.this.handleStopped();
                }
            });
            AudioNotesAgent.this.fireStopped(this.display, this.topic, true);
        }

        private void handleStopped() {
            ITopicExtension ext = this.topic.createExtension("org.xmind.ui.audionotes");
            ITopicExtensionElement content = ext.getContent();
            ITopicExtensionElement durationEle = (ITopicExtensionElement)content.getCreatedChild("duration");
            durationEle.setTextContent(String.valueOf(this.endTime - this.startTime));
            ITopicExtensionElement recordTimeEle = (ITopicExtensionElement)content.getCreatedChild("record-time");
            recordTimeEle.setTextContent(String.format("%1$tr, %1$tb %1$td %1$tY", this.endTime));
            ITopicExtensionElement fileSizeEle = (ITopicExtensionElement)content.getCreatedChild("file-size");
            fileSizeEle.setTextContent(String.valueOf(this.tempFile.length()));
            AudioNotesAgent.this.transferTempIntoWorkbook(this.topic, this.tempFile);
            AudioNotesAgent.this.addPreSaveActions(this.topic);
        }

        public void notifyValueChanged(String sessionId, AudioValues values) {
            AudioNotesAgent.this.fireValuesChanged(this.display, this.topic, values, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartRecordingCommand
    extends Command
    implements ISourceProvider {
        private ITopic parent;
        private ITopic subtopic;
        private boolean evetStarted;
        private boolean executing;

        public StartRecordingCommand(ITopic parent) {
            super(Messages.Command_Record);
            this.evetStarted = false;
            this.executing = false;
            this.parent = parent;
        }

        public int getType() {
            return 1;
        }

        public void execute() {
            this.executing = true;
            this.startNewRecording();
            super.execute();
            this.executing = false;
        }

        private void startNewRecording() {
            this.subtopic = this.parent.getOwnedWorkbook().createTopic();
            ITopicExtension extension = this.subtopic.createExtension("org.xmind.ui.audionotes");
            extension.getContent().setAttribute("recording", "true");
            int num = this.getExistingAudioCount();
            this.subtopic.setTitleText(NLS.bind((String)Messages.AudioTitle, (Object)(num + 1)));
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    AudioNotesAgent.this.createRecordClientAndStartSession(StartRecordingCommand.this.subtopic);
                    StartRecordingCommand.this.parent.add(StartRecordingCommand.this.subtopic);
                    AudioNotesAgent.this.addPreSaveActions(StartRecordingCommand.this.subtopic);
                    StartRecordingCommand.this.evetStarted = true;
                }
            });
        }

        public boolean canUndo() {
            return super.canUndo() && this.evetStarted;
        }

        public boolean canRedo() {
            return super.canRedo() && this.evetStarted;
        }

        private int getExistingAudioCount() {
            int num = 0;
            for (ITopic t : this.parent.getChildren("attached")) {
                if (AudioNotesUtils.getAudioEntryPath(t) == null) continue;
                ++num;
            }
            return num;
        }

        public void redo() {
            if (!this.executing) {
                this.parent.add(this.subtopic);
            }
            super.redo();
        }

        private boolean hasRecordedData() {
            return this.subtopic != null && AudioNotesUtils.getAudioEntryPath(this.subtopic) != null;
        }

        public void undo() {
            if (this.subtopic != null) {
                if (!this.hasRecordedData() && AudioNotesAgent.this.isRecording() && this.subtopic.equals(AudioNotesAgent.this.getCurrentTopic()) && this.confirmStop()) {
                    AudioNotesAgent.this.stop();
                }
                this.parent.remove(this.subtopic);
            }
            super.undo();
        }

        private boolean confirmStop() {
            return true;
        }

        public Object getSource() {
            return this.subtopic;
        }

        public List<Object> getSources() {
            return this.subtopic == null ? EMPTY_TOPICS : Arrays.asList(this.subtopic);
        }

        public boolean hasSource() {
            return true;
        }
    }
}

