/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.List;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.AbstractViewer;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ILayerManager;
import org.xmind.gef.ISelectionSupport;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.event.PartsEventDispatcher;
import org.xmind.gef.event.ViewerEventDispatcher;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IGraphicalRootPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalViewer
extends AbstractViewer
implements IGraphicalViewer {
    private static final Point POINT = new Point();
    private LightweightSystem lws = this.createLightweightSystem();
    private ILayerManager layerManager = null;
    private ViewerEventDispatcher eventDispatcher = this.createEventDispatcher();
    private ZoomManager zoomManager = null;
    private Viewport viewport = new Viewport(true);

    public GraphicalViewer() {
        this.lws.setEventDispatcher((EventDispatcher)this.eventDispatcher);
        this.lws.setContents((IFigure)this.viewport);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (LightweightSystem.class.equals(adapter)) {
            return adapter.cast(this.getLightweightSystem());
        }
        if (ILayerManager.class.equals(adapter)) {
            return adapter.cast(this.getLayerManager());
        }
        if (FigureCanvas.class.equals(adapter)) {
            return adapter.cast(this.getCanvas());
        }
        if (ZoomManager.class.equals(adapter)) {
            return adapter.cast(this.getZoomManager());
        }
        if (IGraphicalPart.class.equals(adapter)) {
            return adapter.cast(this.getRootPart() instanceof IGraphicalPart ? this.getRootPart() : null);
        }
        if (IFigure.class.equals(adapter)) {
            return adapter.cast(this.getRootFigure());
        }
        if (Viewport.class.equals(adapter)) {
            return adapter.cast(this.getViewport());
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IGraphicalPart findGraphicalPart(Object model) {
        IPart part = this.findPart(model);
        if (part instanceof IGraphicalPart) {
            return (IGraphicalPart)part;
        }
        return null;
    }

    @Override
    public IPart findPart(int x, int y) {
        return this.findPart(this.convertPoint(x, y));
    }

    protected Point convertPoint(int controlX, int controlY) {
        return this.computeToLayer(POINT.setLocation(controlX, controlY), true);
    }

    protected IPart findPart(Point position) {
        return this.findPart(this.getRootPart(), position);
    }

    protected IPart findPart(IPart parent, Point position) {
        if (parent == null || !(parent instanceof IGraphicalEditPart)) {
            return null;
        }
        return ((IGraphicalEditPart)parent).findAt(position, this.getPartSearchCondition());
    }

    protected LightweightSystem createLightweightSystem() {
        return new LightweightSystem();
    }

    public LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    protected Viewport getViewport() {
        return this.viewport;
    }

    @Override
    public Control createControl(Composite parent) {
        return this.createControl(parent, 0x20000000);
    }

    @Override
    protected Control internalCreateControl(Composite parent, int style) {
        FigureCanvas canvas = new FigureCanvas(parent, style, this.getLightweightSystem()){

            public org.eclipse.swt.graphics.Rectangle computeTrim(int x, int y, int width, int height) {
                org.eclipse.swt.graphics.Rectangle trim = super.computeTrim(x, y, width, height);
                if (!this.getVerticalBar().isVisible()) {
                    trim.width = 0;
                }
                if (!this.getHorizontalBar().isVisible()) {
                    trim.height = 0;
                }
                return trim;
            }
        };
        this.addHorizontalScrollSupport(canvas);
        canvas.setViewport(this.viewport);
        return canvas;
    }

    private void addHorizontalScrollSupport(final FigureCanvas canvas) {
        if (Util.isWindows()) {
            canvas.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!canvas.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point viewLocation = canvas.getViewport().getViewLocation();
                        canvas.getViewport().setHorizontalLocation(viewLocation.x + offset);
                    }
                }
            });
        }
    }

    @Override
    protected void hookControl(Control control) {
        if (this.getEditDomain() != null) {
            this.eventDispatcher.activate();
        }
        super.hookControl(control);
    }

    @Override
    public void setRootPart(IRootPart rootPart) {
        super.setRootPart(rootPart);
        IFigure rootFigure = this.getRootFigure();
        if (rootFigure instanceof Viewport) {
            this.viewport = (Viewport)rootFigure;
        } else {
            this.viewport = new Viewport(true);
            this.viewport.setContents(rootFigure);
        }
        this.getLightweightSystem().setContents((IFigure)this.viewport);
        if (this.getCanvas() != null && !this.getCanvas().isDisposed()) {
            this.getCanvas().setViewport(this.viewport);
        }
    }

    protected IFigure getRootFigure() {
        if (this.getRootPart() instanceof IGraphicalPart) {
            return ((IGraphicalPart)((Object)this.getRootPart())).getFigure();
        }
        return null;
    }

    protected void revalidateContents() {
        this.getCanvas().layout(true);
    }

    protected ViewerEventDispatcher createEventDispatcher() {
        return new PartsEventDispatcher(this);
    }

    @Override
    public void setEditDomain(EditDomain editDomain) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.eventDispatcher.deactivate();
        }
        super.setEditDomain(editDomain);
        if (this.getEditDomain() != null && this.getControl() != null && !this.getControl().isDisposed()) {
            this.eventDispatcher.activate();
        }
    }

    @Override
    public Layer getLayer(Object key) {
        return this.layerManager == null ? null : this.layerManager.getLayer(key);
    }

    @Override
    public ILayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void setLayerManager(ILayerManager layerManager) {
        this.layerManager = layerManager;
    }

    @Override
    public void updateToolTip() {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.eventDispatcher.updateToolTip();
        }
    }

    public void hideToolTip() {
        if (this.getControl() != null) {
            this.getControl().setToolTipText(null);
        }
    }

    @Override
    public FigureCanvas getCanvas() {
        return (FigureCanvas)super.getControl();
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getCanvas().getSize());
    }

    @Override
    public Rectangle getClientArea() {
        Rectangle area = new Rectangle(this.getCanvas().getClientArea());
        area.setLocation(this.getScrollPosition());
        return area;
    }

    @Override
    public Point getCenterPoint() {
        return this.getViewport().getClientArea().getCenter();
    }

    @Override
    public void center(Rectangle area) {
        this.center(area.getCenter());
    }

    @Override
    public void center(int x, int y) {
        Rectangle clientArea = this.getViewport().getClientArea();
        this.scrollTo(x - clientArea.width >> 1, y - clientArea.height >> 1);
    }

    @Override
    public void center(Point center) {
        this.center(center.x, center.y);
    }

    @Override
    public void scrollToX(int x) {
        if (this.usesSmoothScroll()) {
            this.getViewport().setHorizontalLocation(x);
        } else {
            this.getCanvas().scrollToX(x);
        }
    }

    @Override
    public void scrollToY(int y) {
        if (this.usesSmoothScroll()) {
            this.getViewport().setVerticalLocation(y);
        } else {
            this.getCanvas().scrollToY(y);
        }
    }

    @Override
    public void scrollTo(Point p) {
        this.scrollTo(p.x, p.y);
    }

    @Override
    public void scrollTo(int x, int y) {
        if (this.usesSmoothScroll()) {
            this.getViewport().setViewLocation(x, y);
        } else {
            this.getCanvas().scrollTo(x, y);
        }
    }

    protected boolean usesSmoothScroll() {
        return Boolean.TRUE.equals(this.getProperties().get("scrollSmooth"));
    }

    @Override
    public void scrollDelta(Dimension d) {
        this.scrollTo(this.getScrollPosition().translate(d));
    }

    @Override
    public void scrollDelta(int dx, int dy) {
        this.scrollTo(this.getScrollPosition().translate(dx, dy));
    }

    @Override
    public Point getScrollPosition() {
        return this.getViewport().getViewLocation();
    }

    @Override
    public Point computeToLayer(Point controlPoint, boolean zoomed) {
        Point p = this.getScrollPosition();
        p.translate(controlPoint);
        if (zoomed) {
            return p.scale(1.0 / this.getZoomManager().getScale());
        }
        return p;
    }

    @Override
    public Point computeToControl(Point layerPoint, boolean zoomed) {
        POINT.setLocation(layerPoint);
        if (zoomed) {
            POINT.scale(this.getZoomManager().getScale());
        }
        return this.getScrollPosition().negate().translate(POINT);
    }

    @Override
    public Point computeToDisplay(Point layerPoint, boolean zoomed) {
        Point p = this.computeToControl(layerPoint, zoomed);
        org.eclipse.swt.graphics.Point loc = this.getControl().toDisplay(p.x, p.y);
        return p.setLocation(loc.x, loc.y);
    }

    @Override
    public void ensureVisible(Rectangle box) {
        box = this.getZoomManager().getScaled(box);
        Rectangle clientArea = this.getClientArea();
        if (clientArea.contains(box) || box.contains(clientArea)) {
            return;
        }
        this.ensureVisible(box, clientArea, 0);
    }

    public void ensureControlVisible(Rectangle box) {
        Rectangle clientArea = new Rectangle(this.getCanvas().getClientArea());
        if (clientArea.contains(box) || box.contains(clientArea)) {
            return;
        }
        this.ensureVisible(box, clientArea, 0);
    }

    protected void ensureVisible(Rectangle box, Rectangle clientArea, int margin) {
        int dx = 0;
        int dy = 0;
        if (box.width > clientArea.width) {
            dx = box.getCenter().x - clientArea.getCenter().x;
        } else if (box.x < clientArea.x) {
            dx = box.x - clientArea.x - margin;
        } else if (box.right() > clientArea.right()) {
            dx = box.right() - clientArea.right() + margin;
        }
        if (box.height > clientArea.height) {
            dy = box.getCenter().y - clientArea.getCenter().y;
        } else if (box.y < clientArea.y) {
            dy = box.y - clientArea.y - margin;
        } else if (box.bottom() > clientArea.bottom()) {
            dy = box.bottom() - clientArea.bottom() + margin;
        }
        this.smoothScrollDelta(dx, dy);
    }

    protected void smoothScrollDelta(int dx, int dy) {
        this.scrollDelta(dx, dy);
    }

    protected IGraphicalRootPart getGraphicalRootEditPart() {
        IRootPart rootPart = this.getRootPart();
        if (rootPart instanceof IGraphicalRootPart) {
            return (IGraphicalRootPart)rootPart;
        }
        return null;
    }

    @Override
    protected ISelectionSupport createSelectionSupport() {
        return new GraphicalSelectionSupport();
    }

    @Override
    protected void inputChanged(Object input, Object oldInput) {
        boolean controlAvailable;
        boolean bl = controlAvailable = this.getControl() != null && !this.getControl().isDisposed();
        if (controlAvailable) {
            this.getControl().setRedraw(false);
        }
        ISelection oldSelection = this.getSelection();
        this.setSelectionOnInputChanged((ISelection)StructuredSelection.EMPTY);
        double oldScale = this.getZoomManager().getScale();
        if (controlAvailable && this.getEditDomain() != null) {
            this.eventDispatcher.deactivate();
        }
        this.internalInputChanged(input, oldInput);
        if (controlAvailable && this.getEditDomain() != null) {
            this.eventDispatcher.activate();
        }
        this.setSelectionOnInputChanged(oldSelection);
        if (oldScale >= 0.0) {
            this.getZoomManager().setScale(oldScale);
        }
        if (controlAvailable) {
            this.getControl().setRedraw(true);
        }
    }

    protected void setSelectionOnInputChanged(ISelection selection) {
        this.setSelection(selection);
    }

    protected void internalInputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    @Override
    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager();
        }
        return this.zoomManager;
    }

    @Override
    public void setZoomManager(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
    }

    @Override
    public void setDndSupport(IDndSupport dndSupport) {
        super.setDndSupport(dndSupport);
        this.eventDispatcher.setDndSupport(dndSupport);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.eventDispatcher.setOverridingCursor(cursor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphicalSelectionSupport
    extends AbstractViewer.SelectionSupport {
        protected GraphicalSelectionSupport() {
            super(GraphicalViewer.this);
        }

        @Override
        public boolean isSelectable(IPart p) {
            IFigure fig;
            boolean selectable = super.isSelectable(p);
            if (selectable && p instanceof IGraphicalPart && ((fig = ((IGraphicalPart)p).getFigure()) == null || !fig.isShowing())) {
                return false;
            }
            return selectable;
        }

        @Override
        protected void partSelectionChanged(List<? extends IPart> parts, boolean reveal) {
            super.partSelectionChanged(parts, reveal);
            if (GraphicalViewer.this.getEditDomain() != null) {
                IPart focused;
                ITool tool = GraphicalViewer.this.getEditDomain().getTool("select tool");
                if (tool != null && tool instanceof SelectTool) {
                    ((SelectTool)tool).resetSeqSelectStart();
                }
                if ((focused = this.findSelectablePart(GraphicalViewer.this.getFocused())) == null || !focused.getStatus().isActive() || !focused.getStatus().isSelected()) {
                    GraphicalViewer.this.setFocused(this.findSelectedPart(parts));
                }
            }
        }

        protected IPart findSelectedPart(List<? extends IPart> parts) {
            for (IPart iPart : parts) {
                if (!iPart.getStatus().isActive() || !iPart.getStatus().isSelected()) continue;
                return iPart;
            }
            return null;
        }
    }
}

