/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.popover;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.popover.PopoverMenuToolItem;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.internal.views.ThemeLabelProvider;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.MindMapUtils;
import org.xml.sax.SAXException;

public class ThemePopoverMenuToolItem
extends PopoverMenuToolItem {
    private static final String THEME_POPOVER_XML = "styles/themePopover.xml";
    private static final String TAG_THEME = "theme";
    private static final String ATTR_ID = "id";
    private static final String Extract_Theme_Command_ID = "org.xmind.ui.command.extractTheme";
    private GalleryViewer viewer;
    private IGraphicalEditor activeEditor;
    private boolean updatingSelection = false;

    @Override
    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite2.getParent().getBackground());
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 2;
        composite2.setLayout((Layout)layout);
        this.createThemesContainer(composite2);
        this.createSeperator(composite2);
        this.createHyperlinks(composite2);
        return composite;
    }

    private void createThemesContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 128, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        this.createThemesViewer(composite);
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof IGraphicalEditor) {
            this.setActiveEditor((IGraphicalEditor)editor);
        }
    }

    private void createThemesViewer(Composite parent) {
        GalleryViewer viewer = new GalleryViewer();
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        viewer.setEditDomain(editDomain);
        Properties properties = viewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.hideTitle", false);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("constrained", true);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(94, 48));
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(0, 0, 2, 2, new Insets(0, 0, 0, 0)));
        Control control = viewer.createControl(parent);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 340;
        control.setLayoutData((Object)gridData);
        viewer.setLabelProvider((IBaseLabelProvider)new ThemeLabelProvider());
        viewer.addOpenListener((IOpenListener)new ChangeThemeListener());
        viewer.setInput(this.getViewerInput());
    }

    private void createSeperator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 2, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Composite seperator = new Composite(composite, 0);
        seperator.setBackground(new LocalResourceManager(JFaceResources.getResources(), (Control)composite).createColor(ColorUtils.toRGB((String)"#cbcbcb")));
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.heightHint = 1;
        seperator.setLayoutData((Object)gridData2);
        seperator.setLayout((Layout)new GridLayout());
    }

    private void createHyperlinks(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 5;
        layout.marginBottom = 5;
        layout.verticalSpacing = 4;
        composite.setLayout((Layout)layout);
        this.createMoreThemesHyperlink(composite);
        this.createManageThemesHyperlink(composite);
        this.createExtractThemeHyperlink(composite);
    }

    private void createMoreThemesHyperlink(Composite parent) {
        Hyperlink moreThemesHyperlink = this.createHyperlink(parent, Messages.ThemesPopover_MoreTheme_label);
        moreThemesHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                E4Utils.showPart("org.xmind.ui.command.showModelPart", PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.xmind.ui.modelPart.themes", null, "org.xmind.ui.stack.right");
            }
        });
    }

    private void createManageThemesHyperlink(Composite parent) {
        Hyperlink manageThemesHyperlink = this.createHyperlink(parent, Messages.ThemesPopover_ManagerTheme_label);
        manageThemesHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                E4Utils.showPart("org.xmind.ui.command.showDialogPart", PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.xmind.ui.dialogPart.resourceManager", "org.xmind.ui.dialogPart.resourceManager.theme", null);
            }
        });
    }

    private void createExtractThemeHyperlink(Composite parent) {
        Hyperlink extractThemeHyperlink = this.createHyperlink(parent, Messages.ThemesPopover_Extract_Current_Theme_label);
        extractThemeHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return;
                }
                IEditorPart editor = page.getActiveEditor();
                if (editor == null) {
                    return;
                }
                final IHandlerService handlerService = (IHandlerService)editor.getSite().getService(IHandlerService.class);
                if (handlerService == null) {
                    return;
                }
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        handlerService.executeCommand(ThemePopoverMenuToolItem.Extract_Theme_Command_ID, null);
                    }
                });
            }
        });
    }

    private Hyperlink createHyperlink(Composite parent, String message) {
        Hyperlink hyperlink = new Hyperlink(parent, 4);
        hyperlink.setBackground(hyperlink.getParent().getBackground());
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        hyperlink.setLayoutData((Object)gridData);
        hyperlink.setUnderlined(false);
        hyperlink.setText(message);
        return hyperlink;
    }

    private List<IStyle> getViewerInput() {
        ArrayList<IStyle> list = new ArrayList<IStyle>();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            Bundle bundle = Platform.getBundle((String)"org.xmind.ui");
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(THEME_POPOVER_XML), null);
            Document doc = documentBuilder.parse(url.openStream());
            IResourceManager rm = MindMapUI.getResourceManager();
            Set systemThemeSets = rm.getSystemThemeSheet().getStyles("master-styles");
            NodeList nodeList = doc.getElementsByTagName(TAG_THEME);
            int i = 0;
            while (i < nodeList.getLength()) {
                Element ele = (Element)nodeList.item(i);
                String themeId = ele.getAttribute(ATTR_ID);
                for (IStyle themeStyle : systemThemeSets) {
                    if (!themeId.equals(themeStyle.getId())) continue;
                    list.add(themeStyle);
                    break;
                }
                ++i;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void setActiveEditor(IGraphicalEditor editor) {
        if (editor != this.activeEditor) {
            this.activeEditor = editor;
            this.updateSelection();
        }
    }

    private void updateSelection() {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        String themeId = this.getCurrentThemeId();
        IStyle theme = MindMapUI.getResourceManager().getBlankTheme();
        if (themeId != null && !theme.getId().equals(themeId) && (theme = MindMapUI.getResourceManager().getSystemThemeSheet().findStyle(themeId)) == null) {
            theme = MindMapUI.getResourceManager().getUserThemeSheet().findStyle(themeId);
        }
        this.updatingSelection = true;
        this.viewer.setSelection((ISelection)(theme == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)theme)));
        this.updatingSelection = false;
    }

    private void changeTheme(IStyle theme, String apply) {
        if (this.activeEditor == null) {
            return;
        }
        IGraphicalEditorPage page = this.activeEditor.getActivePageInstance();
        if (page == null) {
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null) {
            return;
        }
        ISheetPart sheetPart = (ISheetPart)viewer.getAdapter(ISheetPart.class);
        if (sheetPart == null) {
            return;
        }
        EditDomain domain = page.getEditDomain();
        if (domain == null) {
            return;
        }
        domain.handleRequest(new Request("modify_theme").setViewer((IViewer)viewer).setPrimaryTarget((IPart)sheetPart).setParameter("resource", (Object)theme).setParameter("override", (Object)apply));
        this.updateSelection();
        Control control = viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.forceFocus();
        }
    }

    private String getCurrentThemeId() {
        if (this.activeEditor == null) {
            return null;
        }
        IGraphicalEditorPage page = this.activeEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        if (sheet == null) {
            return null;
        }
        return sheet.getThemeId();
    }

    private class ChangeThemeListener
    implements IOpenListener {
        private IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();

        private ChangeThemeListener() {
        }

        public void open(OpenEvent event) {
            Object o;
            if (ThemePopoverMenuToolItem.this.updatingSelection) {
                return;
            }
            String themeApply = this.pref.getString("Theme_Apply");
            if (this.isThemeModified() && ("ASK_USER".equals(themeApply) || "".equals(themeApply))) {
                int code = this.openCoverDialog();
                if (1 == code) {
                    return;
                }
                if (code == 0) {
                    themeApply = "THEME_OVERRIDE";
                } else if (3 == code) {
                    themeApply = "THEME_KEEP";
                }
            }
            if ((o = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null && o instanceof IStyle) {
                ThemePopoverMenuToolItem.this.changeTheme((IStyle)o, themeApply);
            }
        }

        private int openCoverDialog() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell != null) {
                return new ThemeOverrideDialog(shell).open();
            }
            return 3;
        }

        private boolean isThemeModified() {
            ISheet sheet = this.getCurrentSheet();
            if (sheet == null) {
                return false;
            }
            if (sheet.getStyleId() != null) {
                return true;
            }
            List<ITopic> topics = MindMapUtils.getAllTopics(sheet, true, true);
            for (ITopic topic : topics) {
                if (topic.getStyleId() != null) {
                    return true;
                }
                Set boundaries = topic.getBoundaries();
                for (IBoundary boundary : boundaries) {
                    if (boundary.getStyleId() == null) continue;
                    return true;
                }
                Set summaries = topic.getSummaries();
                for (ISummary summary : summaries) {
                    if (summary.getStyleId() == null) continue;
                    return true;
                }
            }
            Set relationships = sheet.getRelationships();
            for (IRelationship relationship : relationships) {
                if (relationship.getStyleId() == null) continue;
                return true;
            }
            return false;
        }

        private ISheet getCurrentSheet() {
            IGraphicalEditor editor;
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (activeEditor instanceof IGraphicalEditor && (editor = (IGraphicalEditor)activeEditor).getActivePageInstance() != null) {
                ISheet sheet = (ISheet)editor.getActivePageInstance().getAdapter(ISheet.class);
                return sheet;
            }
            return null;
        }

        private class ThemeOverrideDialog
        extends Dialog {
            private Button rememberCheck;

            protected ThemeOverrideDialog(Shell parentShell) {
                super(parentShell);
            }

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(Messages.ThemesView_Dialog_title);
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Label label = new Label(composite, 0);
                label.setText(Messages.ThemesView_Dialog_message);
                this.createRememberCheck(composite);
                return composite;
            }

            private void createRememberCheck(Composite parent) {
                Composite composite = new Composite(parent, 0);
                GridLayout gridLayout = new GridLayout(1, false);
                gridLayout.marginTop = 25;
                composite.setLayout((Layout)gridLayout);
                composite.setLayoutData((Object)new GridData(1808));
                this.rememberCheck = new Button(composite, 32);
                this.rememberCheck.setText(Messages.ThemesView_Dialog_Check);
                this.rememberCheck.setLayoutData((Object)new GridData(4, 1024, true, true));
            }

            protected Control createButtonBar(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayoutData((Object)new GridData(4, 4, true, false));
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
                gridLayout.marginBottom = this.convertVerticalDLUsToPixels(7);
                gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                composite.setLayout((Layout)gridLayout);
                this.createPrefLink(composite);
                Composite buttonBar = new Composite(composite, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 0;
                layout.makeColumnsEqualWidth = false;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
                buttonBar.setLayout((Layout)layout);
                buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
                buttonBar.setFont(parent.getFont());
                this.createButtonsForButtonBar(buttonBar);
                return buttonBar;
            }

            private void createPrefLink(Composite parent) {
                Hyperlink prefLink = new Hyperlink(parent, 4);
                prefLink.setText(Messages.ThemesView_Dialog_PrefLink);
                prefLink.setUnderlined(true);
                prefLink.setForeground(parent.getDisplay().getSystemColor(9));
                prefLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.ThemePrefPage", null, null).open();
                    }
                });
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, Messages.ThemesView_OverrideButton, true);
                this.createButton(parent, 3, Messages.ThemesView_KeepButton, false);
            }

            protected void buttonPressed(int buttonId) {
                super.buttonPressed(buttonId);
                if (3 == buttonId) {
                    this.noPressed();
                }
            }

            protected void okPressed() {
                if (this.rememberCheck.getSelection()) {
                    ChangeThemeListener.this.pref.setValue("Theme_Apply", "THEME_OVERRIDE");
                } else {
                    ChangeThemeListener.this.pref.setValue("Theme_Apply", "ASK_USER");
                }
                super.okPressed();
            }

            private void noPressed() {
                if (this.rememberCheck.getSelection()) {
                    ChangeThemeListener.this.pref.setValue("Theme_Apply", "THEME_KEEP");
                } else {
                    ChangeThemeListener.this.pref.setValue("Theme_Apply", "ASK_USER");
                }
                this.setReturnCode(3);
                this.close();
            }
        }
    }
}

