/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.mindmap.INumberFormat;
import org.xmind.ui.mindmap.INumberFormatDescriptor;
import org.xmind.ui.mindmap.INumberFormatManager;
import org.xmind.ui.util.Logger;

public class NumberFormatExtensionManager
extends RegistryReader
implements INumberFormatManager {
    private static final String LANGUAGE_OSGI_NL_KEY = "osgi.nl";
    private static final String SIMPLECHINESEFORMAT = "org.xmind.numbering.simplechinese";
    private static final String TRADITIONALCHINESEFORMAT = "org.xmind.numbering.traditionalchinese";
    private Map<String, NumberFormatProxy> formats = null;
    private List<INumberFormatDescriptor> list = null;
    private Properties configIniProperties;

    NumberFormatExtensionManager() {
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("format".equals(name)) {
            this.readFormat(element);
            return true;
        }
        return false;
    }

    private void readFormat(IConfigurationElement element) {
        NumberFormatProxy proxy;
        try {
            proxy = new NumberFormatProxy(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load numbering format: " + element);
            return;
        }
        String id = proxy.getId();
        if (this.configIniProperties == null) {
            this.configIniProperties = this.loadProperties(this.getConfigFile());
        }
        if (SIMPLECHINESEFORMAT.equals(id) && !"zh_CN".equals(this.configIniProperties.getProperty(LANGUAGE_OSGI_NL_KEY))) {
            return;
        }
        if (TRADITIONALCHINESEFORMAT.equals(id) && !"zh_TW".equals(this.configIniProperties.getProperty(LANGUAGE_OSGI_NL_KEY))) {
            return;
        }
        if (this.formats == null) {
            this.formats = new HashMap<String, NumberFormatProxy>();
        }
        this.formats.put(proxy.getId(), proxy);
        if (this.list == null) {
            this.list = new ArrayList<INumberFormatDescriptor>();
        }
        this.list.add(proxy);
    }

    private void ensureLoaded() {
        if (this.formats != null && this.list != null) {
            return;
        }
        this.lazyLoad();
        if (this.formats == null) {
            this.formats = Collections.emptyMap();
        }
        if (this.list == null) {
            this.list = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "numberFormats");
    }

    @Override
    public INumberFormatDescriptor getDescriptor(String formatId) {
        this.ensureLoaded();
        return this.formats.get(formatId);
    }

    @Override
    public List<INumberFormatDescriptor> getDescriptors() {
        this.ensureLoaded();
        return this.list;
    }

    @Override
    public INumberFormat getFormat(String formatId) {
        this.ensureLoaded();
        return this.formats.get(formatId);
    }

    @Override
    public String getNumberText(String formatId, int index) {
        INumberFormat format = this.getFormat(formatId);
        if (format != null) {
            return format.getText(index);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (!file.canRead()) return null;
        try {
            Properties properties2;
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 1024);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                properties2 = properties;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
                return properties2;
            }
            catch (IOException iOException) {}
            return properties2;
        }
        catch (IOException iOException) {}
        return null;
    }

    private File getConfigFile() {
        URL configDir = Platform.getConfigurationLocation().getURL();
        try {
            URL configIni = new URL(configDir, "config.ini");
            File file = new File(configIni.getFile());
            return file;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class NumberFormatProxy
    implements INumberFormat,
    INumberFormatDescriptor {
        private IConfigurationElement element;
        private String id;
        private String name;
        private String description;
        private INumberFormat implementation;
        private boolean failedInitImplementation = false;

        public NumberFormatProxy(IConfigurationElement element) throws CoreException {
            this.element = element;
            this.id = element.getAttribute("id");
            this.name = element.getAttribute("name");
            this.description = element.getAttribute("description");
            if (NumberFormatExtensionManager.getClassValue((IConfigurationElement)element, (String)"class") == null) {
                throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
            }
        }

        private INumberFormat getImplementation() {
            if (this.implementation == null && !this.failedInitImplementation) {
                try {
                    this.implementation = (INumberFormat)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Logger.log(e, "Failed to create number format from class: " + NumberFormatExtensionManager.getClassValue((IConfigurationElement)this.element, (String)"class"));
                    this.failedInitImplementation = true;
                }
            }
            return this.implementation;
        }

        @Override
        public String getText(int index) {
            INumberFormat impl = this.getImplementation();
            if (impl != null) {
                return impl.getText(index);
            }
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

