/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractLocator;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class RelativeLocator
extends AbstractLocator {
    protected double relativeX;
    protected double relativeY;
    protected boolean isTransform;

    public RelativeLocator() {
        this(0.0, 0.0, false);
    }

    public RelativeLocator(double relativeX, double relativeY) {
        this(relativeX, relativeY, false);
    }

    public RelativeLocator(double relativeX, double relativeY, boolean isTransform) {
        this.relativeX = relativeX;
        this.relativeY = relativeY;
        this.isTransform = isTransform;
    }

    @Override
    public Point2D.Double locate(Figure owner) {
        Point2D.Double location;
        Insets2D.Double insets;
        Rectangle2D.Double bounds = owner.getBounds();
        if (owner instanceof DecoratedFigure && ((DecoratedFigure)owner).getDecorator() != null && (insets = AttributeKeys.DECORATOR_INSETS.get(owner)) != null) {
            insets.addTo(bounds);
        }
        if (this.isTransform) {
            location = new Point2D.Double(bounds.x + bounds.width * this.relativeX, bounds.y + bounds.height * this.relativeY);
            if (AttributeKeys.TRANSFORM.get(owner) != null) {
                AttributeKeys.TRANSFORM.get(owner).transform(location, location);
            }
        } else {
            if (AttributeKeys.TRANSFORM.get(owner) != null) {
                Rectangle2D r = AttributeKeys.TRANSFORM.get(owner).createTransformedShape(bounds).getBounds2D();
                bounds.x = r.getX();
                bounds.y = r.getY();
                bounds.width = r.getWidth();
                bounds.height = r.getHeight();
            }
            location = new Point2D.Double(bounds.x + bounds.width * this.relativeX, bounds.y + bounds.height * this.relativeY);
        }
        return location;
    }

    public static Locator east() {
        return RelativeLocator.east(false);
    }

    public static Locator east(boolean isTransform) {
        return new RelativeLocator(1.0, 0.5, isTransform);
    }

    public static Locator north() {
        return RelativeLocator.north(false);
    }

    public static Locator north(boolean isTransform) {
        return new RelativeLocator(0.5, 0.0, isTransform);
    }

    public static Locator west() {
        return RelativeLocator.west(false);
    }

    public static Locator west(boolean isTransform) {
        return new RelativeLocator(0.0, 0.5, isTransform);
    }

    public static Locator northEast() {
        return RelativeLocator.northEast(false);
    }

    public static Locator northEast(boolean isTransform) {
        return new RelativeLocator(1.0, 0.0, isTransform);
    }

    public static Locator northWest() {
        return RelativeLocator.northWest(false);
    }

    public static Locator northWest(boolean isTransform) {
        return new RelativeLocator(0.0, 0.0, isTransform);
    }

    public static Locator south() {
        return RelativeLocator.south(false);
    }

    public static Locator south(boolean isTransform) {
        return new RelativeLocator(0.5, 1.0, isTransform);
    }

    public static Locator southEast() {
        return RelativeLocator.southEast(false);
    }

    public static Locator southEast(boolean isTransform) {
        return new RelativeLocator(1.0, 1.0, isTransform);
    }

    public static Locator southWest() {
        return RelativeLocator.southWest(false);
    }

    public static Locator southWest(boolean isTransform) {
        return new RelativeLocator(0.0, 1.0, isTransform);
    }

    public static Locator center() {
        return RelativeLocator.center(false);
    }

    public static Locator center(boolean isTransform) {
        return new RelativeLocator(0.5, 0.5, isTransform);
    }

    @Override
    public void write(DOMOutput out) {
        out.addAttribute("relativeX", this.relativeX, 0.5);
        out.addAttribute("relativeY", this.relativeY, 0.5);
    }

    @Override
    public void read(DOMInput in) {
        this.relativeX = in.getAttribute("relativeX", 0.5);
        this.relativeY = in.getAttribute("relativeY", 0.5);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativeLocator other = (RelativeLocator)obj;
        if (this.relativeX != other.relativeX) {
            return false;
        }
        return this.relativeY == other.relativeY;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (int)(Double.doubleToLongBits(this.relativeX) ^ Double.doubleToLongBits(this.relativeX) >>> 32);
        hash = 71 * hash + (int)(Double.doubleToLongBits(this.relativeY) ^ Double.doubleToLongBits(this.relativeY) >>> 32);
        return hash;
    }
}

