/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.trading.Utils;
import org.yccheok.jstock.trading.api.AccountBlotter;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.DriveWealth;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.SessionManager;

public final class AccountManager {
    private static final Log log = LogFactory.getLog(AccountManager.class);

    public static AccountBlotter accBlotter(String userID, String accountID) {
        String url = "users/" + userID + "/accountSummary/" + accountID;
        ArrayList<String> RESULT_FIELDS = new ArrayList<String>(Arrays.asList("accountID", "accountNo", "equity", "cash", "orders", "transactions"));
        HttpRespond respond = Http.get(url, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Account Blotter error - Http");
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Account Blotter error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        return new AccountBlotter(result);
    }

    private static void setReferralCode(Map<String, Object> params) {
        params.put("referralCode", DriveWealth.config.referralCode);
    }

    public static String createPracticeAccFromUser(String userID) {
        String url = "signups/practice";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userID", userID);
        AccountManager.setReferralCode(params);
        String logType = "open_practice";
        HttpRespond respond = Http.post(url, params, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            log.error((Object)"Create Practice Account From User error - Http");
            Utils.remoteLog(logType, -1, "", params);
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Create Practice Acc From User error, code: " + error.code + ", message: " + error.message));
            Utils.remoteLog(logType, statusCode, error.message, params);
            return null;
        }
        String accID = result.get("accountID").toString();
        log.info((Object)("New practice a/c created, accountID: " + accID));
        Utils.remoteLog(logType, statusCode, "", params);
        return accID;
    }

    public static Pair<Map<String, Object>, String> createPracticeAcc(Map<String, Object> params) {
        String url = "signups/practice";
        ArrayList<String> INPUT_FIELDS = new ArrayList<String>(Arrays.asList("emailAddress1", "firstName", "lastName", "username", "password", "languageID", "tranAmount", "referralCode", "utm_campaign", "utm_content", "utm_medium", "utm_source", "utm_term", "wlpID"));
        ArrayList<String> OUTPUT_FIELDS = new ArrayList<String>(Arrays.asList("username", "password", "userID"));
        AccountManager.setReferralCode(params);
        String logType = "open_practice";
        HttpRespond respond = Http.post(url, params, null);
        if (respond == null) {
            log.error((Object)"Create Practice Account error - Http");
            Utils.remoteLog(logType, -1, "", params);
            return new Pair<Object, String>(null, ApiError.commonMsg());
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Create Practice Acc error, code: " + error.code + ", message: " + error.message));
            Utils.remoteLog(logType, statusCode, error.message, params);
            return new Pair<Object, String>(null, error.message);
        }
        String userID = result.get("userID").toString();
        log.info((Object)("New practice a/c created for userID: " + userID));
        Utils.remoteLog(logType, statusCode, "", params);
        return new Pair<Map, Object>(result, null);
    }

    public static List<Map<String, Object>> listAllAccounts(String userID) {
        ArrayList<String> ACCOUNT_FIELDS = new ArrayList<String>(Arrays.asList("accountID", "accountNo", "userID", "currencyID", "accountType", "cash", "freeTradeBalance", "goodFaithViolations", "interestFree", "orders", "patternDayTrades", "positions", "status", "tradingType", "bodMoneyMarket", "bodEquityValue", "bodCashAvailForWith", "bodCashAvailForTrading", "rtCashAvailForTrading", "rtCashAvailForWith", "accountMgmtType", "longOnly"));
        HttpRespond respond = Http.get("users/" + userID + "/accounts", SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        List result = (List)new Gson().fromJson(body, ArrayList.class);
        return result;
    }

    public static Map<String, Object> createLiveAccount(Map<String, Object> params) {
        ArrayList<String> INPUT_FIELDS = new ArrayList<String>(Arrays.asList("ownershipType", "userID", "emailAddress1", "emailAddress2", "firstName", "lastName", "username", "password", "gender", "languageID", "phoneHome", "phoneWork", "phoneMobile", "addressLine1", "addressLine2", "city", "countryID", "stateProvince", "wlpID", "zipPostalCode", "dob", "maritalStatus", "idNo", "usCitizen", "referralCode", "tradingType", "citizenship", "utm_campaign", "utm_content", "utm_medium", "utm_source", "utm_term", "employerBusiness", "employerCompany", "employerAddressLine1", "employerAddressLine2", "employerCity", "employerStateProvince", "employerZipPostalCode", "employerCountryID", "employerIsBroker", "employmentPosition", "employmentStatus", "employmentYears", "annualIncome", "investmentObjectives", "investmentExperience", "networthLiquid", "networthTotal", "director", "directorOf", "politicallyExposed", "politicallyExposedNames", "riskTolerance", "disclosureAck", "disclosureRule14b", "ackCustomerAgreement", "ackSweep", "ackFindersFee", "ackForeignFindersFee", "ackMarketData", "ackSignedBy", "ackSignedWhen", "ackSigned", "accountMgmtType"));
        AccountManager.setReferralCode(params);
        String logType = "open_live";
        HttpRespond respond = Http.post("signups/live", params, SessionManager.getInstance().getSessionKey());
        if (respond == null) {
            Utils.remoteLog(logType, -1, "", params);
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            Utils.remoteLog(logType, statusCode, error.message, params);
            return null;
        }
        Utils.remoteLog(logType, statusCode, "", params);
        return result;
    }

    public static boolean addDocument(String userID, DocumentType docType, File file) {
        if (userID == null || docType == null || file == null) {
            return false;
        }
        Part[] parts = new Part[3];
        parts[0] = new StringPart("token", userID);
        parts[1] = new StringPart("documentType", docType.value);
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        try {
            parts[2] = new FilePart("documentImage", file, contentType, null);
        }
        catch (FileNotFoundException ex) {
            log.error(null, (Throwable)ex);
        }
        PostMethod postMethod = new PostMethod(DriveWealth.config.apiURL + "documents");
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
        postMethod.addRequestHeader("x-mysolomeo-session-key", SessionManager.getInstance().getSessionKey());
        HttpRespond respond = Http.executeCall((HttpMethod)postMethod);
        String logType = "uploadDoc_live";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userID", userID);
        params.put("documentType", docType.value);
        if (respond == null) {
            log.error((Object)"addDocument API - respond is NULL");
            Utils.remoteLog(logType, -1, "", params);
            return false;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)new Gson().fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("addDocument Error, code: " + statusCode + ", message: " + error.message));
            Utils.remoteLog(logType, statusCode, error.message, params);
            return false;
        }
        Utils.remoteLog(logType, statusCode, "", params);
        return true;
    }

    public static enum DocumentType {
        PICTURE_ID("Picture ID"),
        PROOF_OF_ADDRESS("Proof of address"),
        PICTURE_ID_PROOF_OF_ADDRESS("Picture ID_Proof of address");

        public final String value;

        private DocumentType(String value) {
            this.value = value;
        }
    }
}

