/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.portfolio;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.yccheok.jstock.gui.portfolio.AutoDividendJDialog;
import org.yccheok.jstock.gui.portfolio.AutoDividendRowJPanel;
import org.yccheok.jstock.portfolio.Dividend;

public class AutoDividendJPanel
extends JPanel {
    private final List<AutoDividendRowJPanel> autoDividendRowJPanels = new ArrayList<AutoDividendRowJPanel>();
    private final AutoDividendJDialog autoDividendJDialog;
    private static final Color GREEN = new Color(140, 196, 116);
    private static final Color RED = new Color(244, 129, 89);
    private JCheckBox jCheckBox2;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public AutoDividendJPanel(AutoDividendJDialog autoDividendJDialog, List<Dividend> dividends) {
        this.initComponents();
        assert (!dividends.isEmpty());
        this.autoDividendJDialog = autoDividendJDialog;
        this.jCheckBox2.setText(dividends.get((int)0).stockInfo.symbol.toString());
        for (Dividend dividend : dividends) {
            AutoDividendRowJPanel autoDividendRowJPanel = new AutoDividendRowJPanel(this, dividend);
            this.autoDividendRowJPanels.add(autoDividendRowJPanel);
            this.jPanel2.add(autoDividendRowJPanel);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public List<Dividend> getSelectedDividends() {
        if (!this.jCheckBox2.isSelected()) {
            return Collections.emptyList();
        }
        ArrayList<Dividend> dividends = new ArrayList<Dividend>();
        for (AutoDividendRowJPanel autoDividendRowJPanel : this.autoDividendRowJPanels) {
            if (!autoDividendRowJPanel.isSelected() || !(autoDividendRowJPanel.getAmount() > 0.0)) continue;
            dividends.add(autoDividendRowJPanel.getDividend());
        }
        return dividends;
    }

    public double getSelectedAmount() {
        if (!this.jCheckBox2.isSelected()) {
            return 0.0;
        }
        double amount = 0.0;
        for (AutoDividendRowJPanel autoDividendRowJPanel : this.autoDividendRowJPanels) {
            if (!autoDividendRowJPanel.isSelected()) continue;
            amount += autoDividendRowJPanel.getAmount();
        }
        return amount;
    }

    public int getSelectedCount() {
        if (!this.jCheckBox2.isSelected()) {
            return 0;
        }
        int count = 0;
        for (AutoDividendRowJPanel autoDividendRowJPanel : this.autoDividendRowJPanels) {
            if (!autoDividendRowJPanel.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public boolean isSelected() {
        if (!this.jCheckBox2.isSelected()) {
            return false;
        }
        for (AutoDividendRowJPanel autoDividendRowJPanel : this.autoDividendRowJPanels) {
            if (!autoDividendRowJPanel.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void updateTotalLabel() {
        this.autoDividendJDialog.updateTotalLabel();
    }

    public void updateJCheckBoxColor() {
        if (this.isSelected()) {
            this.jCheckBox2.setBackground(GREEN);
        } else {
            this.jCheckBox2.setBackground(RED);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCheckBox2 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jCheckBox2.setBackground(new Color(140, 196, 116));
        this.jCheckBox2.setForeground(new Color(255, 255, 255));
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("PBBANK");
        this.jCheckBox2.setFocusPainted(false);
        this.jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                AutoDividendJPanel.this.jCheckBox2ItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jCheckBox2);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.add((Component)this.jPanel2, "Center");
    }

    private void jCheckBox2ItemStateChanged(ItemEvent evt) {
        boolean enabled = evt.getStateChange() == 1;
        for (AutoDividendRowJPanel autoDividendRowJPanel : this.autoDividendRowJPanels) {
            autoDividendRowJPanel.setEnabled(enabled);
        }
        this.updateJCheckBoxColor();
        this.autoDividendJDialog.updateTotalLabel();
    }

    public void updateTaxInfo(double tax, double taxRate) {
        for (AutoDividendRowJPanel autoDividendRowJPanel : this.autoDividendRowJPanels) {
            autoDividendRowJPanel.updateTaxInfo(tax, taxRate);
        }
    }
}

