/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Currency;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXHeader;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.gui.DocumentSizeFilter;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;
import org.yccheok.jstock.portfolio.DecimalPlace;

public class OptionsSellAdvisorJPanel
extends JPanel
implements JStockOptionsObserver {
    private static final Log log = LogFactory.getLog(OptionsSellAdvisorJPanel.class);
    private static final DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel defaultCountryComboBoxModel = new DefaultComboBoxModel();
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JComboBox jComboBox3;
    private JFormattedTextField jFormattedTextField1;

    public OptionsSellAdvisorJPanel() {
        Document document;
        this.initComponents();
        Component component = this.jComboBox1.getEditor().getEditorComponent();
        if (component instanceof JTextComponent && (document = ((JTextComponent)component).getDocument()) instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentFilter(new DocumentSizeFilter(5));
        }
    }

    private void initComponents() {
        JXHeader jXHeader1 = new JXHeader();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jFormattedTextField1 = this.getPercentageJFormattedTextField();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jComboBox3 = new JComboBox();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        jXHeader1.setDescription(bundle.getString("OptionsSellAdvisorJPanel_Description"));
        jXHeader1.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/32x32/money3.png")));
        jXHeader1.setTitle(bundle.getString("OptionsSellAdvisorJPanel_Wealth"));
        this.add((Component)jXHeader1, "North");
        jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsSellAdvisorJPanel_BestSellPriceSuggestion")));
        jLabel1.setText(bundle.getString("OptionsSellAdvisorJPanel_ExpectedProfitPercentage"));
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextField1, -2, 58, -2).addContainerGap(135, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jFormattedTextField1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsSellAdvisorJPanel_Wealth")));
        jLabel3.setText(bundle.getString("OptionsSellAdvisorJPanel_StockValueDisplay"));
        this.jComboBox3.setModel(this.getDecimalPlaceComboBoxModel());
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(12, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.jComboBox3, -2, -1, -2)).addContainerGap()));
        jPanel4.setBorder(BorderFactory.createTitledBorder(bundle.getString("OptionsSellAdvisorJPanel_Currency")));
        jLabel2.setText(bundle.getString("OptionsSellAdvisorJPanel_Symbol"));
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(OptionsSellAdvisorJPanel.getComboBoxModel());
        this.jComboBox2.setModel(this.getCountryComboBoxModel());
        this.jComboBox2.setRenderer(new MyCellRenderer());
        this.jCheckBox1.setText(bundle.getString("OptionsSellAdvisorJPanel_Currency"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OptionsSellAdvisorJPanel.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1).addGroup(jPanel4Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, -2, 64, -2).addComponent(this.jComboBox2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jComboBox2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel4, -2, -1, -2).addContainerGap(21, Short.MAX_VALUE)));
        this.add((Component)jPanel1, "Center");
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        this.updateGUIState();
    }

    private void updateGUIState() {
        this.jComboBox2.setEnabled(this.jCheckBox1.isSelected());
    }

    private JFormattedTextField getPercentageJFormattedTextField() {
        NumberFormat format = NumberFormat.getNumberInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Double.valueOf(0.0));
        formatter.setMaximum(null);
        formatter.setValueClass(Double.class);
        JFormattedTextField field = new JFormattedTextField(formatter);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComboBoxModel getCountryComboBoxModel() {
        DefaultComboBoxModel defaultComboBoxModel = this.defaultCountryComboBoxModel;
        synchronized (defaultComboBoxModel) {
            if (this.defaultCountryComboBoxModel.getSize() > 0) {
                return this.defaultCountryComboBoxModel;
            }
            for (Country country : Country.values()) {
                this.defaultCountryComboBoxModel.addElement(country);
            }
        }
        return this.defaultCountryComboBoxModel;
    }

    private ComboBoxModel getDecimalPlaceComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{MessageFormat.format(GUIBundle.getString("OptionsSellAdvisorJPanel_DecimalPlaces_template"), 2), MessageFormat.format(GUIBundle.getString("OptionsSellAdvisorJPanel_DecimalPlaces_template"), 3), MessageFormat.format(GUIBundle.getString("OptionsSellAdvisorJPanel_DecimalPlaces_template"), 4)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ComboBoxModel getComboBoxModel() {
        DefaultComboBoxModel defaultComboBoxModel = OptionsSellAdvisorJPanel.defaultComboBoxModel;
        synchronized (defaultComboBoxModel) {
            if (OptionsSellAdvisorJPanel.defaultComboBoxModel.getSize() > 0) {
                return OptionsSellAdvisorJPanel.defaultComboBoxModel;
            }
            String[] countries = new String[]{"AU", "AT", "BE", "BR", "CA", "CN", "CZ", "DK", "FR", "DE", "HK", "HU", "IN", "ID", "IT", "KR", "MY", "NL", "NZ", "NO", "PT", "SG", "ES", "SE", "CH", "TW", "GB", "US"};
            List<String> countryList = Arrays.asList(countries);
            Locale[] locales = Locale.getAvailableLocales();
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            set.add(Utils.getDefaultCurrencySymbol());
            for (Locale locale : locales) {
                if (!countryList.contains(locale.getCountry())) continue;
                set.add(Currency.getInstance(locale).getSymbol(locale));
            }
            for (String s : set) {
                OptionsSellAdvisorJPanel.defaultComboBoxModel.addElement(s);
            }
        }
        return OptionsSellAdvisorJPanel.defaultComboBoxModel;
    }

    private void commitEdit() {
        try {
            this.jFormattedTextField1.commitEdit();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.jFormattedTextField1.setValue(jStockOptions.getExpectedProfitPercentage());
        this.jComboBox1.setSelectedItem(jStockOptions.getCurrencySymbol(jStockOptions.getCountry()));
        this.jComboBox2.setSelectedItem((Object)jStockOptions.getLocalCurrencyCountry(jStockOptions.getCountry()));
        this.jCheckBox1.setSelected(jStockOptions.isCurrencyExchangeEnable(jStockOptions.getCountry()));
        this.jComboBox3.setSelectedIndex(jStockOptions.getDecimalPlace().ordinal());
        this.commitEdit();
        this.updateGUIState();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        this.commitEdit();
        jStockOptions.setExpectedProfitPercentage((Double)this.jFormattedTextField1.getValue());
        String currencySymbol = this.jComboBox1.getSelectedItem().toString().trim();
        if (!currencySymbol.isEmpty()) {
            jStockOptions.setCurrencySymbol(jStockOptions.getCountry(), currencySymbol);
        }
        jStockOptions.setCurrencyExchangeEnable(jStockOptions.getCountry(), this.jCheckBox1.isSelected());
        jStockOptions.setLocalCurrencyCountry(jStockOptions.getCountry(), (Country)((Object)this.jComboBox2.getSelectedItem()));
        jStockOptions.setDecimalPlace(DecimalPlace.values()[this.jComboBox3.getSelectedIndex()]);
        JStock.instance().getPortfolioManagementJPanel().refreshCurrencySymbol();
        JStock.instance().initExchangeRateMonitor();
        return true;
    }

    private static class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Country) {
                Country country = (Country)((Object)value);
                this.setText(country.humanString);
                this.setIcon(country.icon);
            } else {
                String s = value.toString();
                this.setText(s);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

