/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.file;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Board;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Industry;
import org.yccheok.jstock.engine.Intraday;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.StockNameDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Atom;
import org.yccheok.jstock.file.CSVHelper;
import org.yccheok.jstock.file.GUIBundleWrapper;
import org.yccheok.jstock.file.Statement;
import org.yccheok.jstock.file.ThreadSafeFileLock;
import org.yccheok.jstock.file.Utils;
import org.yccheok.jstock.gui.BackwardCompatible;
import org.yccheok.jstock.gui.POIUtils;
import org.yccheok.jstock.gui.StockTableModel;
import org.yccheok.jstock.gui.portfolio.CommentableContainer;
import org.yccheok.jstock.gui.treetable.BuyPortfolioTreeTableModelEx;
import org.yccheok.jstock.gui.treetable.SellPortfolioTreeTableModelEx;
import org.yccheok.jstock.portfolio.Portfolio;
import org.yccheok.jstock.portfolio.PortfolioInfo;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;
import org.yccheok.jstock.watchlist.WatchlistInfo;

public class Statements {
    public static final Statements UNKNOWN_STATEMENTS = new Statements(Statement.Type.Unknown, GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.DEFAULT));
    private final Statement.Type type;
    private final GUIBundleWrapper guiBundleWrapper;
    private final List<Statement> statements = new ArrayList<Statement>();
    private final Map<String, String> metadatas = new LinkedHashMap<String, String>();
    private static final Log log = LogFactory.getLog(Statements.class);

    private Statements(Statement.Type type, GUIBundleWrapper guiBundleWrapper) {
        this.type = type;
        this.guiBundleWrapper = guiBundleWrapper;
    }

    public static Statements newInstanceFromBuyPortfolioTreeTableModel(BuyPortfolioTreeTableModelEx buyPortfolioTreeTableModel, PortfolioRealTimeInfo portfolioRealTimeInfo, boolean languageIndependent) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(languageIndependent ? GUIBundleWrapper.Language.INDEPENDENT : GUIBundleWrapper.Language.DEFAULT);
        String[] tmp = new String[]{guiBundleWrapper.getString("MainFrame_Code"), guiBundleWrapper.getString("MainFrame_Symbol"), guiBundleWrapper.getString("PortfolioManagementJPanel_Date"), guiBundleWrapper.getString("PortfolioManagementJPanel_Units"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"), guiBundleWrapper.getString("PortfolioManagementJPanel_CurrentPrice"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_CurrentValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice"), guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage"), guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"), guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"), guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"), guiBundleWrapper.getString("PortfolioManagementJPanel_NetPurchaseValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage"), guiBundleWrapper.getString("PortfolioManagementJPanel_Comment")};
        Statement.What what = Statement.what(Arrays.asList(tmp));
        Statements statements = new Statements(what.type, what.guiBundleWrapper);
        Portfolio portfolio = (Portfolio)buyPortfolioTreeTableModel.getRoot();
        int summaryCount = portfolio.getChildCount();
        for (int i = 0; i < summaryCount; ++i) {
            TreeTableNode o = portfolio.getChildAt(i);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            String comment = transactionSummary.getComment().trim();
            if (!comment.isEmpty()) {
                StockInfo stockInfo = ((Transaction)transactionSummary.getChildAt(0)).getStockInfo();
                statements.metadatas.put(stockInfo.code.toString(), comment);
            }
            int transactionCount = transactionSummary.getChildCount();
            for (int j = 0; j < transactionCount; ++j) {
                Transaction transaction = (Transaction)transactionSummary.getChildAt(j);
                StockInfo stockInfo = transaction.getStockInfo();
                boolean shouldConvertPenceToPound = org.yccheok.jstock.portfolio.Utils.shouldConvertPenceToPound(portfolioRealTimeInfo, stockInfo.code);
                ArrayList<Atom> atoms = new ArrayList<Atom>();
                atoms.add(new Atom(stockInfo.code.toString(), tmp[0]));
                atoms.add(new Atom(stockInfo.symbol.toString(), tmp[1]));
                String dateString = transaction.getDate() != null ? org.yccheok.jstock.gui.Utils.commonDateFormat(transaction.getDate().getTime()) : "";
                atoms.add(new Atom(dateString, tmp[2]));
                atoms.add(new Atom(transaction.getQuantity(), tmp[3]));
                atoms.add(new Atom(transaction.getPrice(), tmp[4]));
                atoms.add(new Atom(buyPortfolioTreeTableModel.getCurrentPrice(transaction), tmp[5]));
                if (!shouldConvertPenceToPound) {
                    atoms.add(new Atom(transaction.getTotal(), tmp[6]));
                } else {
                    atoms.add(new Atom(transaction.getTotal() / 100.0, tmp[6]));
                }
                atoms.add(new Atom(buyPortfolioTreeTableModel.getCurrentValue(transaction), tmp[7]));
                atoms.add(new Atom(buyPortfolioTreeTableModel.getGainLossPrice(transaction), tmp[8]));
                if (!shouldConvertPenceToPound) {
                    atoms.add(new Atom(buyPortfolioTreeTableModel.getGainLossValue(transaction), tmp[9]));
                } else {
                    atoms.add(new Atom(buyPortfolioTreeTableModel.getGainLossValue(transaction) / 100.0, tmp[9]));
                }
                atoms.add(new Atom(buyPortfolioTreeTableModel.getGainLossPercentage(transaction), tmp[10]));
                atoms.add(new Atom(transaction.getBroker(), tmp[11]));
                atoms.add(new Atom(transaction.getClearingFee(), tmp[12]));
                atoms.add(new Atom(transaction.getStampDuty(), tmp[13]));
                if (!shouldConvertPenceToPound) {
                    atoms.add(new Atom(transaction.getNetTotal(), tmp[14]));
                    atoms.add(new Atom(buyPortfolioTreeTableModel.getNetGainLossValue(transaction), tmp[15]));
                } else {
                    atoms.add(new Atom(transaction.getNetTotal() / 100.0, tmp[14]));
                    atoms.add(new Atom(buyPortfolioTreeTableModel.getNetGainLossValue(transaction) / 100.0, tmp[15]));
                }
                atoms.add(new Atom(buyPortfolioTreeTableModel.getNetGainLossPercentage(transaction), tmp[16]));
                atoms.add(new Atom(transaction.getComment(), tmp[17]));
                Statement statement = new Statement(atoms);
                if (statements.getType() != statement.getType()) {
                    return UNKNOWN_STATEMENTS;
                }
                statements.statements.add(statement);
            }
        }
        return statements;
    }

    public static Statements newInstanceFromStockHistoryServer(StockHistoryServer server, boolean languageIndependent) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(languageIndependent ? GUIBundleWrapper.Language.INDEPENDENT : GUIBundleWrapper.Language.DEFAULT);
        Statements s = new Statements(Statement.Type.StockHistory, guiBundleWrapper);
        int size = server.size();
        Stock stock = null;
        for (int i = 0; i < size; ++i) {
            long timestamp = server.getTimestamp(i);
            stock = server.getStock(timestamp);
            assert (timestamp != 0L && stock != null);
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            Atom atom0 = new Atom(org.yccheok.jstock.gui.Utils.commonDateFormat(timestamp), guiBundleWrapper.getString("StockHistory_Date"));
            Atom atom1 = new Atom(stock.getOpenPrice(), guiBundleWrapper.getString("StockHistory_Open"));
            Atom atom2 = new Atom(stock.getHighPrice(), guiBundleWrapper.getString("StockHistory_High"));
            Atom atom3 = new Atom(stock.getLowPrice(), guiBundleWrapper.getString("StockHistory_Low"));
            Atom atom4 = new Atom(stock.getLastPrice(), guiBundleWrapper.getString("StockHistory_Close"));
            Atom atom5 = new Atom(stock.getVolume(), guiBundleWrapper.getString("StockHistory_Volume"));
            atoms.add(atom0);
            atoms.add(atom1);
            atoms.add(atom2);
            atoms.add(atom3);
            atoms.add(atom4);
            atoms.add(atom5);
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        if (stock != null) {
            s.metadatas.put("code", stock.code.toString());
            s.metadatas.put("symbol", stock.symbol.toString());
            s.metadatas.put("name", stock.getName());
            s.metadatas.put("board", stock.getBoard().name());
            s.metadatas.put("industry", stock.getIndustry().name());
            s.metadatas.put("timeZone", server.getTimeZone().getID());
            String openTs = "";
            String closeTs = "";
            Intraday intraday = server.getIntraday();
            if (intraday != null) {
                openTs = Long.toString(intraday.open);
                closeTs = Long.toString(intraday.close);
            }
            s.metadatas.put("intradayOpen", openTs);
            s.metadatas.put("intradayClose", closeTs);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Statements> newInstanceFromExcelFile(File file) {
        FileInputStream fileInputStream = null;
        ArrayList<Statements> statementsList = new ArrayList<Statements>();
        try {
            fileInputStream = new FileInputStream(file);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fileInputStream);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            int numberOfSheets = wb.getNumberOfSheets();
            for (int k = 0; k < numberOfSheets; ++k) {
                HSSFRow row;
                HSSFSheet sheet = wb.getSheetAt(k);
                int startRow = sheet.getFirstRowNum();
                int endRow = sheet.getLastRowNum();
                if (startRow != 0 || endRow <= startRow || (row = sheet.getRow(startRow)) == null) continue;
                int startCell = row.getFirstCellNum();
                short endCell = row.getLastCellNum();
                if (startCell != 0 || endCell <= startCell) continue;
                ArrayList<String> types = new ArrayList<String>();
                for (int i = startCell; i < endCell; ++i) {
                    String type;
                    HSSFCell cell = row.getCell(i);
                    if (cell == null || (type = cell.getRichStringCellValue().getString()) == null) continue;
                    types.add(type);
                }
                if (types.isEmpty() || types.size() != endCell - startCell) continue;
                Statement.What what = Statement.what(types);
                Statements s = new Statements(what.type, what.guiBundleWrapper);
                for (int i = startRow + 1; i <= endRow; ++i) {
                    HSSFRow r = sheet.getRow(i);
                    if (r == null) continue;
                    ArrayList<Atom> atoms = new ArrayList<Atom>();
                    for (int j = startCell; j < endCell; ++j) {
                        HSSFCell cell = r.getCell(j);
                        if (cell == null) continue;
                        Object value = null;
                        if (cell.getCellType() == 1) {
                            HSSFRichTextString richString = cell.getRichStringCellValue();
                            value = richString != null ? richString.getString() : "";
                        } else if (cell.getCellType() == 0) {
                            try {
                                value = new Double(cell.getNumericCellValue());
                            }
                            catch (NumberFormatException ex) {
                                log.error(null, (Throwable)ex);
                                value = new Double(0.0);
                            }
                        }
                        if (null == value) continue;
                        atoms.add(new Atom(value, (String)types.get(j - startCell)));
                    }
                    Statement statement = new Statement(atoms);
                    if (s.getType() != statement.getType()) {
                        s = null;
                        break;
                    }
                    s.statements.add(statement);
                }
                if (s == null) continue;
                statementsList.add(s);
            }
        }
        catch (Exception ex) {
            try {
                log.error(null, (Throwable)ex);
            }
            catch (Throwable throwable) {
                Utils.close(fileInputStream);
                throw throwable;
            }
            Utils.close(fileInputStream);
        }
        Utils.close(fileInputStream);
        return statementsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Statements newInstanceFromCSVFile(File file) {
        Statements s;
        boolean status;
        block35: {
            ThreadSafeFileLock.Lock lock;
            CSVReader csvreader;
            InputStreamReader inputStreamReader;
            FileInputStream fileInputStream;
            block33: {
                block34: {
                    Statements statements;
                    block31: {
                        block32: {
                            String[] tokens;
                            block29: {
                                block30: {
                                    boolean needToPerformBackwardCompatible = BackwardCompatible.needToPerformBackwardCompatible(file);
                                    boolean needToHandleMetadata = BackwardCompatible.needToHandleMetadata(file);
                                    status = false;
                                    fileInputStream = null;
                                    inputStreamReader = null;
                                    csvreader = null;
                                    s = null;
                                    lock = ThreadSafeFileLock.getLock(file);
                                    if (lock == null) {
                                        return UNKNOWN_STATEMENTS;
                                    }
                                    ThreadSafeFileLock.lockRead(lock);
                                    try {
                                        fileInputStream = new FileInputStream(file);
                                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                                        csvreader = new CSVReader((Reader)inputStreamReader);
                                        ArrayList<String> types = new ArrayList<String>();
                                        LinkedHashMap<String, String[]> metadatas = new LinkedHashMap<String, String[]>();
                                        String[] nextLine = csvreader.readNext();
                                        if (nextLine != null) {
                                            while (nextLine != null && nextLine.length == 1 && (tokens = nextLine[0].split("=", 2)).length == 2) {
                                                String key = tokens[0].trim();
                                                String[] value = tokens[1].trim();
                                                if (needToHandleMetadata) {
                                                    key = BackwardCompatible.toGoogleCodeIfPossible(key);
                                                }
                                                if (key.length() <= 0) break;
                                                metadatas.put(key, value);
                                                nextLine = csvreader.readNext();
                                            }
                                            if (nextLine != null) {
                                                types.addAll(Arrays.asList(nextLine));
                                            }
                                        }
                                        if (types.isEmpty()) {
                                            tokens = UNKNOWN_STATEMENTS;
                                            if (csvreader == null) break block29;
                                            break block30;
                                        }
                                        Statement.What what = Statement.what(types);
                                        s = new Statements(what.type, what.guiBundleWrapper);
                                        while ((nextLine = csvreader.readNext()) != null) {
                                            if (nextLine.length != types.size()) {
                                                log.error((Object)("Incorrect CSV format. There should be exactly " + types.size() + " item(s)"));
                                                continue;
                                            }
                                            int i = 0;
                                            ArrayList<Atom> atoms = new ArrayList<Atom>();
                                            for (String value : nextLine) {
                                                String type = (String)types.get(i++);
                                                if (needToPerformBackwardCompatible && type.equals("Code")) {
                                                    value = BackwardCompatible.toGoogleCodeIfPossible(value);
                                                }
                                                Atom atom = new Atom(value, type);
                                                atoms.add(atom);
                                            }
                                            Statement statement = new Statement(atoms);
                                            if (s.getType() != statement.getType()) {
                                                statements = UNKNOWN_STATEMENTS;
                                                if (csvreader == null) break block31;
                                                break block32;
                                            }
                                            s.statements.add(statement);
                                        }
                                        s.metadatas.putAll(metadatas);
                                        status = true;
                                        if (csvreader == null) break block33;
                                        break block34;
                                    }
                                    catch (IOException ex) {
                                        log.error(null, (Throwable)ex);
                                        break block35;
                                    }
                                }
                                try {
                                    csvreader.close();
                                }
                                catch (IOException ex) {
                                    log.error(null, (Throwable)ex);
                                }
                            }
                            Utils.close(inputStreamReader);
                            Utils.close(fileInputStream);
                            ThreadSafeFileLock.unlockRead(lock);
                            ThreadSafeFileLock.releaseLock(lock);
                            return tokens;
                        }
                        try {
                            csvreader.close();
                        }
                        catch (IOException ex) {
                            log.error(null, (Throwable)ex);
                        }
                    }
                    Utils.close(inputStreamReader);
                    Utils.close(fileInputStream);
                    ThreadSafeFileLock.unlockRead(lock);
                    ThreadSafeFileLock.releaseLock(lock);
                    return statements;
                }
                try {
                    csvreader.close();
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            Utils.close(inputStreamReader);
            Utils.close(fileInputStream);
            ThreadSafeFileLock.unlockRead(lock);
            ThreadSafeFileLock.releaseLock(lock);
            break block35;
            finally {
                if (csvreader != null) {
                    try {
                        csvreader.close();
                    }
                    catch (IOException ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
                Utils.close(inputStreamReader);
                Utils.close(fileInputStream);
                ThreadSafeFileLock.unlockRead(lock);
                ThreadSafeFileLock.releaseLock(lock);
            }
        }
        if (!status) return UNKNOWN_STATEMENTS;
        return s;
    }

    public static Statements newInstanceFromUserDefinedDatabase(List<Pair<Code, Symbol>> pairs) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        Statements s = new Statements(Statement.Type.UserDefinedDatabase, guiBundleWrapper);
        String code_string = guiBundleWrapper.getString("MainFrame_Code");
        String symbol_string = guiBundleWrapper.getString("MainFrame_Symbol");
        for (Pair<Code, Symbol> pair : pairs) {
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            atoms.add(new Atom(pair.first, code_string));
            atoms.add(new Atom(pair.second, symbol_string));
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        return s;
    }

    public static Statements newInstanceFromStockNameDatabase(StockNameDatabase stockNameDatabase) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        Statements s = new Statements(Statement.Type.StockNameDatabase, guiBundleWrapper);
        String code_string = guiBundleWrapper.getString("MainFrame_Code");
        String name_string = guiBundleWrapper.getString("MainFrame_Name");
        for (Map.Entry<Code, String> entry : stockNameDatabase.getCodeToName().entrySet()) {
            Code code = entry.getKey();
            String name = entry.getValue();
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            atoms.add(new Atom(code, code_string));
            atoms.add(new Atom(name, name_string));
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        return s;
    }

    public static Statements newInstanceFromWatchlistInfos(List<WatchlistInfo> wathclistInfos) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        Statements s = new Statements(Statement.Type.WatchlistInfos, guiBundleWrapper);
        String country_string = guiBundleWrapper.getString("WatchlistInfo_Country");
        String name_string = guiBundleWrapper.getString("WatchlistInfo_Name");
        String size_string = guiBundleWrapper.getString("WatchlistInfo_Size");
        for (WatchlistInfo watchlistInfo : wathclistInfos) {
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            atoms.add(new Atom((Object)watchlistInfo.country, country_string));
            atoms.add(new Atom(watchlistInfo.name, name_string));
            atoms.add(new Atom(watchlistInfo.size, size_string));
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        return s;
    }

    public static Statements newInstanceFromPortfolioInfos(List<PortfolioInfo> portfolioInfos) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        Statements s = new Statements(Statement.Type.PortfolioInfos, guiBundleWrapper);
        String country_string = guiBundleWrapper.getString("PortfolioInfo_Country");
        String name_string = guiBundleWrapper.getString("PortfolioInfo_Name");
        String size_string = guiBundleWrapper.getString("PortfolioInfo_Size");
        for (PortfolioInfo portfolioInfo : portfolioInfos) {
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            atoms.add(new Atom((Object)portfolioInfo.country, country_string));
            atoms.add(new Atom(portfolioInfo.name, name_string));
            atoms.add(new Atom(portfolioInfo.size, size_string));
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        return s;
    }

    public static Statements newInstanceFromStockInfoDatabase(StockInfoDatabase stockInfoDatabase) {
        List<StockInfo> stockInfos;
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        Statements s = new Statements(Statement.Type.StockInfoDatabase, guiBundleWrapper);
        HashMap<StockInfo, Industry> stockInfo2Industry = new HashMap<StockInfo, Industry>();
        HashMap<StockInfo, Board> stockInfo2Board = new HashMap<StockInfo, Board>();
        List<Industry> industries = stockInfoDatabase.getIndustries();
        List<Board> boards = stockInfoDatabase.getBoards();
        for (Industry industry : industries) {
            stockInfos = stockInfoDatabase.getStockInfos(industry);
            for (StockInfo stockInfo : stockInfos) {
                stockInfo2Industry.put(stockInfo, industry);
            }
        }
        for (Board board : boards) {
            stockInfos = stockInfoDatabase.getStockInfos(board);
            for (StockInfo stockInfo : stockInfos) {
                stockInfo2Board.put(stockInfo, board);
            }
        }
        String code_string = guiBundleWrapper.getString("MainFrame_Code");
        String symbol_string = guiBundleWrapper.getString("MainFrame_Symbol");
        String industry_string = guiBundleWrapper.getString("MainFrame_Industry");
        String board_string = guiBundleWrapper.getString("MainFrame_Board");
        List<StockInfo> stockInfos2 = stockInfoDatabase.getStockInfos();
        for (StockInfo stockInfo : stockInfos2) {
            Industry industry = (Industry)stockInfo2Industry.get(stockInfo);
            Board board = (Board)stockInfo2Board.get(stockInfo);
            if (industry == null) {
                industry = Industry.Unknown;
            }
            if (board == null) {
                board = Board.Unknown;
            }
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            atoms.add(new Atom(stockInfo.code, code_string));
            atoms.add(new Atom(stockInfo.symbol, symbol_string));
            atoms.add(new Atom(industry.name(), industry_string));
            atoms.add(new Atom(board.name(), board_string));
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        return s;
    }

    public static Statements newInstanceFromStockPrices(Map<Code, Double> stockPrices, long timestamp) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(GUIBundleWrapper.Language.INDEPENDENT);
        Statements s = new Statements(Statement.Type.StockPrice, guiBundleWrapper);
        s.metadatas.put("timestamp", Long.toString(timestamp));
        String code_string = guiBundleWrapper.getString("MainFrame_Code");
        String last_string = guiBundleWrapper.getString("MainFrame_Last");
        for (Map.Entry<Code, Double> stockPrice : stockPrices.entrySet()) {
            Code key = stockPrice.getKey();
            Double value = stockPrice.getValue();
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            atoms.add(new Atom(key.toString(), code_string));
            atoms.add(new Atom(value.toString(), last_string));
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                throw new RuntimeException("" + (Object)((Object)statement.getType()));
            }
            s.statements.add(statement);
        }
        return s;
    }

    public static Statements newInstanceFromTableModel(TableModel tableModel, boolean languageIndependent) {
        CSVHelper csvHelper = (CSVHelper)((Object)tableModel);
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(languageIndependent ? GUIBundleWrapper.Language.INDEPENDENT : GUIBundleWrapper.Language.DEFAULT);
        int column = tableModel.getColumnCount();
        int row = tableModel.getRowCount();
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < column; ++i) {
            String symbol_string;
            String code_string;
            String type = languageIndependent ? csvHelper.getLanguageIndependentColumnName(i) : tableModel.getColumnName(i);
            Class<?> c = tableModel.getColumnClass(i);
            if (c.equals(Stock.class)) {
                code_string = guiBundleWrapper.getString("MainFrame_Code");
                symbol_string = guiBundleWrapper.getString("MainFrame_Symbol");
                strings.add(code_string);
                strings.add(symbol_string);
            }
            if (c.equals(StockInfo.class)) {
                code_string = guiBundleWrapper.getString("MainFrame_Code");
                symbol_string = guiBundleWrapper.getString("MainFrame_Symbol");
                strings.add(code_string);
                strings.add(symbol_string);
                continue;
            }
            strings.add(type);
        }
        CommentableContainer commentableContainer = null;
        if (tableModel instanceof CommentableContainer) {
            commentableContainer = (CommentableContainer)((Object)tableModel);
        }
        Statement.What what = Statement.what(strings);
        Statements s = new Statements(what.type, what.guiBundleWrapper);
        for (int i = 0; i < row; ++i) {
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            for (int j = 0; j < column; ++j) {
                String symbol_string;
                String code_string;
                String type = languageIndependent ? csvHelper.getLanguageIndependentColumnName(j) : tableModel.getColumnName(j);
                Object object = tableModel.getValueAt(i, j);
                Class<?> c = tableModel.getColumnClass(j);
                if (c.equals(Stock.class)) {
                    Stock stock = (Stock)object;
                    code_string = guiBundleWrapper.getString("MainFrame_Code");
                    symbol_string = guiBundleWrapper.getString("MainFrame_Symbol");
                    atoms.add(new Atom(stock.code.toString(), code_string));
                    atoms.add(new Atom(stock.symbol.toString(), symbol_string));
                    continue;
                }
                if (c.equals(StockInfo.class)) {
                    StockInfo stockInfo = (StockInfo)object;
                    code_string = guiBundleWrapper.getString("MainFrame_Code");
                    symbol_string = guiBundleWrapper.getString("MainFrame_Symbol");
                    atoms.add(new Atom(stockInfo.code.toString(), code_string));
                    atoms.add(new Atom(stockInfo.symbol.toString(), symbol_string));
                    continue;
                }
                if (c.equals(Date.class)) {
                    atoms.add(new Atom(object != null ? org.yccheok.jstock.gui.Utils.commonDateFormat(((Date)object).getTime()) : "", type));
                    continue;
                }
                atoms.add(new Atom(object != null ? object : "", type));
            }
            if (commentableContainer != null) {
                atoms.add(new Atom(commentableContainer.getCommentable(i).getComment(), guiBundleWrapper.getString("PortfolioManagementJPanel_Comment")));
            }
            Statement statement = new Statement(atoms);
            if (s.getType() != statement.getType()) {
                return UNKNOWN_STATEMENTS;
            }
            s.statements.add(statement);
        }
        if (tableModel instanceof StockTableModel) {
            s.metadatas.put("timestamp", Long.toString(((StockTableModel)tableModel).getTimestamp()));
        }
        return s;
    }

    public static Statements newInstanceFromSellPortfolioTreeTableModel(SellPortfolioTreeTableModelEx sellPortfolioTreeTableModel, PortfolioRealTimeInfo portfolioRealTimeInfo, boolean languageIndependent) {
        GUIBundleWrapper guiBundleWrapper = GUIBundleWrapper.newInstance(languageIndependent ? GUIBundleWrapper.Language.INDEPENDENT : GUIBundleWrapper.Language.DEFAULT);
        String[] tmp = new String[]{guiBundleWrapper.getString("MainFrame_Code"), guiBundleWrapper.getString("MainFrame_Symbol"), guiBundleWrapper.getString("PortfolioManagementJPanel_ReferenceDate"), guiBundleWrapper.getString("PortfolioManagementJPanel_Date"), guiBundleWrapper.getString("PortfolioManagementJPanel_Units"), guiBundleWrapper.getString("PortfolioManagementJPanel_SellingPrice"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchasePrice"), guiBundleWrapper.getString("PortfolioManagementJPanel_SellingValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseBroker"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseClearingFee"), guiBundleWrapper.getString("PortfolioManagementJPanel_PurchaseStampDuty"), guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPrice"), guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_GainLossPercentage"), guiBundleWrapper.getString("PortfolioManagementJPanel_Broker"), guiBundleWrapper.getString("PortfolioManagementJPanel_ClearingFee"), guiBundleWrapper.getString("PortfolioManagementJPanel_StampDuty"), guiBundleWrapper.getString("PortfolioManagementJPanel_NetSellingValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossValue"), guiBundleWrapper.getString("PortfolioManagementJPanel_NetGainLossPercentage"), guiBundleWrapper.getString("PortfolioManagementJPanel_Comment")};
        Statement.What what = Statement.what(Arrays.asList(tmp));
        Statements statements = new Statements(what.type, what.guiBundleWrapper);
        Portfolio portfolio = (Portfolio)sellPortfolioTreeTableModel.getRoot();
        int summaryCount = portfolio.getChildCount();
        for (int i = 0; i < summaryCount; ++i) {
            TreeTableNode o = portfolio.getChildAt(i);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            String comment = transactionSummary.getComment().trim();
            if (!comment.isEmpty()) {
                StockInfo stockInfo = ((Transaction)transactionSummary.getChildAt(0)).getStockInfo();
                statements.metadatas.put(stockInfo.code.toString(), comment);
            }
            int transactionCount = transactionSummary.getChildCount();
            for (int j = 0; j < transactionCount; ++j) {
                Transaction transaction = (Transaction)transactionSummary.getChildAt(j);
                StockInfo stockInfo = transaction.getStockInfo();
                boolean shouldConvertPenceToPound = org.yccheok.jstock.portfolio.Utils.shouldConvertPenceToPound(portfolioRealTimeInfo, stockInfo.code);
                ArrayList<Atom> atoms = new ArrayList<Atom>();
                atoms.add(new Atom(stockInfo.code.toString(), tmp[0]));
                atoms.add(new Atom(stockInfo.symbol.toString(), tmp[1]));
                String referenceDateString = transaction.getReferenceDate() != null ? org.yccheok.jstock.gui.Utils.commonDateFormat(transaction.getReferenceDate().getTime()) : "";
                atoms.add(new Atom(referenceDateString, tmp[2]));
                String dateString = transaction.getDate() != null ? org.yccheok.jstock.gui.Utils.commonDateFormat(transaction.getDate().getTime()) : "";
                atoms.add(new Atom(dateString, tmp[3]));
                atoms.add(new Atom(transaction.getQuantity(), tmp[4]));
                atoms.add(new Atom(transaction.getPrice(), tmp[5]));
                atoms.add(new Atom(transaction.getReferencePrice(), tmp[6]));
                if (!shouldConvertPenceToPound) {
                    atoms.add(new Atom(transaction.getTotal(), tmp[7]));
                    atoms.add(new Atom(transaction.getReferenceTotal(), tmp[8]));
                } else {
                    atoms.add(new Atom(transaction.getTotal() / 100.0, tmp[7]));
                    atoms.add(new Atom(transaction.getReferenceTotal() / 100.0, tmp[8]));
                }
                atoms.add(new Atom(transaction.getReferenceBroker(), tmp[9]));
                atoms.add(new Atom(transaction.getReferenceClearingFee(), tmp[10]));
                atoms.add(new Atom(transaction.getReferenceStampDuty(), tmp[11]));
                atoms.add(new Atom(sellPortfolioTreeTableModel.getGainLossPrice(transaction), tmp[12]));
                if (!shouldConvertPenceToPound) {
                    atoms.add(new Atom(sellPortfolioTreeTableModel.getGainLossValue(transaction), tmp[13]));
                } else {
                    atoms.add(new Atom(sellPortfolioTreeTableModel.getGainLossValue(transaction) / 100.0, tmp[13]));
                }
                atoms.add(new Atom(sellPortfolioTreeTableModel.getGainLossPercentage(transaction), tmp[14]));
                atoms.add(new Atom(transaction.getBroker(), tmp[15]));
                atoms.add(new Atom(transaction.getClearingFee(), tmp[16]));
                atoms.add(new Atom(transaction.getStampDuty(), tmp[17]));
                if (!shouldConvertPenceToPound) {
                    atoms.add(new Atom(transaction.getNetTotal(), tmp[18]));
                    atoms.add(new Atom(sellPortfolioTreeTableModel.getNetGainLossValue(transaction), tmp[19]));
                } else {
                    atoms.add(new Atom(transaction.getNetTotal() / 100.0, tmp[18]));
                    atoms.add(new Atom(sellPortfolioTreeTableModel.getNetGainLossValue(transaction) / 100.0, tmp[19]));
                }
                atoms.add(new Atom(sellPortfolioTreeTableModel.getNetGainLossPercentage(transaction), tmp[20]));
                atoms.add(new Atom(transaction.getComment(), tmp[21]));
                Statement statement = new Statement(atoms);
                if (statements.getType() != statement.getType()) {
                    return UNKNOWN_STATEMENTS;
                }
                statements.statements.add(statement);
            }
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveAsCSVFile(File file) {
        ThreadSafeFileLock.Lock lock;
        CSVWriter csvwriter;
        OutputStreamWriter outputStreamWriter;
        FileOutputStream fileOutputStream;
        boolean status;
        block18: {
            if (this.type == Statement.Type.Unknown) {
                return false;
            }
            status = false;
            fileOutputStream = null;
            outputStreamWriter = null;
            csvwriter = null;
            lock = ThreadSafeFileLock.getLock(file);
            if (lock == null) {
                return false;
            }
            ThreadSafeFileLock.lockWrite(lock);
            try {
                fileOutputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
                csvwriter = new CSVWriter((Writer)outputStreamWriter);
                for (Map.Entry<String, String> metadata : this.metadatas.entrySet()) {
                    String key = metadata.getKey();
                    String value = metadata.getValue();
                    String output = key + "=" + value;
                    csvwriter.writeNext(new String[]{output});
                }
                List<String> strings = Statement.typeToStrings(this.getType(), this.getGUIBundleWrapper());
                int columnCount = strings.size();
                String[] datas = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    datas[i] = strings.get(i);
                }
                csvwriter.writeNext(datas);
                int rowCount = this.statements.size();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < columnCount; ++j) {
                        String value;
                        datas[j] = value = this.statements.get(i).getAtom(j).getValue().toString();
                    }
                    csvwriter.writeNext(datas);
                }
                status = true;
                if (csvwriter == null) break block18;
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                return status;
            }
            try {
                csvwriter.close();
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        Utils.close(outputStreamWriter);
        Utils.close(fileOutputStream);
        ThreadSafeFileLock.unlockWrite(lock);
        ThreadSafeFileLock.releaseLock(lock);
        return status;
        finally {
            if (csvwriter != null) {
                try {
                    csvwriter.close();
                }
                catch (IOException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            Utils.close(outputStreamWriter);
            Utils.close(fileOutputStream);
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean saveAsExcelFile(File file, String title) {
        int i;
        if (this.type == Statement.Type.Unknown) {
            return false;
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(title);
        List<String> strings = Statement.typeToStrings(this.getType(), this.getGUIBundleWrapper());
        int columnCount = strings.size();
        HSSFRow row = sheet.createRow(0);
        for (i = 0; i < columnCount; ++i) {
            row.createCell(i).setCellValue(new HSSFRichTextString(strings.get(i)));
        }
        int rowCount = this.statements.size();
        for (i = 0; i < rowCount; ++i) {
            HSSFRow row2 = sheet.createRow(i + 1);
            for (int j = 0; j < columnCount; ++j) {
                Object value = this.statements.get(i).getAtom(j).getValue();
                HSSFCell cell = row2.createCell(j);
                POIUtils.invokeSetCellValue(cell, value);
            }
        }
        boolean status = false;
        FileOutputStream fileOut = null;
        ThreadSafeFileLock.Lock lock = ThreadSafeFileLock.getLock(file);
        if (lock == null) {
            return false;
        }
        ThreadSafeFileLock.lockWrite(lock);
        try {
            fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            status = true;
        }
        catch (FileNotFoundException ex) {
            log.error(null, (Throwable)ex);
            Utils.close(fileOut);
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        catch (IOException ex2) {
            log.error(null, (Throwable)ex2);
            {
                catch (Throwable throwable) {
                    Utils.close(fileOut);
                    ThreadSafeFileLock.unlockWrite(lock);
                    ThreadSafeFileLock.releaseLock(lock);
                    throw throwable;
                }
            }
            Utils.close(fileOut);
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        Utils.close(fileOut);
        ThreadSafeFileLock.unlockWrite(lock);
        ThreadSafeFileLock.releaseLock(lock);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean saveAsExcelFile(File file, List<StatementsEx> statementsExs) {
        HSSFWorkbook wb = new HSSFWorkbook();
        boolean needToWrite = false;
        for (StatementsEx statementsEx : statementsExs) {
            int i;
            String title = statementsEx.title;
            Statements statements = statementsEx.statements;
            assert (statements != null);
            if (statements.getType() == Statement.Type.Unknown) continue;
            needToWrite = true;
            HSSFSheet sheet = wb.createSheet(title);
            List<String> strings = Statement.typeToStrings(statements.getType(), statements.getGUIBundleWrapper());
            int columnCount = strings.size();
            HSSFRow row = sheet.createRow(0);
            for (i = 0; i < columnCount; ++i) {
                row.createCell(i).setCellValue(new HSSFRichTextString(strings.get(i)));
            }
            int rowCount = statements.size();
            for (i = 0; i < rowCount; ++i) {
                HSSFRow row2 = sheet.createRow(i + 1);
                for (int j = 0; j < columnCount; ++j) {
                    Object value = statements.get(i).getAtom(j).getValue();
                    HSSFCell cell = row2.createCell(j);
                    POIUtils.invokeSetCellValue(cell, value);
                }
            }
        }
        if (!needToWrite) {
            return needToWrite;
        }
        boolean status = false;
        FileOutputStream fileOut = null;
        ThreadSafeFileLock.Lock lock = ThreadSafeFileLock.getLock(file);
        if (lock == null) {
            return false;
        }
        ThreadSafeFileLock.lockWrite(lock);
        try {
            fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            status = true;
        }
        catch (FileNotFoundException ex) {
            log.error(null, (Throwable)ex);
            Utils.close(fileOut);
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        catch (IOException ex) {
            log.error(null, (Throwable)ex);
            {
                catch (Throwable throwable) {
                    Utils.close(fileOut);
                    ThreadSafeFileLock.unlockWrite(lock);
                    ThreadSafeFileLock.releaseLock(lock);
                    throw throwable;
                }
            }
            Utils.close(fileOut);
            ThreadSafeFileLock.unlockWrite(lock);
            ThreadSafeFileLock.releaseLock(lock);
        }
        Utils.close(fileOut);
        ThreadSafeFileLock.unlockWrite(lock);
        ThreadSafeFileLock.releaseLock(lock);
        return status;
    }

    public Statement.Type getType() {
        return this.type;
    }

    public GUIBundleWrapper getGUIBundleWrapper() {
        return this.guiBundleWrapper;
    }

    public int size() {
        return this.statements.size();
    }

    public Map<String, String> getMetadatas() {
        return Collections.unmodifiableMap(this.metadatas);
    }

    public Statement get(int index) {
        return this.statements.get(index);
    }

    public static class StatementsEx {
        public final Statements statements;
        public final String title;

        public StatementsEx(Statements statements, String title) {
            if (statements == null || title == null) {
                throw new IllegalArgumentException();
            }
            this.statements = statements;
            this.title = title;
        }
    }
}

