/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.AbstractOperator;

public class LogicalOperator
extends AbstractOperator {
    private Logical logical = Logical.And;
    private static final Log log = LogFactory.getLog(LogicalOperator.class);

    @Override
    protected Object calculate() {
        Object object0 = this.inputs[0].getValue();
        Object object1 = this.inputs[1].getValue();
        if (!(object0 instanceof Boolean) || !(object1 instanceof Boolean)) {
            return null;
        }
        boolean b0 = (Boolean)object0;
        boolean b1 = (Boolean)object1;
        switch (this.logical) {
            case And: {
                return b0 && b1;
            }
            case Or: {
                return b0 || b1;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public int getNumOfInputConnector() {
        return 2;
    }

    public Logical getLogical() {
        return this.logical;
    }

    public void setLogical(Logical logical) {
        Logical old = this.logical;
        this.logical = logical;
        if (old != this.logical) {
            this.firePropertyChange("attribute", (Object)old, (Object)this.logical);
        }
    }

    @Override
    public Class getInputClass(int index) {
        return Boolean.class;
    }

    @Override
    public Class getOutputClass(int index) {
        return Boolean.class;
    }

    public static enum Logical {
        And,
        Or;

    }
}

