/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.CheckerMenu;
import com.inet.jortho.CheckerPopup;
import com.inet.jortho.CustomDictionaryProvider;
import com.inet.jortho.CustomUIProvider;
import com.inet.jortho.DefaultMessageHandler;
import com.inet.jortho.Dictionary;
import com.inet.jortho.DictionaryFactory;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.MessageHandler;
import com.inet.jortho.PopupListener;
import com.inet.jortho.SpellCheckerDialog;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SpellChecker {
    private static final ArrayList<LanguageAction> languages = new ArrayList();
    private static Dictionary currentDictionary;
    private static Locale currentLocale;
    private static UserDictionaryProvider userDictionaryProvider;
    private static CustomDictionaryProvider customDictionaryProvider;
    private static final Map<LanguageChangeListener, Object> listeners;
    private static String applicationName;
    private static final SpellCheckerOptions globalOptions;
    private static MessageHandler messageHandler;
    private static CustomUIProvider customUIProvider;
    static final String SELECTED_KEY = "SwingSelectedKey";

    private SpellChecker() {
    }

    public static void setUserDictionaryProvider(UserDictionaryProvider userDictionaryProvider) {
        SpellChecker.userDictionaryProvider = userDictionaryProvider;
    }

    public static UserDictionaryProvider getUserDictionaryProvider() {
        return userDictionaryProvider;
    }

    public static void setCustomDictionaryProvider(CustomDictionaryProvider customDictionaryProvider) {
        SpellChecker.customDictionaryProvider = customDictionaryProvider;
    }

    public static CustomDictionaryProvider getCustomDictionaryProvider() {
        return customDictionaryProvider;
    }

    public static void setMessageHandler(MessageHandler messageHandler) {
        if (messageHandler == null) {
            throw new IllegalArgumentException();
        }
        SpellChecker.messageHandler = messageHandler;
    }

    public static MessageHandler getMessageHandler() {
        return messageHandler;
    }

    public static void setCustomUIProvider(CustomUIProvider customUIProvider) {
        SpellChecker.customUIProvider = customUIProvider;
    }

    public static CustomUIProvider getCustomUIProvider() {
        return customUIProvider;
    }

    public static void registerDictionaries(URL uRL, String string) {
        InputStream inputStream;
        if (uRL == null) {
            try {
                uRL = SpellChecker.class.getResource("/dictionaries.cnf");
                uRL = uRL != null ? new URL(uRL, ".") : new URL("file", null, "");
            }
            catch (MalformedURLException malformedURLException) {
                SpellChecker.getMessageHandler().handleException(malformedURLException);
            }
        }
        try {
            inputStream = new URL(uRL, "dictionaries.cnf").openStream();
        }
        catch (Exception exception) {
            try {
                inputStream = new URL(uRL, "dictionaries.properties").openStream();
            }
            catch (Exception exception2) {
                try {
                    inputStream = new URL(uRL, "dictionaries.txt").openStream();
                }
                catch (Exception exception3) {
                    System.err.println("JOrtho configuration file not found!");
                    SpellChecker.getMessageHandler().handleException(exception);
                    SpellChecker.getMessageHandler().handleException(exception2);
                    SpellChecker.getMessageHandler().handleException(exception3);
                    return;
                }
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            SpellChecker.getMessageHandler().handleException(iOException);
            return;
        }
        String string2 = properties.getProperty("languages");
        String string3 = properties.getProperty("extension", ".ortho");
        SpellChecker.registerDictionaries(uRL, string2, string, string3);
    }

    public static void registerDictionaries(URL uRL, String string, String string2) {
        SpellChecker.registerDictionaries(uRL, string, string2, ".ortho");
    }

    public static void registerDictionaries(URL uRL, String string, String string2, String string3) {
        if (uRL == null) {
            try {
                uRL = new URL("file", null, "");
            }
            catch (MalformedURLException malformedURLException) {
                SpellChecker.getMessageHandler().handleException(malformedURLException);
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((string2 = string2.trim()).length() == 0) {
            string2 = Locale.getDefault().getLanguage();
        }
        boolean bl = false;
        for (String string4 : string.split(",")) {
            if ((string4 = string4.trim().toLowerCase()).length() <= 0) continue;
            LanguageAction languageAction = new LanguageAction(uRL, new Locale(string4), string3);
            languages.remove(languageAction);
            languages.add(languageAction);
            if (!string4.equals(string2)) continue;
            languageAction.actionPerformed(null);
            bl = true;
        }
        if (!bl && languages.size() > 0) {
            LanguageAction languageAction = languages.get(0);
            languageAction.actionPerformed(null);
        }
        Collections.sort(languages);
    }

    public static void register(JTextComponent jTextComponent) throws NullPointerException {
        SpellChecker.register(jTextComponent, true, true, true, true);
    }

    public static void register(JTextComponent jTextComponent, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws NullPointerException {
        if (bl) {
            SpellChecker.enablePopup(jTextComponent, true, bl2);
        }
        if (bl3) {
            SpellChecker.enableShortKey(jTextComponent, true);
        }
        if (bl4) {
            SpellChecker.enableAutoSpell(jTextComponent, true);
        }
    }

    public static void unregister(JTextComponent jTextComponent) {
        SpellChecker.enableShortKey(jTextComponent, false);
        SpellChecker.enablePopup(jTextComponent, false, false);
        SpellChecker.enableAutoSpell(jTextComponent, false);
    }

    public static void enableShortKey(JTextComponent jTextComponent, boolean bl) {
        SpellChecker.enableShortKey(jTextComponent, bl, null);
    }

    public static void enableShortKey(final JTextComponent jTextComponent, boolean bl, final SpellCheckerOptions spellCheckerOptions) {
        if (bl) {
            jTextComponent.getInputMap().put(KeyStroke.getKeyStroke(118, 0), "spell-checking");
            jTextComponent.getActionMap().put("spell-checking", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SpellChecker.showSpellCheckerDialog(jTextComponent, spellCheckerOptions);
                }
            });
        } else {
            jTextComponent.getActionMap().remove("spell-checking");
        }
    }

    public static void showSpellCheckerDialog(JTextComponent jTextComponent, SpellCheckerOptions spellCheckerOptions) {
        if (!jTextComponent.isEditable()) {
            return;
        }
        Dictionary dictionary = currentDictionary;
        if (dictionary != null) {
            Window window = SwingUtilities.getWindowAncestor(jTextComponent);
            SpellCheckerDialog spellCheckerDialog = window instanceof Frame ? new SpellCheckerDialog((Frame)window, true, spellCheckerOptions) : new SpellCheckerDialog((Dialog)window, true, spellCheckerOptions);
            spellCheckerDialog.show(jTextComponent, dictionary, currentLocale);
        }
    }

    public static void enablePopup(JTextComponent jTextComponent, boolean bl, boolean bl2) {
        if (bl) {
            JPopupMenu jPopupMenu;
            if (bl2) {
                jPopupMenu = new JPopupMenu();
                jPopupMenu.add(SpellChecker.createCheckerMenu());
                jPopupMenu.add(SpellChecker.createLanguagesMenu());
            } else {
                jPopupMenu = SpellChecker.createCheckerPopup();
            }
            jTextComponent.addMouseListener(new PopupListener(jPopupMenu));
        } else {
            for (MouseListener mouseListener : jTextComponent.getMouseListeners()) {
                if (!(mouseListener instanceof PopupListener)) continue;
                jTextComponent.removeMouseListener(mouseListener);
            }
        }
    }

    public static void enableAutoSpell(JTextComponent jTextComponent, boolean bl) {
        SpellChecker.enableAutoSpell(jTextComponent, bl, null);
    }

    public static void enableAutoSpell(JTextComponent jTextComponent, boolean bl, SpellCheckerOptions spellCheckerOptions) {
        if (bl) {
            new AutoSpellChecker(jTextComponent, spellCheckerOptions);
        } else {
            AutoSpellChecker.disable(jTextComponent);
        }
    }

    public static void addLanguageChangeLister(LanguageChangeListener languageChangeListener) {
        listeners.put(languageChangeListener, null);
    }

    public static void removeLanguageChangeLister(LanguageChangeListener languageChangeListener) {
        listeners.remove(languageChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(Locale locale) {
        LanguageChangeEvent languageChangeEvent = new LanguageChangeEvent(currentLocale, locale);
        Object[] objectArray = listeners;
        synchronized (listeners) {
            Object[] objectArray2 = listeners.keySet().toArray();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Object object : objectArray2) {
                ((LanguageChangeListener)object).languageChanged(languageChangeEvent);
            }
            return;
        }
    }

    public static JMenu createCheckerMenu() {
        return SpellChecker.createCheckerMenu(null);
    }

    public static JMenu createCheckerMenu(SpellCheckerOptions spellCheckerOptions) {
        return new CheckerMenu(spellCheckerOptions);
    }

    public static JPopupMenu createCheckerPopup() {
        return SpellChecker.createCheckerPopup(null);
    }

    public static JPopupMenu createCheckerPopup(SpellCheckerOptions spellCheckerOptions) {
        return new CheckerPopup(spellCheckerOptions);
    }

    public static JMenu createLanguagesMenu() {
        return SpellChecker.createLanguagesMenu(null);
    }

    public static JMenu createLanguagesMenu(SpellCheckerOptions spellCheckerOptions) {
        JMenu jMenu = new JMenu(Utils.getResource("languages"));
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenu.setEnabled(languages.size() > 0);
        for (LanguageAction languageAction : languages) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(languageAction);
            jRadioButtonMenuItem.setModel(new ActionToggleButtonModel(languageAction));
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        if (spellCheckerOptions == null) {
            spellCheckerOptions = SpellChecker.getOptions();
        }
        if (languages.size() > 0 && spellCheckerOptions.isLanguageDisableVisible()) {
            jMenu.addSeparator();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(DisableLanguageAction.instance);
            jRadioButtonMenuItem.setModel(new ActionToggleButtonModel(DisableLanguageAction.instance));
            jMenu.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    static Dictionary getCurrentDictionary() {
        return currentDictionary;
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static void setCurrentLocale(Locale locale) throws IllegalArgumentException {
        if (locale.equals(currentLocale)) {
            return;
        }
        for (LanguageAction languageAction : languages) {
            if (!languageAction.locale.equals(locale)) continue;
            languageAction.actionPerformed(null);
            return;
        }
        throw new IllegalArgumentException("Not registered locale: " + locale);
    }

    public static boolean isDictionaryLoaded() {
        return currentDictionary != null && currentDictionary.getDataSize() > 1;
    }

    public static void setApplicationName(String string) {
        applicationName = string;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static SpellCheckerOptions getOptions() {
        return globalOptions;
    }

    static {
        listeners = Collections.synchronizedMap(new WeakHashMap());
        globalOptions = new SpellCheckerOptions();
        messageHandler = new DefaultMessageHandler(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LanguageAction
    extends AbtsractLanguageAction
    implements Comparable<LanguageAction> {
        private final URL baseURL;
        private final Locale locale;
        private String extension;

        LanguageAction(URL uRL, Locale locale, String string) {
            super(locale.getDisplayLanguage());
            this.baseURL = uRL;
            this.locale = locale;
            this.extension = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            this.setSelected(true);
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Object object;
                        DictionaryFactory dictionaryFactory = new DictionaryFactory();
                        try {
                            dictionaryFactory.loadWordList(new URL(LanguageAction.this.baseURL, "dictionary_" + LanguageAction.this.locale + LanguageAction.this.extension));
                        }
                        catch (Exception exception) {
                            SpellChecker.getMessageHandler().handleError(exception.toString(), "Error", exception);
                        }
                        try {
                            Iterator<String> iterator;
                            object = userDictionaryProvider;
                            if (object != null && (iterator = object.getWords(LanguageAction.this.locale)) != null) {
                                dictionaryFactory.loadWords(iterator);
                            }
                            if ((object = customDictionaryProvider) != null && (iterator = object.getWords(LanguageAction.this.locale)) != null) {
                                dictionaryFactory.loadWords(iterator);
                            }
                        }
                        catch (Exception exception) {
                            SpellChecker.getMessageHandler().handleError(exception.toString(), "Error", exception);
                        }
                        object = LanguageAction.this.locale;
                        currentDictionary = dictionaryFactory.create();
                        dictionaryFactory = null;
                        currentLocale = LanguageAction.this.locale;
                        SpellChecker.fireLanguageChanged((Locale)object);
                    }
                    finally {
                        LanguageAction.this.setEnabled(true);
                    }
                }
            });
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        }

        public boolean equals(Object object) {
            if (object instanceof LanguageAction) {
                return this.locale.equals(((LanguageAction)object).locale);
            }
            return false;
        }

        public int hashCode() {
            return this.locale.hashCode();
        }

        @Override
        public int compareTo(LanguageAction languageAction) {
            return this.toString().compareTo(languageAction.toString());
        }
    }

    private static class DisableLanguageAction
    extends AbtsractLanguageAction {
        static DisableLanguageAction instance = new DisableLanguageAction();

        private DisableLanguageAction() {
            super(Utils.getResource("disable"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            this.setSelected(true);
            try {
                currentDictionary = null;
                Locale locale = currentLocale;
                currentLocale = null;
                SpellChecker.fireLanguageChanged(locale);
            }
            finally {
                this.setEnabled(true);
            }
        }
    }

    private static abstract class AbtsractLanguageAction
    extends AbstractAction {
        private static AbtsractLanguageAction currentAction;

        public AbtsractLanguageAction(String string) {
            super(string);
        }

        public void setSelected(boolean bl) {
            if (bl) {
                if (currentAction != null && currentAction != this) {
                    currentAction.setSelected(false);
                }
                currentAction = this;
            }
            this.putValue(SpellChecker.SELECTED_KEY, bl);
        }
    }

    private static class ActionToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        private final AbtsractLanguageAction action;

        ActionToggleButtonModel(AbtsractLanguageAction abtsractLanguageAction) {
            this.action = abtsractLanguageAction;
        }

        public boolean isSelected() {
            return Boolean.TRUE.equals(this.action.getValue(SpellChecker.SELECTED_KEY));
        }

        public void setSelected(boolean bl) {
            ButtonGroup buttonGroup = this.getGroup();
            if (buttonGroup != null) {
                buttonGroup.setSelected(this, bl);
                bl = buttonGroup.isSelected(this);
            }
            if (this.isSelected() == bl) {
                return;
            }
            this.action.setSelected(bl);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }
}

