/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.ews.FieldUpdate;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class IndexedFieldUpdate
extends FieldUpdate {
    final Set<FieldUpdate> updates = new HashSet<FieldUpdate>();
    protected final String collectionName;

    public IndexedFieldUpdate(String collectionName) {
        this.collectionName = collectionName;
    }

    public void addFieldValue(FieldUpdate fieldUpdate) {
        this.updates.add(fieldUpdate);
    }

    @Override
    public void write(String itemType, Writer writer) throws IOException {
        if (itemType == null) {
            boolean hasValue = false;
            for (FieldUpdate fieldUpdate : this.updates) {
                if (fieldUpdate.value == null) continue;
                hasValue = true;
                break;
            }
            if (hasValue) {
                writer.write("<t:");
                writer.write(this.collectionName);
                writer.write(">");
                StringBuilder buffer = new StringBuilder();
                for (FieldUpdate fieldUpdate : this.updates) {
                    fieldUpdate.fieldURI.appendValue(buffer, null, fieldUpdate.value);
                }
                writer.write(buffer.toString());
                writer.write("</t:");
                writer.write(this.collectionName);
                writer.write(">");
            }
        } else {
            for (FieldUpdate fieldUpdate : this.updates) {
                fieldUpdate.write(itemType, writer);
            }
        }
    }
}

