/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.favs.Folder;
import net.sourceforge.squirrel_sql.plugins.favs.FolderNode;
import net.sourceforge.squirrel_sql.plugins.favs.QueryTree;

public class NewSavedQueriesFolderCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(NewSavedQueriesFolderCommand.class);
    private IApplication _app;
    private QueryTree _tree;
    private TreePath _path;

    public NewSavedQueriesFolderCommand(IApplication app, QueryTree tree, TreePath path) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (tree == null) {
            throw new IllegalArgumentException("Null QueryTree passed");
        }
        this._app = app;
        this._tree = tree;
        this._path = path;
    }

    public void execute() {
        FolderNode rootNode = (FolderNode)this._tree.getModel().getRoot();
        FolderNode parentNode = null;
        if (this._path == null) {
            parentNode = rootNode;
        } else {
            Object obj = this._path.getLastPathComponent();
            if (obj == null) {
                parentNode = rootNode;
            } else if (obj instanceof FolderNode) {
                parentNode = (FolderNode)obj;
            }
        }
        if (parentNode != null) {
            Folder folder = new Folder(null, s_stringMgr.getString("favs.newFolder"));
            FolderNode newNode = new FolderNode(folder);
            parentNode.getFolder().addSubFolder(folder);
            parentNode.add(newNode);
            this._tree.getTypedModel().nodeStructureChanged(parentNode);
            TreePath newNodePath = null;
            newNodePath = this._path != null ? this._path.pathByAddingChild(newNode) : new TreePath(new FolderNode[]{rootNode, newNode});
            if (newNodePath != null) {
                this._tree.makeVisible(newNodePath);
                this._tree.expandPath(newNodePath);
                this._tree.startEditingAtPath(newNodePath);
            }
        }
    }
}

