/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.PartialGradientLineBorder;
import com.jidesoft.swing.PartialLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TitledSeparator
extends JPanel {
    public static final int TYPE_PARTIAL_ETCHED = 0;
    public static final int TYPE_PARTIAL_LINE = 1;
    public static final int TYPE_PARTIAL_GRADIENT_LINE = 2;
    private int _textAlignment;
    private int _barAlignment;
    private JComponent _labelComponent;
    private Border _border;
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_SEPARATOR_BORDER = "separatorBorder";
    public static final String PROPERTY_BAR_ALIGNMENT = "barAlignment";
    public static final String PROPERTY_TEXT_ALIGNMENT = "textAlignment";

    public TitledSeparator() {
        this("");
    }

    public TitledSeparator(String text) {
        this(text, 0, 2);
    }

    public TitledSeparator(String text, int textAlignment) {
        this((JComponent)new JLabel(text), 0, textAlignment);
    }

    public TitledSeparator(String text, int type, int textAlignment) {
        this((JComponent)new JLabel(text), type, textAlignment);
    }

    public TitledSeparator(JComponent labelComponent, int textAlignment) {
        this(labelComponent, 0, textAlignment);
    }

    public TitledSeparator(JComponent labelComponent, int type, int textAlignment) {
        this(labelComponent, type, textAlignment, 0);
    }

    public TitledSeparator(JComponent labelComponent, Border border, int textAlignment) {
        this(labelComponent, border, textAlignment, 0);
    }

    public TitledSeparator(JComponent labelComponent, int type, int textAlignment, int barAlignment) {
        AbstractBorder border;
        int side = 2;
        int thickness = 1;
        Color color = labelComponent.getBackground();
        if (color == null) {
            color = UIDefaultsLookup.getColor("Label.background");
        }
        switch (type) {
            case 1: {
                Color c = color.darker();
                border = new PartialLineBorder(c, thickness, side);
                break;
            }
            case 2: {
                Color startColor = color.darker();
                Color finishColor = color.brighter();
                Color[] colors = new Color[]{startColor, finishColor};
                border = new PartialGradientLineBorder(colors, thickness, side);
                break;
            }
            default: {
                border = new PartialEtchedBorder(side);
            }
        }
        this._labelComponent = labelComponent;
        this._border = border;
        this._textAlignment = textAlignment;
        this._barAlignment = barAlignment;
        this.validateTitledSeparator();
    }

    public TitledSeparator(JComponent labelComponent, Border border, int textAlignment, int barAlignment) {
        this._labelComponent = labelComponent;
        this._border = border;
        this._textAlignment = textAlignment;
        this._barAlignment = barAlignment;
        this.validateTitledSeparator();
    }

    public void setLabelComponent(JComponent labelComponent) {
        JComponent oldValue = this._labelComponent;
        if (!JideSwingUtilities.equals(oldValue, labelComponent)) {
            this._labelComponent = labelComponent;
            this.firePropertyChange(PROPERTY_LABEL, oldValue, this._labelComponent);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public JComponent getLabelComponent() {
        return this._labelComponent;
    }

    public void setSeparatorBorder(Border border) {
        Border oldValue = this._border;
        if (!JideSwingUtilities.equals(oldValue, border)) {
            this._border = border;
            this.firePropertyChange(PROPERTY_SEPARATOR_BORDER, oldValue, this._border);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public Border getSeparatorBorder() {
        return this._border;
    }

    public void setTextAlignment(int textAlignment) {
        int oldValue = this._textAlignment;
        if (textAlignment != oldValue) {
            this._textAlignment = textAlignment;
            this.firePropertyChange(PROPERTY_TEXT_ALIGNMENT, oldValue, this._textAlignment);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public int getTextAlignment() {
        return this._textAlignment;
    }

    public void setBarAlignment(int barAlignment) {
        int oldValue = this._barAlignment;
        if (barAlignment != oldValue) {
            this._barAlignment = barAlignment;
            this.firePropertyChange(PROPERTY_BAR_ALIGNMENT, oldValue, this._barAlignment);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public int getBarAlignment() {
        return this._barAlignment;
    }

    public void validateTitledSeparator() {
        if (this._labelComponent == null) {
            throw new NullPointerException("Component must not be null.");
        }
        if (this._border == null) {
            throw new NullPointerException("border must not be null.");
        }
        if (this._textAlignment != 2 && this._textAlignment != 4 && this._textAlignment != 0 && this._textAlignment != 10 && this._textAlignment != 11) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            this._textAlignment = ltr ? 2 : 4;
        }
        if (this._textAlignment == 10 || this._textAlignment == 11) {
            boolean LTR = this.getComponentOrientation().isLeftToRight();
            this._textAlignment = LTR ? 2 : 4;
        }
        if (this._barAlignment != 1 && this._barAlignment != 0 && this._barAlignment != 3) {
            this._barAlignment = 0;
        }
        this.removeAll();
        if (this._labelComponent instanceof JLabel) {
            ((JLabel)this._labelComponent).setVerticalAlignment(3);
        }
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        Dimension compDimension = this._labelComponent.getPreferredSize();
        int preferredHeight = compDimension.height;
        int separatorThickness = 2;
        try {
            separatorThickness = this._border.getBorderInsets(null).bottom;
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (this._textAlignment == 2) {
            left = 4;
        } else if (this._textAlignment == 4) {
            right = 4;
        } else if (this._textAlignment == 0) {
            left = 4;
            right = 4;
        }
        if (this._barAlignment == 0) {
            bottom = preferredHeight / 2 - separatorThickness / 2;
        } else if (this._barAlignment == 1) {
            bottom = preferredHeight - separatorThickness;
        } else if (this._barAlignment == 3) {
            bottom = 0;
        }
        EmptyBorder margin = new EmptyBorder(top, left, bottom, right);
        JPanel separator = new JPanel();
        separator.setBorder(new CompoundBorder(margin, this._border));
        this.setLayout(new JideBoxLayout(this, 0));
        this.setOpaque(false);
        if (this._textAlignment == 2) {
            this.add(this._labelComponent);
            this.add((Component)separator, "vary");
        } else if (this._textAlignment == 4) {
            this.add((Component)separator, "vary");
            this.add(this._labelComponent);
        } else {
            JPanel separator2 = new JPanel();
            separator2.setBorder(new CompoundBorder(margin, this._border));
            this.add((Component)separator, "flexible");
            this.add((Component)this._labelComponent, "fix");
            this.add((Component)separator2, "flexible");
        }
    }
}

