/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.decoration;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceDecorationUtilities {
    private static final String DECORATION_AREA_TYPE = "substancelaf.internal.painter.decorationAreaType";

    public static void setDecorationType(JComponent comp, DecorationAreaType type) {
        comp.putClientProperty(DECORATION_AREA_TYPE, (Object)type);
    }

    public static void clearDecorationType(JComponent comp) {
        if (comp != null) {
            comp.putClientProperty(DECORATION_AREA_TYPE, null);
        }
    }

    public static DecorationAreaType getDecorationType(Component comp) {
        DecorationAreaType result = null;
        for (Component c = comp; c != null; c = c.getParent()) {
            JComponent jc;
            Object prop;
            if (!(c instanceof JComponent) || !((prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType)) continue;
            if (prop == DecorationAreaType.NONE) {
                return null;
            }
            return (DecorationAreaType)((Object)prop);
        }
        return result;
    }

    public static DecorationAreaType getImmediateDecorationType(Component comp) {
        JComponent jc;
        Object prop;
        Component c = comp;
        if (c instanceof JComponent && (prop = (jc = (JComponent)c).getClientProperty(DECORATION_AREA_TYPE)) instanceof DecorationAreaType) {
            return (DecorationAreaType)((Object)prop);
        }
        return null;
    }

    public static void paintDecorationBackground(Graphics g, Component c, boolean force) {
        DecorationAreaType decorationType = SubstanceDecorationUtilities.getDecorationType(c);
        SubstanceDecorationUtilities.paintDecorationBackground(g, c, decorationType, force);
    }

    private static void paintDecorationBackground(Graphics g, Component c, DecorationAreaType decorationType, boolean force) {
        boolean isInCellRenderer = c.getParent() instanceof CellRendererPane;
        boolean isPreviewMode = false;
        if (c instanceof JComponent) {
            isPreviewMode = Boolean.TRUE.equals(((JComponent)c).getClientProperty("lafwidgets.internal.previewMode"));
        }
        if (!(force || isPreviewMode || c.isShowing() || isInCellRenderer)) {
            return;
        }
        if (c.getHeight() == 0 || c.getWidth() == 0) {
            return;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        SubstanceDecorationPainter painter = skin.getDecorationPainter();
        Graphics2D g2d = (Graphics2D)g.create();
        painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        SubstanceWatermark watermark = SubstanceCoreUtilities.getSkin(c).getWatermark();
        if (watermark != null && !isPreviewMode && !isInCellRenderer && c.isShowing() && SubstanceCoreUtilities.toDrawWatermark(c)) {
            watermark.drawWatermarkImage(g2d, c, 0, 0, c.getWidth(), c.getHeight());
            g2d.setComposite(TransitionLayout.getAlphaComposite(c, 0.5f, g));
            painter.paintDecorationArea(g2d, c, decorationType, c.getWidth(), c.getHeight(), skin);
        }
        g2d.dispose();
    }
}

