/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.sql.Clob;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ClobDescriptor {
    Clob _clob;
    String _data = null;
    private boolean _clobRead = false;
    private boolean _wholeClobRead = false;
    private int _userSetClobLimit;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ClobDescriptor.class);

    public ClobDescriptor(Clob clob, String data, boolean clobRead, boolean wholeClobRead, int userSetClobLimit) {
        this._clob = clob;
        this._data = data;
        this._clobRead = clobRead;
        this._wholeClobRead = wholeClobRead;
        this._userSetClobLimit = userSetClobLimit;
    }

    public boolean equals(ClobDescriptor c) {
        if (c == null) {
            return this._clobRead && this._data == null;
        }
        if (!c.getClobRead()) {
            return !this._clobRead;
        }
        if (!this._clobRead) {
            return false;
        }
        return c.getData().equals(this._data);
    }

    public String toString() {
        if (this._clobRead) {
            if (this._data == null) {
                return s_stringMgr.getString("ClobDescriptor.null");
            }
            if (this._wholeClobRead || this._userSetClobLimit > this._data.length()) {
                return this._data;
            }
            return this._data + "...";
        }
        return i18n.CLOB_LABEL;
    }

    public Clob getClob() {
        return this._clob;
    }

    public void setClob(Clob clob) {
        this._clob = clob;
    }

    public String getData() {
        return this._data;
    }

    public void setData(String data) {
        this._data = data;
    }

    public boolean getClobRead() {
        return this._clobRead;
    }

    public void setClobRead(boolean clobRead) {
        this._clobRead = clobRead;
    }

    public boolean getWholeClobRead() {
        return this._wholeClobRead;
    }

    public void setWholeClobRead(boolean wholeClobRead) {
        this._wholeClobRead = wholeClobRead;
    }

    public int getUserSetClobLimit() {
        return this._userSetClobLimit;
    }

    public void setUserSetClobLimit(int userSetClobLimit) {
        this._userSetClobLimit = userSetClobLimit;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    public static interface i18n {
        public static final String CLOB_LABEL = ClobDescriptor.access$000().getString("ClobDescriptor.clob");
    }
}

