/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.AliasPropertiesInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.ColorPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.ConnectionPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.SchemaPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;

public class AliasPropertiesController {
    private static HashMap<IIdentifier, AliasPropertiesController> _currentlyOpenInstancesByAliasID = new HashMap();
    private AliasPropertiesInternalFrame _frame;
    private ArrayList<IAliasPropertiesPanelController> _iAliasPropertiesPanelControllers = new ArrayList();
    private IApplication _app;
    private SQLAlias _alias;

    public static void showAliasProperties(IApplication app, SQLAlias selectedAlias) {
        AliasPropertiesController openProps = _currentlyOpenInstancesByAliasID.get(selectedAlias.getIdentifier());
        if (null == openProps) {
            _currentlyOpenInstancesByAliasID.put(selectedAlias.getIdentifier(), new AliasPropertiesController(app, selectedAlias));
        } else {
            openProps._frame.moveToFront();
        }
    }

    private AliasPropertiesController(IApplication app, SQLAlias selectedAlias) {
        this._app = app;
        this._alias = selectedAlias;
        this._frame = new AliasPropertiesInternalFrame(this._alias.getName(), app);
        this._app.getMainFrame().addWidget(this._frame);
        DialogWidget.centerWithinDesktop(this._frame);
        this._frame.setVisible(true);
        this._frame.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AliasPropertiesController.this.onOK();
            }
        });
        this._frame.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AliasPropertiesController.this.onClose();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AliasPropertiesController.this.performClose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._frame.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this._frame.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this._frame.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this._frame.getRootPane().getActionMap().put("CloseAction", closeAction);
        this.loadTabs();
    }

    private void loadTabs() {
        this._iAliasPropertiesPanelControllers.add(new SchemaPropertiesController(this._alias, this._app));
        this._iAliasPropertiesPanelControllers.add(new DriverPropertiesController(this._alias, this._app));
        this._iAliasPropertiesPanelControllers.add(new ColorPropertiesController(this._alias, this._app));
        this._iAliasPropertiesPanelControllers.add(new ConnectionPropertiesController(this._alias, this._app));
        IAliasPropertiesPanelController[] pluginAliasPropertiesPanelControllers = this._app.getPluginManager().getAliasPropertiesPanelControllers(this._alias);
        this._iAliasPropertiesPanelControllers.addAll(Arrays.asList(pluginAliasPropertiesPanelControllers));
        for (int i = 0; i < this._iAliasPropertiesPanelControllers.size(); ++i) {
            IAliasPropertiesPanelController aliasPropertiesController = this._iAliasPropertiesPanelControllers.get(i);
            int index = this._frame.tabPane.getTabCount();
            this._frame.tabPane.add(aliasPropertiesController.getTitle(), aliasPropertiesController.getPanelComponent());
            this._frame.tabPane.setToolTipTextAt(index, aliasPropertiesController.getHint());
        }
    }

    private void performClose() {
        _currentlyOpenInstancesByAliasID.remove(this._alias.getIdentifier());
        this._frame.dispose();
    }

    private void onOK() {
        for (int i = 0; i < this._iAliasPropertiesPanelControllers.size(); ++i) {
            IAliasPropertiesPanelController aliasPropertiesController = this._iAliasPropertiesPanelControllers.get(i);
            aliasPropertiesController.applyChanges();
        }
        this.performClose();
    }

    private void onClose() {
        this.performClose();
    }
}

