/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class Util {
    public static <T extends Annotation> T getClassAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz == null) {
            return null;
        }
        T annot = clazz.getAnnotation(annotationClass);
        if (annot == null) {
            annot = Util.getClassAnnotation(clazz.getSuperclass(), annotationClass);
            if (annot != null) {
                return annot;
            }
            for (Class<?> intf : clazz.getInterfaces()) {
                annot = Util.getClassAnnotation(intf, annotationClass);
                if (annot == null) continue;
                return annot;
            }
        }
        return annot;
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName, boolean allowDuplicates) {
        Cookie cookieToReturn = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                if (cookieToReturn == null) {
                    if (allowDuplicates) {
                        return cookie;
                    }
                    cookieToReturn = cookie;
                    continue;
                }
                throw new IllegalArgumentException("Duplicate cookie! Cookie override attack?");
            }
        }
        return cookieToReturn;
    }

    public static boolean isMethodXsrfProtected(Method method, Class<? extends Annotation> xsrfAnnotation, Class<? extends Annotation> noXsrfAnnotation, Class<?> xsrfTokenInterface) {
        Method[] classMethods;
        Class<?> declaringClass = method.getDeclaringClass();
        if (method.getAnnotation(noXsrfAnnotation) != null || Util.getClassAnnotation(declaringClass, noXsrfAnnotation) != null && method.getAnnotation(xsrfAnnotation) == null) {
            return false;
        }
        if (Util.getClassAnnotation(declaringClass, xsrfAnnotation) != null || method.getAnnotation(xsrfAnnotation) != null) {
            return true;
        }
        for (Method classMethod : classMethods = declaringClass.getMethods()) {
            if (!xsrfTokenInterface.isAssignableFrom(classMethod.getReturnType()) || method.equals(classMethod)) continue;
            return true;
        }
        return false;
    }

    private Util() {
    }
}

