/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp;

import grails.core.GrailsApplication;
import grails.util.CollectionUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.grails.buffer.GrailsPrintWriter;
import org.grails.encoder.Encoder;
import org.grails.exceptions.ExceptionUtils;
import org.grails.gsp.GroovyPageMetaInfo;
import org.grails.gsp.GroovyPagesException;
import org.grails.gsp.jsp.JspTag;
import org.grails.gsp.jsp.JspTagLib;
import org.grails.gsp.jsp.TagLibraryResolver;
import org.grails.taglib.AbstractTemplateVariableBinding;
import org.grails.taglib.GrailsTagException;
import org.grails.taglib.GroovyPageAttributes;
import org.grails.taglib.TagBodyClosure;
import org.grails.taglib.TagLibraryLookup;
import org.grails.taglib.TagOutput;
import org.grails.taglib.encoder.OutputContext;
import org.grails.taglib.encoder.OutputEncodingStack;
import org.grails.taglib.encoder.OutputEncodingStackAttributes;
import org.grails.taglib.encoder.WithCodecHelper;

public abstract class GroovyPage
extends Script {
    private static final String APPLY_CODEC_TAG_NAME = "applyCodec";
    public static final String ENCODE_AS_ATTRIBUTE_NAME = "encodeAs";
    public static final Closure<?> EMPTY_BODY_CLOSURE = TagOutput.EMPTY_BODY_CLOSURE;
    private static final Log LOG = LogFactory.getLog(GroovyPage.class);
    public static final String OUT = "out";
    public static final String EXPRESSION_OUT = "expressionOut";
    public static final String EXPRESSION_OUT_STATEMENT = "expressionOut";
    public static final String OUT_STATEMENT = "out";
    public static final String CODEC_VARNAME = "Codec";
    public static final String PLUGIN_CONTEXT_PATH = "pluginContextPath";
    public static final String EXTENSION = ".gsp";
    public static final String DEFAULT_NAMESPACE = "g";
    public static final String LINK_NAMESPACE = "link";
    public static final String TEMPLATE_NAMESPACE = "tmpl";
    public static final String PAGE_SCOPE = "pageScope";
    public static final Collection<String> RESERVED_NAMES = CollectionUtils.newSet((Object[])new String[]{"out", "expressionOut", "Codec", "pluginContextPath", "pageScope"});
    private static final String BINDING = "binding";
    private static final String BLANK_STRING = "";
    private Map jspTags = Collections.emptyMap();
    private TagLibraryResolver jspTagLibraryResolver;
    private TagLibraryLookup gspTagLibraryLookup;
    private String[] htmlParts;
    private Set<Integer> htmlPartsSet;
    private GrailsPrintWriter out;
    private GrailsPrintWriter staticOut;
    private GrailsPrintWriter expressionOut;
    private OutputEncodingStack outputStack;
    private OutputContext outputContext;
    private String pluginContextPath;
    private Encoder rawEncoder;
    private final List<Closure<?>> bodyClosures = new ArrayList(15);

    public GroovyPage() {
        this.init();
    }

    protected void init() {
    }

    public final Writer getOut() {
        return this.out;
    }

    public final Writer getExpressionOut() {
        return this.expressionOut;
    }

    public void setOut(Writer newWriter) {
        throw new IllegalStateException("Setting out in page isn't allowed.");
    }

    public void initRun(Writer target, OutputContext outputContext, GroovyPageMetaInfo metaInfo) {
        OutputEncodingStackAttributes.Builder attributesBuilder = new OutputEncodingStackAttributes.Builder();
        if (metaInfo != null) {
            this.setJspTags(metaInfo.getJspTags());
            this.setJspTagLibraryResolver(metaInfo.getJspTagLibraryResolver());
            this.setGspTagLibraryLookup(metaInfo.getTagLibraryLookup());
            this.setHtmlParts(metaInfo.getHtmlParts());
            this.setPluginContextPath(metaInfo.getPluginPath());
            attributesBuilder.outEncoder(metaInfo.getOutEncoder());
            attributesBuilder.staticEncoder(metaInfo.getStaticEncoder());
            attributesBuilder.expressionEncoder(metaInfo.getExpressionEncoder());
            attributesBuilder.defaultTaglibEncoder(metaInfo.getTaglibEncoder());
        }
        attributesBuilder.allowCreate(true).topWriter(target).autoSync(false).pushTop(true);
        attributesBuilder.outputContext(outputContext);
        attributesBuilder.inheritPreviousEncoders(false);
        this.outputStack = OutputEncodingStack.currentStack((OutputEncodingStackAttributes)attributesBuilder.build());
        this.out = this.outputStack.getOutWriter();
        this.staticOut = this.outputStack.getStaticWriter();
        this.expressionOut = this.outputStack.getExpressionWriter();
        this.outputContext = outputContext;
        if (outputContext != null) {
            outputContext.setCurrentWriter((Writer)this.out);
            GrailsApplication grailsApplication = outputContext.getGrailsApplication();
            if (grailsApplication != null) {
                this.rawEncoder = WithCodecHelper.lookupEncoder((GrailsApplication)grailsApplication, (String)"Raw");
            }
        }
        this.setVariableDirectly("out", this.out);
        this.setVariableDirectly("expressionOut", this.expressionOut);
    }

    public Object raw(Object value) {
        if (this.rawEncoder == null) {
            return InvokerHelper.invokeMethod((Object)value, (String)"encodeAsRaw", null);
        }
        return this.rawEncoder.encode(value);
    }

    private void setVariableDirectly(String name, Object value) {
        Binding binding = this.getBinding();
        if (binding instanceof AbstractTemplateVariableBinding) {
            ((AbstractTemplateVariableBinding)binding).setVariableDirectly(name, value);
        } else {
            binding.getVariables().put(name, value);
        }
    }

    public String getPluginContextPath() {
        return this.pluginContextPath != null ? this.pluginContextPath : BLANK_STRING;
    }

    public void setPluginContextPath(String pluginContextPath) {
        this.pluginContextPath = pluginContextPath;
    }

    public void cleanup() {
        this.outputStack.pop(true);
    }

    public final void createClosureForHtmlPart(int partNumber, int bodyClosureIndex) {
        String htmlPart = this.htmlParts[partNumber];
        this.setBodyClosure(bodyClosureIndex, (Closure<?>)new TagOutput.ConstantClosure((Object)htmlPart));
    }

    public final void setBodyClosure(int index, Closure<?> bodyClosure) {
        while (index >= this.bodyClosures.size()) {
            this.bodyClosures.add(null);
        }
        this.bodyClosures.set(index, bodyClosure);
    }

    public final Closure<?> getBodyClosure(int index) {
        if (index >= 0) {
            return this.bodyClosures.get(index);
        }
        return null;
    }

    public void setJspTagLibraryResolver(TagLibraryResolver jspTagLibraryResolver) {
        this.jspTagLibraryResolver = jspTagLibraryResolver;
    }

    public void setGspTagLibraryLookup(TagLibraryLookup gspTagLibraryLookup) {
        this.gspTagLibraryLookup = gspTagLibraryLookup;
    }

    TagLibraryResolver getTagLibraryResolver() {
        return this.jspTagLibraryResolver;
    }

    public Object evaluate(String exprText, int lineNumber, Object outerIt, Closure<?> evaluator) {
        try {
            return evaluator.call(outerIt);
        }
        catch (Exception e) {
            throw new GroovyPagesException("Error evaluating expression [" + exprText + "] on line [" + lineNumber + "]: " + e.getMessage(), e, lineNumber, this.getGroovyPageFileName());
        }
    }

    public abstract String getGroovyPageFileName();

    public Object getProperty(String property) {
        if ("out".equals(property)) {
            return this.out;
        }
        if ("expressionOut".equals(property)) {
            return this.expressionOut;
        }
        if (BINDING.equals(property)) {
            return this.getBinding();
        }
        Object value = this.getBinding().getVariable(property);
        if (value != null) {
            return value;
        }
        Object object = value = this.gspTagLibraryLookup != null ? this.gspTagLibraryLookup.lookupNamespaceDispatcher(property) : null;
        if (value == null && this.jspTags.containsKey(property)) {
            TagLibraryResolver tagResolver = this.getTagLibraryResolver();
            String uri = (String)this.jspTags.get(property);
            if (uri != null) {
                value = tagResolver.resolveTagLibrary(uri);
            }
        }
        if (value != null) {
            this.setVariableDirectly(property, value);
        }
        return value;
    }

    public JspTag getJspTag(String uri, String name) {
        if (this.jspTagLibraryResolver == null) {
            return null;
        }
        JspTagLib tagLib = this.jspTagLibraryResolver.resolveTagLibrary(uri);
        return tagLib != null ? tagLib.getTag(name) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void invokeTag(String tagName, String tagNamespace, int lineNumber, Map attrs, int bodyClosureIndex) {
        Closure<?> body = this.getBodyClosure(bodyClosureIndex);
        if (tagNamespace.equals(TEMPLATE_NAMESPACE) || tagNamespace.equals(LINK_NAMESPACE)) {
            String tmpTagName = tagName;
            Map tmpAttrs = attrs;
            Object encodeAs = tmpAttrs.remove(ENCODE_AS_ATTRIBUTE_NAME);
            if (tagNamespace.equals(TEMPLATE_NAMESPACE)) {
                tagName = "render";
                attrs = CollectionUtils.newMap((Object[])new Object[]{"model", tmpAttrs, "template", tmpTagName});
            } else if (tagNamespace.equals(LINK_NAMESPACE)) {
                tagName = LINK_NAMESPACE;
                attrs = CollectionUtils.newMap((Object[])new Object[]{"mapping", tmpTagName});
                if (!tmpAttrs.isEmpty()) {
                    attrs.put("params", tmpAttrs);
                }
            }
            if (encodeAs != null) {
                attrs.put(ENCODE_AS_ATTRIBUTE_NAME, encodeAs);
            }
            tagNamespace = DEFAULT_NAMESPACE;
        }
        try {
            GroovyObject tagLib = this.getTagLib(tagNamespace, tagName);
            if (tagLib != null || this.gspTagLibraryLookup != null && this.gspTagLibraryLookup.hasNamespace(tagNamespace)) {
                if (tagLib == null) throw new GrailsTagException("Tag [" + tagName + "] does not exist. No tag library found for namespace: " + tagNamespace, this.getGroovyPageFileName(), lineNumber);
                boolean returnsObject = this.gspTagLibraryLookup.doesTagReturnObject(tagNamespace, tagName);
                Object tagLibClosure = tagLib.getProperty(tagName);
                if (!(tagLibClosure instanceof Closure)) throw new GrailsTagException("Tag [" + tagName + "] does not exist in tag library [" + tagLib.getClass().getName() + "]", this.getGroovyPageFileName(), lineNumber);
                Map encodeAsForTag = this.gspTagLibraryLookup.getEncodeAsForTag(tagNamespace, tagName);
                this.invokeTagLibClosure(tagName, tagNamespace, (Closure)tagLibClosure, attrs, body, returnsObject, encodeAsForTag);
                return;
            } else {
                this.staticOut.append('<').append((CharSequence)tagNamespace).append(':').append((CharSequence)tagName);
                Iterator i$ = attrs.entrySet().iterator();
                while (i$.hasNext()) {
                    boolean containsSingleQuote;
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    this.staticOut.append(' ');
                    this.staticOut.append(entry.getKey()).append('=');
                    String value = String.valueOf(entry.getValue());
                    boolean containsQuotes = value.indexOf(34) > -1;
                    boolean bl = containsSingleQuote = value.indexOf(39) > -1;
                    if (containsQuotes && !containsSingleQuote) {
                        this.staticOut.append('\'').append((CharSequence)value).append('\'');
                        continue;
                    }
                    if (containsQuotes & containsSingleQuote) {
                        this.staticOut.append('\"').append((CharSequence)value.replaceAll("\"", "&quot;")).append('\"');
                        continue;
                    }
                    this.staticOut.append('\"').append((CharSequence)value).append('\"');
                }
                if (body == null) {
                    this.staticOut.append((CharSequence)"/>");
                    return;
                } else {
                    this.staticOut.append('>');
                    Object bodyOutput = body.call();
                    if (bodyOutput != null) {
                        this.staticOut.print(bodyOutput);
                    }
                    this.staticOut.append((CharSequence)"</").append((CharSequence)tagNamespace).append(':').append((CharSequence)tagName).append('>');
                }
            }
            return;
        }
        catch (Throwable e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Full exception for problem at " + this.getGroovyPageFileName() + ":" + lineNumber), e);
            }
            if (tagName.matches("capture(Body|Head|Meta|Title|Component)")) {
                RuntimeException rte = ExceptionUtils.getFirstRuntimeException((Throwable)e);
                if (rte != null) throw rte;
                this.throwRootCause(tagName, tagNamespace, lineNumber, e);
                return;
            }
            this.throwRootCause(tagName, tagNamespace, lineNumber, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeTagLibClosure(String tagName, String tagNamespace, Closure<?> tagLibClosure, Map<?, ?> attrs, Closure<?> body, boolean returnsObject, Map<String, Object> defaultEncodeAs) {
        Closure tag = (Closure)tagLibClosure.clone();
        if (!(attrs instanceof GroovyPageAttributes)) {
            attrs = new GroovyPageAttributes((Map)attrs);
        }
        attrs.setGspTagSyntaxCall(true);
        boolean encodeAsPushedToStack = false;
        try {
            Map codecSettings = TagOutput.createCodecSettings((String)tagNamespace, (String)tagName, (Map)attrs, defaultEncodeAs);
            if (codecSettings != null) {
                this.outputStack.push(WithCodecHelper.createOutputStackAttributesBuilder((Object)codecSettings, (GrailsApplication)this.outputContext.getGrailsApplication()).build());
                encodeAsPushedToStack = true;
            }
            Object tagresult = null;
            switch (tag.getParameterTypes().length) {
                case 1: {
                    tagresult = tag.call(new Object[]{attrs});
                    this.outputTagResult(returnsObject, tagresult);
                    if (body == null) return;
                    if (body == TagOutput.EMPTY_BODY_CLOSURE) return;
                    body.call();
                    return;
                }
                case 2: {
                    tagresult = tag.call(new Object[]{attrs, body != null ? body : TagOutput.EMPTY_BODY_CLOSURE});
                    this.outputTagResult(returnsObject, tagresult);
                    return;
                }
            }
            return;
        }
        finally {
            if (encodeAsPushedToStack) {
                this.outputStack.pop();
            }
        }
    }

    private void outputTagResult(boolean returnsObject, Object tagresult) {
        if (returnsObject && tagresult != null && !(tagresult instanceof Writer)) {
            if (tagresult instanceof String && this.isHtmlPart((String)tagresult)) {
                this.staticOut.print(tagresult);
            } else {
                this.outputStack.getTaglibWriter().print(tagresult);
            }
        }
    }

    private void throwRootCause(String tagName, String tagNamespace, int lineNumber, Throwable e) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause instanceof GrailsTagException) {
            throw new GrailsTagException(cause.getMessage(), this.getGroovyPageFileName(), lineNumber);
        }
        throw new GrailsTagException("Error executing tag <" + tagNamespace + ":" + tagName + ">: " + e.getMessage(), e, this.getGroovyPageFileName(), lineNumber);
    }

    private GroovyObject getTagLib(String namespace, String tagName) {
        return TagOutput.lookupCachedTagLib((TagLibraryLookup)this.gspTagLibraryLookup, (String)namespace, (String)tagName);
    }

    public static final boolean isReservedName(String name) {
        return RESERVED_NAMES.contains(name);
    }

    public final void printHtmlPart(int partNumber) {
        this.staticOut.write(this.htmlParts[partNumber]);
    }

    public void setJspTags(Map jspTags) {
        this.jspTags = jspTags;
    }

    public String[] getHtmlParts() {
        return this.htmlParts;
    }

    protected boolean isHtmlPart(String htmlPart) {
        return this.htmlPartsSet != null && htmlPart != null && this.htmlPartsSet.contains(System.identityHashCode(htmlPart));
    }

    public void setHtmlParts(String[] htmlParts) {
        this.htmlParts = htmlParts;
        this.htmlPartsSet = new HashSet<Integer>();
        if (htmlParts != null) {
            for (String htmlPart : htmlParts) {
                if (htmlPart == null) continue;
                this.htmlPartsSet.add(System.identityHashCode(htmlPart));
            }
        }
    }

    public final OutputEncodingStack getOutputStack() {
        return this.outputStack;
    }

    public OutputContext getOutputContext() {
        return this.outputContext;
    }

    public final void registerSitemeshPreprocessMode() {
    }

    public final void createTagBody(int bodyClosureIndex, Closure<?> bodyClosure) {
        TagBodyClosure tagBody = new TagBodyClosure((Object)this, this.outputContext, bodyClosure, true);
        this.setBodyClosure(bodyClosureIndex, (Closure<?>)tagBody);
    }

    public void changeItVariable(Object value) {
        this.setVariableDirectly("it", value);
    }
}

