/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ReloadException;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.UnableToLoadClassException;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;
import sl.org.objectweb.asm.Type;
import sl.org.objectweb.asm.tree.AnnotationNode;
import sl.org.objectweb.asm.tree.FieldNode;
import sun.misc.ProxyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils
implements Opcodes,
Constants {
    public static final String[] NO_STRINGS = new String[0];
    private static final String encoding = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final char[] encodingChars = new char[62];
    private static boolean checkedForNewProxyGenerateMethod;
    private static Method newProxyGenerateMethod;

    public static String encode(long number) {
        long n;
        char[] output = new char[32];
        int p = 31;
        for (n = number; n > 61L; n /= 62L) {
            output[p--] = encodingChars[(int)(n % 62L)];
        }
        output[p] = encodingChars[(int)(n % 62L)];
        return new String(output, p, 32 - p);
    }

    public static long decode(String s) {
        long n = 0L;
        int max = s.length();
        for (int i = 0; i < max; ++i) {
            n = n * 62L + (long)encoding.indexOf(s.charAt(i));
        }
        return n;
    }

    public static void addCorrectReturnInstruction(MethodVisitor mv, ReturnType returnType, boolean createCast) {
        if (returnType.isPrimitive()) {
            char ch = returnType.descriptor.charAt(0);
            switch (ch) {
                case 'V': {
                    mv.visitInsn(177);
                    break;
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    mv.visitInsn(172);
                    break;
                }
                case 'F': {
                    mv.visitInsn(174);
                    break;
                }
                case 'D': {
                    mv.visitInsn(175);
                    break;
                }
                case 'J': {
                    mv.visitInsn(173);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not supported for '" + ch + "'");
                }
            }
        } else {
            if (GlobalConfiguration.assertsMode && returnType.descriptor.endsWith(";") && !returnType.descriptor.startsWith("[")) {
                throw new IllegalArgumentException("Invalid signature of '" + returnType.descriptor + "'");
            }
            if (createCast) {
                mv.visitTypeInsn(192, returnType.descriptor);
            }
            mv.visitInsn(176);
        }
    }

    public static int getParameterCount(String methodDescriptor) {
        char ch;
        int pos = 1;
        int count = 0;
        while ((ch = methodDescriptor.charAt(pos)) != ')') {
            if (ch == 'L') {
                pos = methodDescriptor.indexOf(59, pos + 1);
            } else if (ch == '[') {
                while (methodDescriptor.charAt(++pos) == '[') {
                }
                if (methodDescriptor.charAt(pos) == 'L') {
                    pos = methodDescriptor.indexOf(59, pos + 1);
                }
            }
            ++count;
            ++pos;
        }
        return count;
    }

    public static void createLoadsBasedOnDescriptor(MethodVisitor mv, String descriptor, int startindex) {
        char ch;
        int slot = startindex;
        int descriptorpos = 1;
        block8: while ((ch = descriptor.charAt(descriptorpos)) != ')') {
            switch (ch) {
                case '[': {
                    mv.visitVarInsn(25, slot);
                    ++slot;
                    while (descriptor.charAt(++descriptorpos) == '[') {
                    }
                    if (descriptor.charAt(descriptorpos) == 'L') {
                        descriptorpos = descriptor.indexOf(59, descriptorpos) + 1;
                        continue block8;
                    }
                    ++descriptorpos;
                    continue block8;
                }
                case 'L': {
                    mv.visitVarInsn(25, slot);
                    ++slot;
                    descriptorpos = descriptor.indexOf(59, descriptorpos) + 1;
                    continue block8;
                }
                case 'J': {
                    mv.visitVarInsn(22, slot);
                    slot += 2;
                    ++descriptorpos;
                    continue block8;
                }
                case 'D': {
                    mv.visitVarInsn(24, slot);
                    slot += 2;
                    ++descriptorpos;
                    continue block8;
                }
                case 'F': {
                    mv.visitVarInsn(23, slot);
                    ++descriptorpos;
                    ++slot;
                    continue block8;
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    mv.visitVarInsn(21, slot);
                    ++descriptorpos;
                    ++slot;
                    continue block8;
                }
            }
            throw new IllegalStateException("Unexpected type in descriptor: " + ch);
        }
    }

    public static void insertUnboxInsnsIfNecessary(MethodVisitor mv, String type, boolean isObject) {
        if (type.length() != 1) {
            return;
        }
        Utils.insertUnboxInsns(mv, type.charAt(0), isObject);
    }

    public static void insertUnboxInsns(MethodVisitor mv, char ch, boolean isObject) {
        switch (ch) {
            case 'I': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Integer");
                }
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 'Z': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Boolean");
                }
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 'B': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Byte");
                }
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 'C': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Character");
                }
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 'D': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Double");
                }
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            case 'S': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Short");
                }
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 'F': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Float");
                }
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 'J': {
                if (isObject) {
                    mv.visitTypeInsn(192, "java/lang/Long");
                }
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unboxing should not be attempted for descriptor '" + ch + "'");
            }
        }
    }

    public static String getParamSequence(String descriptor) {
        char ch;
        if (descriptor.charAt(1) == ')') {
            return null;
        }
        StringBuilder seq = new StringBuilder();
        int pos = 1;
        while ((ch = descriptor.charAt(pos)) != ')') {
            switch (ch) {
                case 'L': {
                    seq.append("O");
                    pos = descriptor.indexOf(59, pos + 1);
                    break;
                }
                case '[': {
                    seq.append("O");
                    while (descriptor.charAt(++pos) == '[') {
                    }
                    if (descriptor.charAt(pos) != 'L') break;
                    pos = descriptor.indexOf(59, pos + 1);
                    break;
                }
                default: {
                    seq.append(ch);
                }
            }
            ++pos;
        }
        return seq.toString();
    }

    public static void insertBoxInsns(MethodVisitor mv, String type) {
        if (type.length() != 1) {
            return;
        }
        Utils.insertBoxInsns(mv, type.charAt(0));
    }

    public static void insertBoxInsns(MethodVisitor mv, char ch) {
        switch (ch) {
            case 'I': {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 'F': {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 'S': {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 'Z': {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 'J': {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 'D': {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                break;
            }
            case 'C': {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 'B': {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 'L': 
            case '[': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Boxing should not be attempted for descriptor '" + ch + "'");
            }
        }
    }

    public static String getInterfaceName(String owner) {
        return owner + "__I";
    }

    public static void assertSlashed(String name) {
        if (name.indexOf(".") != -1) {
            throw new IllegalStateException("Expected a slashed name but was passed " + name);
        }
    }

    public static void assertDotted(String name) {
        if (name.indexOf("/") != -1) {
            throw new IllegalStateException("Expected a dotted name but was passed " + name);
        }
    }

    public static String toOpcodeString(int opcode) {
        switch (opcode) {
            case 0: {
                return "NOP";
            }
            case 1: {
                return "ACONST_NULL";
            }
            case 2: {
                return "ICONST_M1";
            }
            case 3: {
                return "ICONST_0";
            }
            case 4: {
                return "ICONST_1";
            }
            case 5: {
                return "ICONST_2";
            }
            case 6: {
                return "ICONST_3";
            }
            case 7: {
                return "ICONST_4";
            }
            case 8: {
                return "ICONST_5";
            }
            case 9: {
                return "LCONST_0";
            }
            case 10: {
                return "LCONST_1";
            }
            case 11: {
                return "FCONST_0";
            }
            case 12: {
                return "FCONST_1";
            }
            case 13: {
                return "FCONST_2";
            }
            case 14: {
                return "DCONST_0";
            }
            case 15: {
                return "DCONST_1";
            }
            case 16: {
                return "BIPUSH";
            }
            case 17: {
                return "SIPUSH";
            }
            case 21: {
                return "ILOAD";
            }
            case 22: {
                return "LLOAD";
            }
            case 23: {
                return "FLOAD";
            }
            case 24: {
                return "DLOAD";
            }
            case 25: {
                return "ALOAD";
            }
            case 46: {
                return "IALOAD";
            }
            case 47: {
                return "LALOAD";
            }
            case 48: {
                return "FALOAD";
            }
            case 50: {
                return "AALOAD";
            }
            case 79: {
                return "IASTORE";
            }
            case 83: {
                return "AASTORE";
            }
            case 84: {
                return "BASTORE";
            }
            case 87: {
                return "POP";
            }
            case 88: {
                return "POP2";
            }
            case 89: {
                return "DUP";
            }
            case 90: {
                return "DUP_X1";
            }
            case 91: {
                return "DUP_X2";
            }
            case 92: {
                return "DUP2";
            }
            case 93: {
                return "DUP2_X1";
            }
            case 94: {
                return "DUP2_X2";
            }
            case 95: {
                return "SWAP";
            }
            case 96: {
                return "IADD";
            }
            case 101: {
                return "LSUB";
            }
            case 104: {
                return "IMUL";
            }
            case 105: {
                return "LMUL";
            }
            case 106: {
                return "FMUL";
            }
            case 107: {
                return "DMUL";
            }
            case 122: {
                return "ISHR";
            }
            case 126: {
                return "IAND";
            }
            case 135: {
                return "I2D";
            }
            case 137: {
                return "L2F";
            }
            case 138: {
                return "L2D";
            }
            case 145: {
                return "I2B";
            }
            case 146: {
                return "I2C";
            }
            case 147: {
                return "I2S";
            }
            case 153: {
                return "IFEQ";
            }
            case 154: {
                return "IFNE";
            }
            case 155: {
                return "IFLT";
            }
            case 156: {
                return "IFGE";
            }
            case 157: {
                return "IFGT";
            }
            case 158: {
                return "IFLE";
            }
            case 159: {
                return "IF_ICMPEQ";
            }
            case 160: {
                return "IF_ICMPNE";
            }
            case 161: {
                return "IF_ICMPLT";
            }
            case 162: {
                return "IF_ICMPGE";
            }
            case 163: {
                return "IF_ICMPGT";
            }
            case 164: {
                return "IF_ICMPLE";
            }
            case 165: {
                return "IF_ACMPEQ";
            }
            case 166: {
                return "IF_ACMPNE";
            }
            case 167: {
                return "GOTO";
            }
            case 172: {
                return "IRETURN";
            }
            case 173: {
                return "LRETURN";
            }
            case 174: {
                return "FRETURN";
            }
            case 175: {
                return "DRETURN";
            }
            case 176: {
                return "ARETURN";
            }
            case 177: {
                return "RETURN";
            }
            case 182: {
                return "INVOKEVIRTUAL";
            }
            case 183: {
                return "INVOKESPECIAL";
            }
            case 184: {
                return "INVOKESTATIC";
            }
            case 185: {
                return "INVOKEINTERFACE";
            }
            case 188: {
                return "NEWARRAY";
            }
            case 189: {
                return "ANEWARRAY";
            }
            case 190: {
                return "ARRAYLENGTH";
            }
            case 191: {
                return "ATHROW";
            }
            case 192: {
                return "CHECKCAST";
            }
            case 198: {
                return "IFNULL";
            }
            case 199: {
                return "IFNONNULL";
            }
        }
        throw new IllegalArgumentException("NYI " + opcode);
    }

    public static String toParamDescriptor(Class<?> ... params) {
        if (params == null) {
            return "()";
        }
        StringBuilder s = new StringBuilder("(");
        for (Class<?> param : params) {
            Utils.appendDescriptor(param, s);
        }
        s.append(")");
        return s.toString();
    }

    public static Class<?>[] toParamClasses(String methodDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Type[] paramTypes = Type.getArgumentTypes(methodDescriptor);
        Class[] paramClasses = new Class[paramTypes.length];
        for (int i = 0; i < paramClasses.length; ++i) {
            paramClasses[i] = Utils.toClass(paramTypes[i], classLoader);
        }
        return paramClasses;
    }

    public static Class<?> toClass(Type type, ClassLoader classLoader) throws ClassNotFoundException {
        switch (type.getSort()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 9: {
                Class<?> clazz = Utils.toClass(type.getElementType(), classLoader);
                return Array.newInstance(clazz, 0).getClass();
            }
        }
        return Class.forName(type.getClassName(), false, classLoader);
    }

    public static String toMethodDescriptor(Method method, boolean ignoreFirstParameter) {
        Class<?>[] params = method.getParameterTypes();
        if (ignoreFirstParameter && params.length < 1) {
            throw new IllegalStateException("Cannot ignore the first parameter when there are none.  method=" + method);
        }
        StringBuilder s = new StringBuilder();
        if (!ignoreFirstParameter) {
            s.append("(");
        }
        int max = params.length;
        for (int i = ignoreFirstParameter ? 1 : 0; i < max; ++i) {
            Utils.appendDescriptor(params[i], s);
        }
        s.append(")");
        Utils.appendDescriptor(method.getReturnType(), s);
        return s.toString();
    }

    public static void appendDescriptor(Class<?> p, StringBuilder s) {
        if (p == null) {
            s.append("null");
            return;
        }
        if (p.isArray()) {
            while (p.isArray()) {
                s.append("[");
                p = p.getComponentType();
            }
        }
        if (p.isPrimitive()) {
            if (p == Void.TYPE) {
                s.append('V');
            } else if (p == Integer.TYPE) {
                s.append('I');
            } else if (p == Boolean.TYPE) {
                s.append('Z');
            } else if (p == Character.TYPE) {
                s.append('C');
            } else if (p == Long.TYPE) {
                s.append('J');
            } else if (p == Double.TYPE) {
                s.append('D');
            } else if (p == Float.TYPE) {
                s.append('F');
            } else if (p == Byte.TYPE) {
                s.append('B');
            } else if (p == Short.TYPE) {
                s.append('S');
            }
        } else {
            s.append("L");
            s.append(p.getName().replace('.', '/'));
            s.append(";");
        }
    }

    public static String toPaddedNumber(int value, int width) {
        StringBuilder s = new StringBuilder("00000000").append(Integer.toString(value));
        return s.substring(s.length() - width);
    }

    public static String toMethodDescriptor(Method m) {
        return Utils.toMethodDescriptor(m, false);
    }

    public static byte[] loadDottedClassAsBytes(ClassLoader loader, String dottedclassname) {
        InputStream is;
        if (GlobalConfiguration.assertsMode) {
            if (dottedclassname.endsWith(".class")) {
                throw new IllegalStateException(".class suffixed name should not be passed:" + dottedclassname);
            }
            if (dottedclassname.indexOf(47) != -1) {
                throw new IllegalStateException("Should be a dotted name, no slashes:" + dottedclassname);
            }
        }
        if ((is = loader.getResourceAsStream(dottedclassname.replace('.', '/') + ".class")) == null) {
            throw new UnableToLoadClassException(dottedclassname);
        }
        return Utils.loadBytesFromStream(is);
    }

    public static byte[] loadSlashedClassAsBytes(ClassLoader loader, String slashedclassname) {
        InputStream is;
        if (GlobalConfiguration.assertsMode) {
            if (slashedclassname.endsWith(".class")) {
                throw new IllegalStateException(".class suffixed name should not be passed:" + slashedclassname);
            }
            if (slashedclassname.indexOf(46) != -1) {
                throw new IllegalStateException("Should be a slashed name, no dots:" + slashedclassname);
            }
        }
        if ((is = loader.getResourceAsStream(slashedclassname + ".class")) == null) {
            throw new UnableToLoadClassException(slashedclassname);
        }
        return Utils.loadBytesFromStream(is);
    }

    public static byte[] load(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] data = Utils.loadBytesFromStream(fis);
            fis.close();
            return data;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void write(File file, byte[] data) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(fos);
            dos.write(data);
            dos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static byte[] loadBytesFromStream(InputStream stream) {
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            byte[] theData = new byte[10000000];
            int dataReadSoFar = 0;
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                System.arraycopy(buffer, 0, theData, dataReadSoFar, read);
                dataReadSoFar += read;
            }
            bis.close();
            byte[] returnData = new byte[dataReadSoFar];
            System.arraycopy(theData, 0, returnData, 0, dataReadSoFar);
            return returnData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertTrue(boolean condition, String detail) {
        if (!condition) {
            throw new IllegalStateException("Assertion violated: " + detail);
        }
    }

    public static String getDispatcherName(String name, String versionstamp) {
        StringBuilder s = new StringBuilder(name);
        s.append("$$D");
        s.append(versionstamp);
        return s.toString();
    }

    public static String getExecutorName(String name, String versionstamp) {
        StringBuilder s = new StringBuilder(name);
        s.append("$$E");
        s.append(versionstamp);
        return s.toString();
    }

    public static String stripFirstParameter(String descriptor) {
        if (GlobalConfiguration.assertsMode && descriptor.indexOf(59) == -1) {
            throw new IllegalStateException("Input descriptor must have at least one parameter: " + descriptor);
        }
        StringBuilder r = new StringBuilder();
        r.append('(');
        r.append(descriptor, descriptor.indexOf(59) + 1, descriptor.length());
        return r.toString();
    }

    public static ReturnType getReturnTypeDescriptor(String methodDescriptor) {
        int index = methodDescriptor.indexOf(41) + 1;
        if (methodDescriptor.charAt(index) == 'L') {
            return new ReturnType(methodDescriptor.substring(index + 1, methodDescriptor.length() - 1), ReturnType.Kind.REFERENCE);
        }
        return new ReturnType(methodDescriptor.substring(index), methodDescriptor.charAt(index) == '[' ? ReturnType.Kind.ARRAY : ReturnType.Kind.PRIMITIVE);
    }

    public static String insertExtraParameter(String classname, String descriptor) {
        StringBuilder r = new StringBuilder("(L");
        r.append(classname).append(';');
        r.append(descriptor, 1, descriptor.length());
        return r.toString();
    }

    public static void generateInstructionsToUnpackArrayAccordingToDescriptor(MethodVisitor mv, String toCallDescriptor, int arrayVariableIndex) {
        char ch;
        int arrayIndex = 0;
        int descriptorIndex = 1;
        block5: while ((ch = toCallDescriptor.charAt(descriptorIndex)) != ')') {
            mv.visitVarInsn(25, arrayVariableIndex);
            mv.visitLdcInsn(arrayIndex++);
            mv.visitInsn(50);
            switch (ch) {
                case 'L': {
                    int semicolon = toCallDescriptor.indexOf(59, descriptorIndex + 1);
                    String descriptor = toCallDescriptor.substring(descriptorIndex + 1, semicolon);
                    if (!descriptor.equals("java/lang/Object")) {
                        mv.visitTypeInsn(192, descriptor);
                    }
                    descriptorIndex = semicolon + 1;
                    continue block5;
                }
                case '[': {
                    int idx = descriptorIndex;
                    while (toCallDescriptor.charAt(++descriptorIndex) == '[') {
                    }
                    if (toCallDescriptor.charAt(descriptorIndex) == 'L') {
                        int semicolon2 = toCallDescriptor.indexOf(59, descriptorIndex + 1);
                        descriptorIndex = semicolon2 + 1;
                        mv.visitTypeInsn(192, toCallDescriptor.substring(idx, semicolon2 + 1));
                        continue block5;
                    }
                    mv.visitTypeInsn(192, toCallDescriptor.substring(idx, descriptorIndex + 1));
                    ++descriptorIndex;
                    continue block5;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    Utils.insertUnboxInsns(mv, ch, true);
                    ++descriptorIndex;
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected type descriptor character: " + ch);
        }
    }

    public static boolean isInitializer(String membername) {
        return membername.charAt(0) == '<';
    }

    public static int toCombined(int typeRegistryId, int classId) {
        return (typeRegistryId << 16) + classId;
    }

    public static void logAndThrow(Logger log, String message) {
        if (GlobalConfiguration.logging && log.isLoggable(Level.SEVERE)) {
            log.log(Level.SEVERE, message);
        }
        throw new ReloadException(message);
    }

    public static String dump(String slashname, byte[] bytes) {
        if (GlobalConfiguration.assertsMode && slashname.indexOf(46) != -1) {
            throw new IllegalStateException("Slashed type name expected, not '" + slashname + "'");
        }
        String dir = "";
        if (slashname.indexOf(47) != -1) {
            dir = slashname.substring(0, slashname.lastIndexOf(47));
        }
        String dumplocation = null;
        try {
            File tempfile = null;
            tempfile = GlobalConfiguration.dumpFolder != null ? new File(GlobalConfiguration.dumpFolder) : File.createTempFile("sl_", null);
            tempfile.delete();
            File f = new File(tempfile, dir);
            f.mkdirs();
            dumplocation = tempfile + File.separator + slashname + ".class";
            System.out.println("dump to " + dumplocation);
            f = new File(dumplocation);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bytes);
            fos.flush();
            fos.close();
            return f.toString();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected problem dumping class " + slashname + " into " + dumplocation, ioe);
        }
    }

    public static int sizeOf(String typeDescriptor) {
        if (typeDescriptor.length() != 1) {
            return 1;
        }
        char ch = typeDescriptor.charAt(0);
        if (ch == 'J' || ch == 'D') {
            return 2;
        }
        return 1;
    }

    public static void dumpClass(String file, byte[] bytes) {
        File f = new File(file);
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static String toSuperAccessor(String typename, String name) {
        StringBuilder s = new StringBuilder();
        s.append("__super$");
        int idx = typename.lastIndexOf(47);
        if (idx == -1) {
            s.append(typename);
        } else {
            s.append(typename.substring(idx + 1));
        }
        s.append('$');
        s.append(name);
        return s.toString();
    }

    public static int getSize(String descriptor) {
        char ch;
        int size = 0;
        int descriptorpos = 1;
        block7: while ((ch = descriptor.charAt(descriptorpos)) != ')') {
            switch (ch) {
                case '[': {
                    ++size;
                    while (descriptor.charAt(++descriptorpos) == '[') {
                    }
                    if (descriptor.charAt(descriptorpos) == 'L') {
                        descriptorpos = descriptor.indexOf(59, descriptorpos) + 1;
                        continue block7;
                    }
                    ++descriptorpos;
                    continue block7;
                }
                case 'L': {
                    ++size;
                    descriptorpos = descriptor.indexOf(59, descriptorpos) + 1;
                    continue block7;
                }
                case 'J': {
                    size += 2;
                    ++descriptorpos;
                    continue block7;
                }
                case 'D': {
                    size += 2;
                    ++descriptorpos;
                    continue block7;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++size;
                    ++descriptorpos;
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected character in descriptor: " + ch);
        }
        return size;
    }

    public static Class<?>[] slashedNamesToClasses(String[] slashedNames, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] classes = new Class[slashedNames.length];
        for (int i = 0; i < slashedNames.length; ++i) {
            classes[i] = Utils.slashedNameToClass(slashedNames[i], classLoader);
        }
        return classes;
    }

    public static Class<?> slashedNameToClass(String slashedName, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(slashedName.replace('/', '.'), false, classLoader);
    }

    public static String fieldNodeFormat(FieldNode fieldNode) {
        StringBuilder s = new StringBuilder();
        if (fieldNode.invisibleAnnotations != null) {
            List annotations = fieldNode.invisibleAnnotations;
            for (AnnotationNode annotationNode : annotations) {
                s.append(Utils.annotationNodeFormat(annotationNode));
            }
            annotations = fieldNode.visibleAnnotations;
            for (AnnotationNode annotationNode : annotations) {
                s.append(Utils.annotationNodeFormat(annotationNode));
            }
        }
        s.append(Modifier.toString(fieldNode.access));
        s.append(' ');
        s.append(fieldNode.desc);
        s.append(' ');
        s.append(fieldNode.name);
        if (fieldNode.signature != null) {
            s.append("    ").append(fieldNode.signature);
        }
        return s.toString();
    }

    public static String annotationNodeFormat(AnnotationNode o) {
        StringBuilder s = new StringBuilder();
        s.append(o.desc, 1, o.desc.length() - 1);
        if (o.values != null) {
            s.append("(");
            int max = o.values.size();
            for (int i = 0; i < max; i += 2) {
                if (i > 0) {
                    s.append(",");
                }
                String valueName = (String)o.values.get(i);
                Object valueValue = o.values.get(i + 1);
                s.append(valueName).append("=");
                Utils.formatAnnotationNodeNameValuePairValue(valueValue, s);
            }
            s.append(")");
        }
        return s.toString();
    }

    public static void formatAnnotationNodeNameValuePairValue(Object value, StringBuilder s) {
        if (value instanceof Type) {
            s.append(((Type)value).getDescriptor());
        } else if (value instanceof Array) {
            List<Object> l = Arrays.asList(value);
            s.append(l.get(0)).append(l.get(1));
        } else if (value instanceof List) {
            List l = (List)value;
            s.append("[");
            int max = l.size();
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                Utils.formatAnnotationNodeNameValuePairValue(l.get(i), s);
            }
        } else if (value instanceof AnnotationNode) {
            s.append(Utils.annotationNodeFormat((AnnotationNode)value));
        } else {
            s.append(value);
        }
    }

    public static String fieldNodeFormat(Collection<FieldNode> fieldNodes) {
        StringBuilder s = new StringBuilder();
        int n = 0;
        for (FieldNode fieldNode : fieldNodes) {
            if (n > 0) {
                s.append(" ");
            }
            s.append("'").append(Utils.fieldNodeFormat(fieldNode)).append("'");
            ++n;
        }
        return s.toString();
    }

    public static byte[] loadFromStream(InputStream stream) {
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            int size = 2048;
            byte[] theData = new byte[size];
            int dataReadSoFar = 0;
            byte[] buffer = new byte[size / 2];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                if (read + dataReadSoFar > theData.length) {
                    byte[] newTheData = new byte[theData.length * 2];
                    System.arraycopy(theData, 0, newTheData, 0, dataReadSoFar);
                    theData = newTheData;
                }
                System.arraycopy(buffer, 0, theData, dataReadSoFar, read);
                dataReadSoFar += read;
            }
            bis.close();
            byte[] returnData = new byte[dataReadSoFar];
            System.arraycopy(theData, 0, returnData, 0, dataReadSoFar);
            return returnData;
        }
        catch (IOException e) {
            throw new ReloadException("Unexpectedly unable to load bytedata from input stream", e);
        }
    }

    public static int promoteDefaultOrProtectedToPublic(int access) {
        if ((access & 7) == 0) {
            return access | 1;
        }
        if ((access & 4) != 0) {
            return access - 4 + 1;
        }
        return access;
    }

    public static int promoteDefaultOrProtectedToPublic(int access, boolean isEnum, String name) {
        if ((access & 7) == 0) {
            return access | 1;
        }
        if ((access & 4) != 0) {
            return access - 4 + 1;
        }
        if (isEnum && (access & 2) != 0) {
            return access - 2 + 1;
        }
        if ((access & 0x100A) == 4106 && name.startsWith("lambda")) {
            return access - 2 + 1;
        }
        return access;
    }

    public static int promoteDefaultOrPrivateOrProtectedToPublic(int access) {
        if ((access & 7) == 0) {
            return access | 1;
        }
        if ((access & 4) != 0) {
            return access - 4 + 1;
        }
        return access;
    }

    public static <T> T[] arrayCopyOf(T[] array, int newSize) {
        Object[] newArr = (Object[])Array.newInstance(array.getClass().getComponentType(), newSize);
        System.arraycopy(array, 0, newArr, 0, Math.min(newSize, newArr.length));
        return newArr;
    }

    public static int makePublicNonFinal(int access) {
        access = access & 0xFFFFFFF9 | 1;
        return access &= 0xFFFFFFEF;
    }

    public static Class<?> toClass(ReloadableType rtype) {
        try {
            return Utils.toClass(Type.getObjectType(rtype.getSlashedName()), rtype.typeRegistry.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isObjectIsUnboxableTo(Class<?> possiblyBoxedType, char primitive) {
        switch (primitive) {
            case 'I': {
                return possiblyBoxedType == Integer.class;
            }
            case 'S': {
                return possiblyBoxedType == Short.class;
            }
            case 'J': {
                return possiblyBoxedType == Long.class;
            }
            case 'F': {
                return possiblyBoxedType == Float.class;
            }
            case 'Z': {
                return possiblyBoxedType == Boolean.class;
            }
            case 'C': {
                return possiblyBoxedType == Character.class;
            }
            case 'B': {
                return possiblyBoxedType == Byte.class;
            }
            case 'D': {
                return possiblyBoxedType == Double.class;
            }
        }
        throw new IllegalStateException("nyi " + possiblyBoxedType + " " + primitive);
    }

    public static Object toResultCheckIfNull(Object value, String desc) {
        if (value == null) {
            if (desc.length() == 1) {
                switch (desc.charAt(0)) {
                    case 'I': {
                        return DEFAULT_INT;
                    }
                    case 'B': {
                        return DEFAULT_BYTE;
                    }
                    case 'C': {
                        return DEFAULT_CHAR;
                    }
                    case 'S': {
                        return DEFAULT_SHORT;
                    }
                    case 'J': {
                        return DEFAULT_LONG;
                    }
                    case 'F': {
                        return DEFAULT_FLOAT;
                    }
                    case 'D': {
                        return DEFAULT_DOUBLE;
                    }
                    case 'Z': {
                        return Boolean.FALSE;
                    }
                }
                throw new IllegalStateException("Invalid primitive descriptor " + desc);
            }
            return null;
        }
        return value;
    }

    public static Object checkCompatibility(TypeRegistry registry, Object result, String expectedTypeDescriptor) {
        if (GlobalConfiguration.assertsMode) {
            Utils.assertTrue(result != null, "result should never be null");
        }
        String actualType = result.getClass().getName();
        if (expectedTypeDescriptor.length() != 1 || !Utils.isObjectIsUnboxableTo(result.getClass(), expectedTypeDescriptor.charAt(0))) {
            if (expectedTypeDescriptor.charAt(0) == 'L') {
                expectedTypeDescriptor = expectedTypeDescriptor.substring(1, expectedTypeDescriptor.length() - 1).replace('/', '.');
            }
            if (!expectedTypeDescriptor.equals(actualType)) {
                if (actualType.charAt(0) == '[' || expectedTypeDescriptor.charAt(0) == '[') {
                    return null;
                }
                Class<?> actualClazz = result.getClass();
                if (Utils.isAssignableFrom(registry, actualClazz, expectedTypeDescriptor.replace('/', '.'))) {
                    return result;
                }
                return null;
            }
        }
        return result;
    }

    public static boolean isAssignableFrom(TypeRegistry reg, Class<?> clazz, String lookingFor) {
        Class<?>[] intfaces;
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(lookingFor)) {
            return true;
        }
        for (Class<?> intface : intfaces = clazz.getInterfaces()) {
            if (!Utils.isAssignableFrom(reg, intface, lookingFor)) continue;
            return true;
        }
        return Utils.isAssignableFrom(reg, clazz.getSuperclass(), lookingFor);
    }

    public static boolean isAssignableFrom(String lookingFor, TypeDescriptor candidate) {
        String[] interfaces;
        for (String intface : interfaces = candidate.getSuperinterfacesName()) {
            if (intface.equals(lookingFor)) {
                return true;
            }
            boolean b = Utils.isAssignableFrom(lookingFor, candidate.getTypeRegistry().getDescriptorFor(intface));
            if (!b) continue;
            return true;
        }
        String supertypename = candidate.getSupertypeName();
        if (supertypename == null) {
            return false;
        }
        if (supertypename.equals(lookingFor)) {
            return true;
        }
        return Utils.isAssignableFrom(lookingFor, candidate.getTypeRegistry().getDescriptorFor(supertypename));
    }

    public static int collapseStackToArray(MethodVisitor mv, String desc) {
        String descSequence = Utils.getParamSequence(desc);
        if (descSequence == null) {
            return 0;
        }
        int count = descSequence.length();
        mv.visitLdcInsn(count);
        mv.visitTypeInsn(189, "java/lang/Object");
        block5: for (int dpos = count - 1; dpos >= 0; --dpos) {
            char ch = descSequence.charAt(dpos);
            switch (ch) {
                case 'O': {
                    mv.visitInsn(90);
                    mv.visitInsn(95);
                    mv.visitLdcInsn(dpos);
                    mv.visitInsn(95);
                    mv.visitInsn(83);
                    continue block5;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    mv.visitInsn(90);
                    mv.visitInsn(95);
                    mv.visitLdcInsn(dpos);
                    mv.visitInsn(95);
                    Utils.insertBoxInsns(mv, ch);
                    mv.visitInsn(83);
                    continue block5;
                }
                case 'D': 
                case 'J': {
                    mv.visitInsn(91);
                    mv.visitInsn(91);
                    mv.visitInsn(87);
                    Utils.insertBoxInsns(mv, ch);
                    mv.visitLdcInsn(dpos);
                    mv.visitInsn(95);
                    mv.visitInsn(83);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected character: " + ch + " from " + desc + ":" + dpos);
                }
            }
        }
        return count;
    }

    public static int insertPopsForAllParameters(MethodVisitor mv, String desc) {
        String descSequence = Utils.getParamSequence(desc);
        if (descSequence == null) {
            return 0;
        }
        int count = descSequence.length();
        block4: for (int dpos = count - 1; dpos >= 0; --dpos) {
            char ch = descSequence.charAt(dpos);
            switch (ch) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'O': 
                case 'S': 
                case 'Z': {
                    mv.visitInsn(87);
                    continue block4;
                }
                case 'D': 
                case 'J': {
                    mv.visitInsn(88);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unexpected character: " + ch + " from " + desc + ":" + dpos);
                }
            }
        }
        return count;
    }

    public static String toConstructorDescriptor(Class<?> ... params) {
        return Utils.toParamDescriptor(params) + "V";
    }

    public static boolean isConvertableFrom(Class<?> targetType, Class<?> sourceType) {
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType == Byte.TYPE ? targetType == Short.TYPE || targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE : (sourceType == Short.TYPE ? targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE : (sourceType == Character.TYPE ? targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE : (sourceType == Integer.TYPE ? targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE : (sourceType == Long.TYPE ? targetType == Float.TYPE || targetType == Double.TYPE : sourceType == Float.TYPE && targetType == Double.TYPE))));
    }

    public static String[] discoverInterfaces(byte[] classbytes) {
        ClassReader cr = new ClassReader(classbytes);
        InterfaceCollectingClassVisitor f = new InterfaceCollectingClassVisitor();
        cr.accept(f, 0);
        return f.interfaces;
    }

    public static String getProtectedFieldGetterName(String fieldname) {
        return "r$getProtField_" + fieldname;
    }

    public static String getProtectedFieldSetterName(String fieldname) {
        return "r$setProtField_" + fieldname;
    }

    public static String discoverClassname(byte[] classbytes) {
        ClassReader cr = new ClassReader(classbytes);
        ClassnameDiscoveryVisitor v = new ClassnameDiscoveryVisitor();
        cr.accept(v, 0);
        return v.classname;
    }

    public static byte[] generateProxyClass(String slashedName, Class<?>[] interfacesImplementedByProxy) {
        if (!checkedForNewProxyGenerateMethod) {
            checkedForNewProxyGenerateMethod = true;
            try {
                newProxyGenerateMethod = ProxyGenerator.class.getDeclaredMethod("generateProxyClass", String.class, Class[].class, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (newProxyGenerateMethod != null) {
            try {
                newProxyGenerateMethod.setAccessible(true);
                byte[] bytes = (byte[])newProxyGenerateMethod.invoke(null, slashedName, interfacesImplementedByProxy, 17);
                return bytes;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception calling proxy generator ", e);
            }
        }
        return ProxyGenerator.generateProxyClass((String)slashedName, (Class[])interfacesImplementedByProxy);
    }

    static {
        for (int c = 0; c < 62; ++c) {
            Utils.encodingChars[c] = encoding.charAt(c);
        }
        checkedForNewProxyGenerateMethod = false;
    }

    private static class ClassnameDiscoveryVisitor
    extends ClassVisitor {
        public String classname;

        public ClassnameDiscoveryVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
        }
    }

    private static class InterfaceCollectingClassVisitor
    extends ClassVisitor {
        public String[] interfaces;

        public InterfaceCollectingClassVisitor() {
            super(327680);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.interfaces = interfaces;
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return null;
        }

        public void visitEnd() {
        }
    }

    public static class ReturnType {
        public final String descriptor;
        public final Kind kind;
        public static final ReturnType ReturnTypeVoid = new ReturnType("V", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeFloat = new ReturnType("F", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeBoolean = new ReturnType("Z", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeShort = new ReturnType("S", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeInt = new ReturnType("I", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeChar = new ReturnType("C", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeByte = new ReturnType("B", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeDouble = new ReturnType("D", Kind.PRIMITIVE);
        public static final ReturnType ReturnTypeLong = new ReturnType("J", Kind.PRIMITIVE);

        private ReturnType(String descriptor, Kind kind) {
            this.descriptor = descriptor;
            if (GlobalConfiguration.assertsMode && kind == Kind.REFERENCE && descriptor.endsWith(";") && !descriptor.startsWith("[")) {
                throw new IllegalStateException("Should already have been stripped of 'L' and ';': " + descriptor);
            }
            this.kind = kind;
        }

        public static ReturnType getReturnType(String descriptor, Kind kind) {
            if (kind == Kind.PRIMITIVE) {
                switch (descriptor.charAt(0)) {
                    case 'V': {
                        return ReturnTypeVoid;
                    }
                    case 'F': {
                        return ReturnTypeFloat;
                    }
                    case 'Z': {
                        return ReturnTypeBoolean;
                    }
                    case 'S': {
                        return ReturnTypeShort;
                    }
                    case 'I': {
                        return ReturnTypeInt;
                    }
                    case 'B': {
                        return ReturnTypeByte;
                    }
                    case 'C': {
                        return ReturnTypeChar;
                    }
                    case 'J': {
                        return ReturnTypeLong;
                    }
                    case 'D': {
                        return ReturnTypeDouble;
                    }
                }
                throw new IllegalStateException(descriptor);
            }
            return new ReturnType(descriptor, kind);
        }

        public boolean isVoid() {
            return this.kind == Kind.PRIMITIVE && this.descriptor.charAt(0) == 'V';
        }

        public boolean isPrimitive() {
            return this.kind == Kind.PRIMITIVE;
        }

        public boolean isDoubleSlot() {
            if (this.kind == Kind.PRIMITIVE) {
                char ch = this.descriptor.charAt(0);
                return ch == 'J' || ch == 'L';
            }
            return false;
        }

        public static ReturnType getReturnType(String descriptor) {
            if (descriptor.length() == 1) {
                return ReturnType.getReturnType(descriptor, Kind.PRIMITIVE);
            }
            char ch = descriptor.charAt(0);
            if (ch == 'L') {
                String withoutLeadingLorTrailingSemi = descriptor.substring(1, descriptor.length() - 1);
                return ReturnType.getReturnType(withoutLeadingLorTrailingSemi, Kind.REFERENCE);
            }
            if (GlobalConfiguration.assertsMode) {
                Utils.assertTrue(ch == '[', "Expected array leading char: " + descriptor);
            }
            return ReturnType.getReturnType(descriptor, Kind.ARRAY);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            PRIMITIVE,
            ARRAY,
            REFERENCE;

        }
    }
}

