/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.springframework.boot.cli.compiler.GroovyCompilerScope;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class ExtendedGroovyClassLoader
extends GroovyClassLoader {
    private static final String SHARED_PACKAGE = "org.springframework.boot.groovy";
    private static final URL[] NO_URLS = new URL[0];
    private final Map<String, byte[]> classResources = new HashMap<String, byte[]>();
    private final GroovyCompilerScope scope;
    private final CompilerConfiguration configuration;

    public ExtendedGroovyClassLoader(GroovyCompilerScope scope) {
        this(scope, ExtendedGroovyClassLoader.createParentClassLoader(scope), new CompilerConfiguration());
    }

    private static ClassLoader createParentClassLoader(GroovyCompilerScope scope) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (scope == GroovyCompilerScope.DEFAULT) {
            classLoader = new DefaultScopeParentClassLoader(classLoader);
        }
        return classLoader;
    }

    private ExtendedGroovyClassLoader(GroovyCompilerScope scope, ClassLoader parent, CompilerConfiguration configuration) {
        super(parent, configuration);
        this.configuration = configuration;
        this.scope = scope;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            Class<?> sharedClass;
            if (this.scope == GroovyCompilerScope.DEFAULT && name.startsWith(SHARED_PACKAGE) && (sharedClass = this.findSharedClass(name)) != null) {
                return sharedClass;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?> findSharedClass(String name) {
        Class clazz;
        String path = name.replace('.', '/').concat(".class");
        InputStream inputStream = this.getParent().getResourceAsStream(path);
        if (inputStream == null) return null;
        try {
            clazz = this.defineClass(name, FileCopyUtils.copyToByteArray((InputStream)inputStream));
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        inputStream.close();
        return clazz;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream resourceStream = super.getResourceAsStream(name);
        if (resourceStream == null) {
            byte[] bytes = this.classResources.get(name);
            resourceStream = bytes == null ? null : new ByteArrayInputStream(bytes);
        }
        return resourceStream;
    }

    public GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
        GroovyClassLoader.InnerLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader.InnerLoader>(){

            @Override
            public GroovyClassLoader.InnerLoader run() {
                return new GroovyClassLoader.InnerLoader(ExtendedGroovyClassLoader.this){

                    public URL[] getURLs() {
                        return NO_URLS;
                    }
                };
            }
        });
        return new ExtendedClassCollector(loader, unit, su);
    }

    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    private static class DefaultScopeParentClassLoader
    extends ClassLoader {
        private static final String[] GROOVY_JARS_PREFIXES = new String[]{"groovy", "antlr", "asm"};
        private final URLClassLoader groovyOnlyClassLoader;

        DefaultScopeParentClassLoader(ClassLoader parent) {
            super(parent);
            this.groovyOnlyClassLoader = new URLClassLoader(this.getGroovyJars(parent), null);
        }

        private URL[] getGroovyJars(ClassLoader parent) {
            HashSet<URL> urls = new HashSet<URL>();
            this.findGroovyJarsDirectly(parent, urls);
            if (urls.isEmpty()) {
                this.findGroovyJarsFromClassPath(parent, urls);
            }
            Assert.state((!urls.isEmpty() ? 1 : 0) != 0, (String)"Unable to find groovy JAR");
            return new ArrayList<URL>(urls).toArray(new URL[urls.size()]);
        }

        private void findGroovyJarsDirectly(ClassLoader classLoader, Set<URL> urls) {
            while (classLoader != null) {
                if (classLoader instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                        if (!this.isGroovyJar(url.toString())) continue;
                        urls.add(url);
                    }
                }
                classLoader = classLoader.getParent();
            }
        }

        private void findGroovyJarsFromClassPath(ClassLoader parent, Set<URL> urls) {
            String[] entries;
            String classpath = System.getProperty("java.class.path");
            for (String entry : entries = classpath.split(System.getProperty("path.separator"))) {
                File file;
                if (!this.isGroovyJar(entry) || !(file = new File(entry)).canRead()) continue;
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        private boolean isGroovyJar(String entry) {
            entry = StringUtils.cleanPath((String)entry);
            for (String jarPrefix : GROOVY_JARS_PREFIXES) {
                if (!entry.contains("/" + jarPrefix + "-")) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            this.groovyOnlyClassLoader.loadClass(name);
            return super.loadClass(name, resolve);
        }
    }

    protected class ExtendedClassCollector
    extends GroovyClassLoader.ClassCollector {
        protected ExtendedClassCollector(GroovyClassLoader.InnerLoader loader, CompilationUnit unit, SourceUnit su) {
            super(loader, unit, su);
        }

        protected Class<?> createClass(byte[] code, ClassNode classNode) {
            Class createdClass = super.createClass(code, classNode);
            ExtendedGroovyClassLoader.this.classResources.put(classNode.getName().replace(".", "/") + ".class", code);
            return createdClass;
        }
    }
}

