/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.ReservedFileSystemLocation;
import org.gradle.internal.file.ReservedFileSystemLocationRegistry;

public class DefaultReservedFileSystemLocationRegistry
implements ReservedFileSystemLocationRegistry {
    private final FileHierarchySet reservedFileSystemLocations;

    public DefaultReservedFileSystemLocationRegistry(List<ReservedFileSystemLocation> registeredReservedFileSystemLocations) {
        this.reservedFileSystemLocations = DefaultFileHierarchySet.of((Iterable)Iterables.transform(registeredReservedFileSystemLocations, (Function)new Function<ReservedFileSystemLocation, File>(){

            public File apply(ReservedFileSystemLocation input) {
                return ((FileSystemLocation)input.getReservedFileSystemLocation().get()).getAsFile();
            }
        }));
    }

    @Override
    public boolean isInReservedFileSystemLocation(File location) {
        return this.reservedFileSystemLocations.contains(location);
    }
}

