/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.services.TraceRecorder;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.trace.TraceCachedWriteBytesPcodeExecutorState;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.database.UndoableTransaction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractReadsTargetPcodeExecutorState
extends TraceCachedWriteBytesPcodeExecutorState {
    protected final TraceRecorder recorder;
    protected final PluginTool tool;

    public AbstractReadsTargetPcodeExecutorState(PluginTool tool, Trace trace, long snap, TraceThread thread, int frame, TraceRecorder recorder) {
        super(trace, snap, thread, frame);
        this.tool = tool;
        this.recorder = recorder;
    }

    protected abstract AbstractReadsTargetCachedSpace createCachedSpace(AddressSpace var1, TraceMemorySpace var2);

    protected TraceCachedWriteBytesPcodeExecutorState.CachedSpace getForSpace(AddressSpace space, boolean toWrite) {
        return this.spaces.computeIfAbsent(space, s -> {
            TraceMemorySpace tms;
            if (s.isUniqueSpace()) {
                tms = null;
            } else {
                try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)this.trace, (String)"Create space", (boolean)true);){
                    tms = TraceSleighUtils.getSpaceForExecution((AddressSpace)s, (Trace)this.trace, (TraceThread)this.thread, (int)this.frame, (boolean)true);
                }
            }
            return this.createCachedSpace((AddressSpace)s, tms);
        });
    }

    abstract class AbstractReadsTargetCachedSpace
    extends TraceCachedWriteBytesPcodeExecutorState.CachedSpace {
        public AbstractReadsTargetCachedSpace(Language language, AddressSpace space, TraceMemorySpace source, long snap) {
            super(language, space, source, snap);
        }

        protected abstract void fillUninitialized(AddressSet var1);

        protected boolean isLive() {
            return AbstractReadsTargetPcodeExecutorState.this.recorder != null && AbstractReadsTargetPcodeExecutorState.this.recorder.isRecording() && AbstractReadsTargetPcodeExecutorState.this.recorder.getSnap() == this.snap;
        }

        protected AddressSet computeUnknown(AddressSet uninitialized) {
            return uninitialized.subtract(this.source.getAddressesWithState(this.snap, (AddressSetView)uninitialized, s -> s != null && s != TraceMemoryState.UNKNOWN));
        }

        public byte[] read(long offset, int size) {
            if (this.source != null) {
                AddressSet uninitialized = this.addrSet(this.cache.getUninitialized(offset, offset + (long)size - 1L));
                if (uninitialized.isEmpty()) {
                    return super.read(offset, size);
                }
                this.fillUninitialized(uninitialized);
                AddressSet unknown = this.computeUnknown(this.addrSet(this.cache.getUninitialized(offset, offset + (long)size - 1L)));
                if (!unknown.isEmpty()) {
                    this.warnUnknown(unknown);
                }
            }
            return super.read(offset, size);
        }

        protected <T> T waitTimeout(CompletableFuture<T> future) {
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new AccessPcodeExecutionException("Timed out reading target", e);
            }
        }
    }
}

