/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.iface2;

import SWIG.SBModule;
import agent.lldb.model.iface2.LldbModelTargetObject;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface LldbModelTargetModule
extends LldbModelTargetObject,
TargetModule {
    public SBModule getModule();

    @Override
    default public CompletableFuture<Void> init(Map<String, Object> map) {
        AddressSpace space = this.getModel().getAddressSpace("ram");
        return this.requestNativeAttributes().thenAccept(attrs -> {
            if (attrs != null) {
                Address max;
                map.putAll((Map<String, Object>)attrs);
                TargetObject baseOffset2 = (TargetObject)attrs.get("BaseAddress");
                TargetObject nameAttr = (TargetObject)attrs.get("Name");
                TargetObject size = (TargetObject)attrs.get("Size");
                String basestr = baseOffset2 == null ? "0" : baseOffset2.getCachedAttribute("_value").toString();
                String namestr = nameAttr == null ? "" : nameAttr.getCachedAttribute("_value").toString();
                String sizestr = size == null ? "1" : size.getCachedAttribute("_value").toString();
                String shortnamestr = namestr;
                int sep = shortnamestr.lastIndexOf(92);
                if (sep > 0 && sep < shortnamestr.length()) {
                    shortnamestr = shortnamestr.substring(sep + 1);
                }
                Long base = Long.parseUnsignedLong(basestr, 16);
                Integer sz = Integer.parseInt(sizestr, 16);
                Address min = space.getAddress(base.longValue());
                AddressRangeImpl range = new AddressRangeImpl(min, max = min.add((long)(sz - 1)));
                if (range != null) {
                    map.put("_range", range);
                }
                String oldval = (String)this.getCachedAttribute("_display");
                map.put("_module_name", namestr);
                map.put("_short_display", shortnamestr);
                map.put("_display", shortnamestr);
                this.setModified(map, !shortnamestr.equals(oldval));
            }
        });
    }

    public void setRange(AddressRangeImpl var1);
}

