/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBError;
import SWIG.SBProcess;
import SWIG.SBStream;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.evt.AbstractLldbCompletedCommandEvent;
import agent.lldb.manager.evt.LldbCommandErrorEvent;
import agent.lldb.manager.evt.LldbRunningEvent;
import agent.lldb.manager.impl.LldbManagerImpl;
import ghidra.util.Msg;

public class LldbContinueCommand
extends AbstractLldbCommand<Void> {
    private SBProcess process;

    public LldbContinueCommand(LldbManagerImpl manager, SBProcess process) {
        super(manager);
        this.process = process;
    }

    @Override
    public boolean handle(LldbEvent<?> evt, LldbPendingCommand<?> pending) {
        if (evt instanceof AbstractLldbCompletedCommandEvent && pending.getCommand().equals(this)) {
            pending.claim(evt);
            boolean b = evt instanceof LldbCommandErrorEvent || !pending.findAllOf(LldbRunningEvent.class).isEmpty();
            return b;
        }
        if (evt instanceof LldbRunningEvent) {
            pending.claim(evt);
            boolean b = !pending.findAllOf(AbstractLldbCompletedCommandEvent.class).isEmpty();
            return b;
        }
        return false;
    }

    @Override
    public Void complete(LldbPendingCommand<?> pending) {
        return null;
    }

    @Override
    public void invoke() {
        SBError res = this.process.Continue();
        if (!res.Success()) {
            SBStream stream = new SBStream();
            res.GetDescription(stream);
            Msg.error((Object)this, (Object)stream.GetData());
        }
    }
}

