/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;

public class RemoveAllSecondaryHighlightsAction
extends AbstractDecompilerAction {
    public static final String NAME = "Remove All Secondary Highlights";

    public RemoveAllSecondaryHighlightsAction() {
        super(NAME);
        this.setPopupMenuData(new MenuData(new String[]{"Secondary Highlight", "Remove All Highlights"}, "Decompile"));
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionSecondaryHighlight"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlights highlightedTokens = panel.getSecondaryHighlightedTokens();
        return !highlightedTokens.isEmpty();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel panel = context.getDecompilerPanel();
        panel.removeSecondaryHighlights();
    }
}

