/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import db.DBRecord;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.symbol.AbstractDBTraceVariableSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceLocalVariableSymbol;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceLocalVariableSymbol
extends AbstractDBTraceVariableSymbol
implements TraceLocalVariableSymbol {
    static final String TABLE_NAME = "LocalVars";
    static final String FIRST_USE_COLUMN_NAME = "FirstUse";
    @DBAnnotatedColumn(value="FirstUse")
    static DBObjectColumn FIRST_USE_COLUMN;
    @DBAnnotatedField(column="FirstUse")
    int firstUseOffset;

    public DBTraceLocalVariableSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(manager, store, record);
    }

    protected void set(String name, DBTraceFunctionSymbol function, DataType dt, VariableStorage storage, int firstUseOffset, SourceType source) {
        super.set(name, function, dt, storage, source);
        this.firstUseOffset = firstUseOffset;
        this.update(FIRST_USE_COLUMN);
    }

    public SymbolType getSymbolType() {
        return SymbolType.LOCAL_VAR;
    }

    @Override
    public DBTraceFunctionSymbol getParentNamespace() {
        return (DBTraceFunctionSymbol)super.getParentNamespace();
    }

    @Override
    public DBTraceFunctionSymbol getParentSymbol() {
        return (DBTraceFunctionSymbol)super.getParentSymbol();
    }

    @Override
    public DBTraceFunctionSymbol getFunction() {
        return this.getParentSymbol();
    }

    public boolean setPrimary() {
        return false;
    }

    public boolean isPrimary() {
        return false;
    }

    public boolean setFirstUseOffset(int firstUseOffset) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.firstUseOffset == firstUseOffset) {
                boolean bl = true;
                return bl;
            }
            this.firstUseOffset = firstUseOffset;
            this.update(FIRST_USE_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED, this.getSpace(), this.getFunction()));
        return true;
    }

    public int getFirstUseOffset() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            int n = this.firstUseOffset;
            return n;
        }
    }

    @Override
    protected void doUpdatesAfterSetDataType() {
        super.doUpdatesAfterSetDataType();
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED, this.getSpace(), this.getFunction()));
    }

    @Override
    public boolean delete() {
        if (super.delete()) {
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED, this.getSpace(), this.getFunction()));
            return true;
        }
        return false;
    }
}

