/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.context;

import com.google.common.collect.Range;
import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.context.DBTraceRegisterContextManager;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapAddressSetView;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceSpaceBased;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.context.TraceRegisterContextSpace;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DBTraceRegisterContextSpace
implements TraceRegisterContextSpace,
DBTraceSpaceBased {
    protected static final String TABLE_NAME = "RegisterContext";
    protected final DBTraceRegisterContextManager manager;
    protected final DBHandle dbh;
    protected final AddressSpace space;
    protected final ReadWriteLock lock;
    protected final Language baseLanguage;
    protected final DBTrace trace;
    protected final AddressRange all;
    protected final DBCachedObjectStore<DBTraceRegisterEntry> registerStore;
    protected final Map<Pair<Language, Register>, DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry>> registerValueMaps = new HashMap<Pair<Language, Register>, DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry>>();

    public DBTraceRegisterContextSpace(DBTraceRegisterContextManager manager, DBHandle dbh, AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        this.manager = manager;
        this.dbh = dbh;
        this.space = space;
        this.lock = manager.getLock();
        this.baseLanguage = manager.getBaseLanguage();
        this.trace = manager.getTrace();
        this.all = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
        DBCachedObjectStoreFactory factory = this.trace.getStoreFactory();
        this.registerStore = factory.getOrCreateCachedStore(DBTraceUtils.tableName(TABLE_NAME, space, ent.getThreadKey(), ent.getFrameLevel()), DBTraceRegisterEntry.class, DBTraceRegisterEntry::new, true);
        this.loadRegisterValueMaps();
    }

    protected void loadRegisterValueMaps() throws VersionException {
        for (DBTraceRegisterEntry ent : this.registerStore.asMap().values()) {
            Language language = this.manager.languageManager.getLanguageByKey(ent.langKey);
            Register register = language.getRegister(ent.register);
            ImmutablePair pair = new ImmutablePair((Object)language, (Object)register);
            if (ent.map == null) {
                ent.map = this.createRegisterValueMap((Pair<Language, Register>)pair);
            }
            this.registerValueMaps.put((Pair<Language, Register>)pair, ent.map);
        }
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public DBTraceThread getThread() {
        return null;
    }

    protected long getThreadKey() {
        DBTraceThread thread = this.getThread();
        return thread == null ? -1L : thread.getKey();
    }

    @Override
    public int getFrameLevel() {
        return 0;
    }

    protected String tableName(Language language, Register register) {
        return DBTraceUtils.tableName(TABLE_NAME, this.space, this.getThreadKey(), this.getFrameLevel()) + "_" + language.getLanguageID().getIdAsString() + "_" + register.getName();
    }

    protected DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> createRegisterValueMap(Pair<Language, Register> lr) throws VersionException {
        String name = this.tableName((Language)lr.getLeft(), (Register)lr.getRight());
        try {
            return new DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry>(name, this.trace.getStoreFactory(), this.lock, this.space, DBTraceRegisterContextManager.DBTraceRegisterContextEntry.class, DBTraceRegisterContextManager.DBTraceRegisterContextEntry::new);
        }
        catch (IOException e) {
            this.manager.dbError(e);
            return null;
        }
    }

    protected DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> getRegisterValueMap(Language language, Register register, boolean createIfAbsent) {
        ImmutablePair pair = new ImmutablePair((Object)language, (Object)register);
        int langKey = this.manager.languageManager.getKeyForLanguage(language);
        if (createIfAbsent) {
            return this.registerValueMaps.computeIfAbsent((Pair<Language, Register>)pair, t -> {
                try {
                    DBTraceRegisterEntry ent = (DBTraceRegisterEntry)this.registerStore.create();
                    ent.set(langKey, register);
                    return this.createRegisterValueMap((Pair<Language, Register>)t);
                }
                catch (VersionException e) {
                    throw new AssertionError((Object)e);
                }
            });
        }
        return this.registerValueMaps.get(pair);
    }

    protected Set<TraceAddressSnapRange> doSubtract(TraceAddressSnapRange from, TraceAddressSnapRange remove) {
        HashSet<TraceAddressSnapRange> diff = new HashSet<TraceAddressSnapRange>();
        if (remove.encloses(from)) {
            return diff;
        }
        if (!remove.intersects(from)) {
            diff.add(from);
            return diff;
        }
        TraceAddressSnapRange inter = (TraceAddressSnapRange)from.intersection(remove);
        if (from.getX1().compareTo((Object)inter.getX1()) < 0) {
            diff.add(new ImmutableTraceAddressSnapRange(from.getX1(), inter.getX1().previous(), inter.getLifespan()));
        }
        if (from.getX2().compareTo((Object)inter.getX2()) > 0) {
            diff.add(new ImmutableTraceAddressSnapRange(inter.getX2().next(), from.getX2(), inter.getLifespan()));
        }
        if (from.getY1().compareTo(inter.getY1()) < 0) {
            diff.add(new ImmutableTraceAddressSnapRange(from.getRange(), (Range<Long>)Range.closed((Comparable)from.getY1(), (Comparable)Long.valueOf(inter.getY1() - 1L))));
        }
        if (from.getY2().compareTo(inter.getY2()) > 0) {
            diff.add(new ImmutableTraceAddressSnapRange(from.getRange(), (Range<Long>)Range.closed((Comparable)Long.valueOf(inter.getY2() + 1L), (Comparable)from.getY2())));
        }
        return diff;
    }

    protected void doPut(DBTraceAddressSnapRangePropertyMapSpace<byte[], ?> valueMap, TraceAddressSnapRange range, byte[] bytes) {
        this.doRemove(valueMap, range);
        valueMap.put(range, bytes);
    }

    protected void doRemove(DBTraceAddressSnapRangePropertyMapSpace<byte[], ?> valueMap, TraceAddressSnapRange range) {
        HashMap<TraceAddressSnapRange, byte[]> toPutBack = new HashMap<TraceAddressSnapRange, byte[]>();
        for (Map.Entry entry : valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range)).entries()) {
            for (TraceAddressSnapRange diff : this.doSubtract((TraceAddressSnapRange)entry.getKey(), range)) {
                toPutBack.put(diff, (byte[])entry.getValue());
            }
            valueMap.remove(entry);
        }
        for (Map.Entry entry : toPutBack.entrySet()) {
            valueMap.put((TraceAddressSnapRange)entry.getKey(), (byte[])entry.getValue());
        }
    }

    protected void doSetBaseValue(Language language, RegisterValue baseValue, Range<Long> lifespan, AddressRange range) {
        ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange(range, lifespan);
        Register base = baseValue.getRegister();
        DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap = this.getRegisterValueMap(language, base, true);
        if (baseValue.hasValue()) {
            this.doPut(valueMap, tasr, baseValue.toBytes());
            return;
        }
        if (!baseValue.hasAnyValue()) {
            return;
        }
        HashMap<TraceAddressSnapRange, byte[]> existing = new HashMap<TraceAddressSnapRange, byte[]>();
        for (Map.Entry entry : valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, lifespan)).entries()) {
            existing.put((TraceAddressSnapRange)entry.getKey(), (byte[])entry.getValue());
        }
        this.doPut(valueMap, tasr, baseValue.toBytes());
        for (Map.Entry entry : existing.entrySet()) {
            RegisterValue exists = new RegisterValue(base, (byte[])entry.getValue());
            TraceAddressSnapRange inter = (TraceAddressSnapRange)((TraceAddressSnapRange)entry.getKey()).intersection(tasr);
            this.doPut(valueMap, inter, exists.combineValues(baseValue).toBytes());
        }
    }

    @Override
    public void setValue(Language language, RegisterValue value, Range<Long> lifespan, AddressRange range) {
        this.assertInSpace(range);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.doSetBaseValue(language, value.getBaseRegisterValue(), lifespan, range);
        }
    }

    @Override
    public void removeValue(Language language, Register register, Range<Long> span, AddressRange range) {
        Register base = register.getBaseRegister();
        ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange(range, span);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap = this.getRegisterValueMap(language, base, false);
            if (valueMap == null) {
                return;
            }
            if (register.isBaseRegister()) {
                this.doRemove(valueMap, tasr);
            }
            HashMap<TraceAddressSnapRange, byte[]> existing = new HashMap<TraceAddressSnapRange, byte[]>();
            for (Map.Entry entry : valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).entries()) {
                existing.put((TraceAddressSnapRange)entry.getKey(), (byte[])entry.getValue());
            }
            for (Map.Entry entry : existing.entrySet()) {
                RegisterValue exists = new RegisterValue(base, (byte[])entry.getValue());
                RegisterValue cleared = exists.clearBitValues(register.getBaseMask());
                TraceAddressSnapRange inter = (TraceAddressSnapRange)((TraceAddressSnapRange)entry.getKey()).intersection(tasr);
                if (!cleared.hasAnyValue()) {
                    this.doRemove(valueMap, inter);
                    continue;
                }
                this.doPut(valueMap, inter, cleared.toBytes());
            }
        }
    }

    @Override
    public RegisterValue getDefaultValue(Language language, Register register, Address address) {
        return this.manager.getDefaultContext(language).getDefaultValue(register, address);
    }

    protected RegisterValue doGetBaseValue(Language language, Register base, long snap, Address address) {
        DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap = this.getRegisterValueMap(language, base, false);
        if (valueMap == null) {
            return null;
        }
        byte[] valueBytes = (byte[])valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).firstValue();
        if (valueBytes == null) {
            return null;
        }
        return new RegisterValue(base, valueBytes);
    }

    @Override
    public RegisterValue getValue(Language language, Register register, long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            RegisterValue baseValue = this.doGetBaseValue(language, register.getBaseRegister(), snap, address);
            if (baseValue == null) {
                RegisterValue registerValue = null;
                return registerValue;
            }
            RegisterValue registerValue = baseValue.getRegisterValue(register);
            return registerValue;
        }
    }

    @Override
    public Map.Entry<TraceAddressSnapRange, RegisterValue> getEntry(Language language, Register register, long snap, Address address) {
        Register base = register.getBaseRegister();
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap = this.getRegisterValueMap(language, base, false);
            if (valueMap == null) {
                Map.Entry<TraceAddressSnapRange, RegisterValue> entry = null;
                return entry;
            }
            Map.Entry valueEntry = valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).firstEntry();
            if (valueEntry == null) {
                Map.Entry<TraceAddressSnapRange, RegisterValue> entry = null;
                return entry;
            }
            ImmutablePair immutablePair = new ImmutablePair((Object)((TraceAddressSnapRange)valueEntry.getKey()), (Object)new RegisterValue(base, (byte[])valueEntry.getValue()));
            return immutablePair;
        }
    }

    @Override
    public RegisterValue getValueWithDefault(Language language, Register register, long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Register base = register.getBaseRegister();
            RegisterValue baseValue = this.doGetBaseValue(language, base, snap, address);
            if (baseValue == null) {
                RegisterValue registerValue = this.getDefaultValue(language, register, address);
                return registerValue;
            }
            RegisterValue defaultBaseValue = this.getDefaultValue(language, base, address);
            if (defaultBaseValue == null) {
                RegisterValue registerValue = baseValue.getRegisterValue(register);
                return registerValue;
            }
            RegisterValue registerValue = defaultBaseValue.combineValues(baseValue).getRegisterValue(register);
            return registerValue;
        }
    }

    @Override
    public AddressSetView getRegisterValueAddressRanges(Language language, Register register, long snap, AddressRange within) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Register base = register.getBaseRegister();
            DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap = this.getRegisterValueMap(language, register, false);
            if (valueMap == null) {
                AddressSet addressSet = new AddressSet();
                return addressSet;
            }
            DBTraceAddressSnapRangePropertyMapAddressSetView<byte[]> dBTraceAddressSnapRangePropertyMapAddressSetView = new DBTraceAddressSnapRangePropertyMapAddressSetView<byte[]>(within.getAddressSpace(), this.lock, valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(within, (Range<Long>)Range.closed((Comparable)Long.valueOf(snap), (Comparable)Long.valueOf(snap)))), val -> new RegisterValue(base, val).getRegisterValue(register).hasAnyValue());
            return dBTraceAddressSnapRangePropertyMapAddressSetView;
        }
    }

    @Override
    public AddressSetView getRegisterValueAddressRanges(Language language, Register register, long snap) {
        return this.getRegisterValueAddressRanges(language, register, snap, this.all);
    }

    @Override
    public boolean hasRegisterValueInAddressRange(Language language, Register register, long snap, AddressRange within) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Register base = register.getBaseRegister();
            DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap = this.getRegisterValueMap(language, register, false);
            if (valueMap == null) {
                boolean bl = false;
                return bl;
            }
            for (Map.Entry entry : valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(within, (Range<Long>)Range.closed((Comparable)Long.valueOf(snap), (Comparable)Long.valueOf(snap)))).entries()) {
                RegisterValue baseValue = new RegisterValue(base, (byte[])entry.getValue());
                if (!baseValue.getRegisterValue(register).hasAnyValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean hasRegisterValue(Language language, Register register, long snap) {
        return this.hasRegisterValueInAddressRange(language, register, snap, this.all);
    }

    @Override
    public void clear(Range<Long> span, AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> valueMap : this.registerValueMaps.values()) {
                for (Map.Entry entry : valueMap.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).entries()) {
                    DBTraceRegisterContextManager.DBTraceRegisterContextEntry record = (DBTraceRegisterContextManager.DBTraceRegisterContextEntry)entry.getKey();
                    DBTraceUtils.makeWay(record, span, (e, s) -> e.setLifespan((Range<Long>)s), e -> valueMap.deleteData(record));
                }
            }
        }
    }

    @Override
    public void invalidateCache() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.registerStore.invalidateCache();
            this.loadRegisterValueMaps();
            for (DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> map : this.registerValueMaps.values()) {
                map.invalidateCache();
            }
        }
        catch (VersionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceRegisterEntry
    extends DBAnnotatedObject {
        static final String LANGUAGE_COLUMN_NAME = "Language";
        static final String REGISTER_COLUMN_NAME = "Register";
        @DBAnnotatedColumn(value="Language")
        static DBObjectColumn LANGUAGE_COLUMN;
        @DBAnnotatedColumn(value="Register")
        static DBObjectColumn REGISTER_COLUMN;
        @DBAnnotatedField(column="Language")
        private int langKey;
        @DBAnnotatedField(column="Register")
        private String register;
        private DBTraceAddressSnapRangePropertyMapSpace<byte[], DBTraceRegisterContextManager.DBTraceRegisterContextEntry> map;

        public DBTraceRegisterEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        void set(int langKey, Register register) {
            this.langKey = langKey;
            this.register = register.getName();
            this.update(LANGUAGE_COLUMN, REGISTER_COLUMN);
        }
    }
}

