/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import resources.ResourceManager;

public class MultipleLabelsRenderer
extends AbstractGhidraColumnRenderer<Symbol[]> {
    private static final Icon MULTIPLE_LABELS_ICON = ResourceManager.loadImage((String)"images/application_view_detail.png");
    private static final String SINGLE_NAME_TOOLTIP = "Doesn't have multiple labels.";
    private MultipleLabelsRendererType type;

    public MultipleLabelsRenderer(MultipleLabelsRendererType type) {
        this.type = type;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        JTable table = data.getTable();
        int row = data.getRowViewIndex();
        if (!(value instanceof Symbol[])) {
            throw new AssertException("Incorrect column value for the match's multiple labels indicator column");
        }
        this.configureRendererForMultipleLabelsIndicator(table, row, renderer, (Symbol[])value);
        return renderer;
    }

    private JLabel configureRendererForMultipleLabelsIndicator(JTable table, int row, JLabel renderer, Symbol[] symbols) {
        renderer.setText("");
        renderer.setHorizontalAlignment(0);
        int labelCount = symbols.length;
        if (labelCount > 1) {
            renderer.setIcon(MULTIPLE_LABELS_ICON);
            renderer.setText("" + labelCount);
            String displayString = this.type.getDisplayString();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Has " + labelCount + " " + displayString + " labels. Labels can also be viewed using the dual listing of Markup Items.");
            buffer.append("\n");
            int displayCount = 0;
            for (Symbol symbol : symbols) {
                if (displayCount++ == 20) {
                    buffer.append("\n...");
                    break;
                }
                buffer.append("\n" + symbol.getName());
            }
            String text = buffer.toString();
            String htmlString = HTMLUtilities.toWrappedHTML((String)text);
            renderer.setToolTipText(htmlString);
        } else {
            renderer.setIcon(null);
            renderer.setText("");
            renderer.setToolTipText(SINGLE_NAME_TOOLTIP);
        }
        return renderer;
    }

    private String asString(Symbol[] symbols) {
        int labelCount = symbols.length;
        if (labelCount > 1) {
            String displayString = this.type.getDisplayString();
            StringBuffer buffer = new StringBuffer();
            buffer.append("Has " + labelCount + " " + displayString + " labels. Labels can also be viewed using the dual listing of Markup Items.");
            buffer.append("\n");
            int displayCount = 0;
            for (Symbol symbol : symbols) {
                if (displayCount++ == 20) {
                    buffer.append("\n...");
                    break;
                }
                buffer.append("\n" + symbol.getName());
            }
            String text = buffer.toString();
            return labelCount + " " + text;
        }
        return SINGLE_NAME_TOOLTIP;
    }

    public String getFilterString(Symbol[] t, Settings settings) {
        return this.asString(t);
    }

    public static enum MultipleLabelsRendererType {
        SOURCE("source"),
        DESTINATION("destination");

        public final String displayString;

        private MultipleLabelsRendererType(String displayString) {
            this.displayString = displayString;
        }

        String getDisplayString() {
            return this.displayString;
        }
    }
}

