/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.markuptype;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.markuptype.CommentMarkupType;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.gui.util.VTMatchApplyChoices;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.PlateFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.util.List;

public class PlateCommentMarkupType
extends CommentMarkupType {
    public static final VTMarkupType INSTANCE = new PlateCommentMarkupType();

    private PlateCommentMarkupType() {
        super("Plate Comment");
    }

    @Override
    protected int getCodeUnitCommentType() {
        return 3;
    }

    @Override
    protected ProgramLocation getLocation(VTAssociation association, Address address, boolean isSource) {
        if (address == null || address == Address.NO_ADDRESS) {
            return null;
        }
        Program program = isSource ? this.getSourceProgram(association) : this.getDestinationProgram(association);
        return new PlateFieldLocation(program, address, null, 0, 0, null, -1);
    }

    @Override
    public VTMatchApplyChoices.CommentChoices getCommentChoice(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices commentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        return commentChoice;
    }

    @Override
    public VTMarkupItemApplyActionType getApplyAction(ToolOptions options) {
        VTMatchApplyChoices.CommentChoices commentChoice = (VTMatchApplyChoices.CommentChoices)options.getEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
        switch (commentChoice) {
            case APPEND_TO_EXISTING: {
                return VTMarkupItemApplyActionType.ADD;
            }
            case OVERWRITE_EXISTING: {
                return VTMarkupItemApplyActionType.REPLACE;
            }
        }
        return null;
    }

    @Override
    public Address validateDestinationAddress(VTAssociation association, Address sourceAddress, Address suggestedDestinationAddress) {
        if (sourceAddress.equals((Object)association.getSourceAddress())) {
            return association.getDestinationAddress();
        }
        return suggestedDestinationAddress;
    }

    @Override
    public Options convertOptionsToForceApplyOfMarkupItem(VTMarkupItemApplyActionType applyAction, ToolOptions applyOptions) {
        ToolOptions options = applyOptions.copy();
        switch (applyAction) {
            case ADD: {
                options.setEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.APPEND_TO_EXISTING);
                break;
            }
            case ADD_AS_PRIMARY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform an Add As Primary action.");
            }
            case REPLACE_DEFAULT_ONLY: {
                throw new IllegalArgumentException(this.getDisplayName() + " markup items cannot perform a Replace Default Only action.");
            }
            case REPLACE: {
                options.setEnum("Apply Markup Options.Plate Comment", (Enum)VTMatchApplyChoices.CommentChoices.OVERWRITE_EXISTING);
            }
        }
        return options;
    }

    @Override
    public List<VTMarkupItem> createMarkupItems(VTAssociation association) {
        List<VTMarkupItem> markupItems = super.createMarkupItems(association);
        for (VTMarkupItem vtMarkupItem : markupItems) {
            if (!vtMarkupItem.getSourceAddress().equals((Object)association.getSourceAddress())) continue;
            vtMarkupItem.setDefaultDestinationAddress(association.getDestinationAddress(), "Function");
        }
        return markupItems;
    }
}

