/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.datastruct.PropertySetIndexRangeIterator;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.ShortPropertySet;
import java.io.Serializable;

public class ShortRangeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long LARGEST = -1L;
    ShortPropertySet map = new ShortPropertySet("RangeMap");

    public ShortRangeMap() {
        this.map.putShort(0L, (short)0);
    }

    public void paintRange(long start, long end, short value) {
        if (end != -1L) {
            short origEndValue = this.getValue(end + 1L);
            if (origEndValue != value) {
                this.map.putShort(end + 1L, origEndValue);
            } else {
                this.map.remove(end + 1L);
            }
        }
        LongIterator it = this.map.getPropertyIterator(start);
        while (it.hasNext()) {
            long next = it.next();
            if (next > end) continue;
            this.map.remove(next);
        }
        if (start == 0L) {
            this.map.putShort(0L, value);
        } else {
            short startValue = this.getValue(start);
            if (startValue != value) {
                this.map.putShort(start, value);
            }
        }
    }

    public short getValue(long index) {
        try {
            return this.map.getShort(index);
        }
        catch (NoValueException e) {
            try {
                index = this.map.getPreviousPropertyIndex(index);
                return this.map.getShort(index);
            }
            catch (NoSuchIndexException noSuchIndexException) {
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            return 0;
        }
    }

    public IndexRangeIterator getIndexRangeIterator(long index) {
        return new PropertySetIndexRangeIterator(this.map, index);
    }

    public LongIterator getChangePointIterator(long start, long end) {
        return this.map.getPropertyIterator(start, end);
    }
}

