/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedOption;
import ghidra.util.Msg;

public class WrappedCustomOption
implements WrappedOption {
    private CustomOption value;

    public WrappedCustomOption(CustomOption value) {
        this.value = value;
    }

    public WrappedCustomOption() {
    }

    @Override
    public void readState(SaveState saveState) {
        String customOptionClassName = saveState.getString("CUSTOM OPTION CLASS", null);
        try {
            Class<?> c = Class.forName(customOptionClassName);
            this.value = (CustomOption)c.newInstance();
            this.value.readState(saveState);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Can't create customOption instance for: " + customOptionClassName), (Throwable)e);
        }
    }

    @Override
    public void writeState(SaveState saveState) {
        saveState.putString("CUSTOM OPTION CLASS", this.value.getClass().getName());
        this.value.writeState(saveState);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.CUSTOM_TYPE;
    }
}

