/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import org.xml.sax.SAXParseException;

class BookmarksXmlMgr {
    private BookmarkManager bookmarkMgr;
    private AddressFactory factory;
    private MessageLog log;

    BookmarksXmlMgr(Program program, MessageLog log) {
        this.bookmarkMgr = program.getBookmarkManager();
        this.factory = program.getAddressFactory();
        this.log = log;
    }

    void read(XmlPullParser parser, boolean overwrite, TaskMonitor monitor) throws SAXParseException, AddressFormatException, CancelledException {
        XmlElement element = parser.next();
        if (!element.isStart() || !element.getName().equals("BOOKMARKS")) {
            throw new SAXParseException("Expected BOOKMARKS start tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
        element = parser.next();
        while (element.getName().equals("BOOKMARK")) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.processBookmark(element, parser, overwrite);
            element = parser.next();
        }
        if (element.isStart() || !element.getName().equals("BOOKMARKS")) {
            throw new SAXParseException("Expected BOOKMARK element or BOOKMARKS end tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    private void processBookmark(XmlElement element, XmlPullParser parser, boolean overwrite) throws SAXParseException, AddressFormatException {
        String comment;
        String category;
        String addrStr = element.getAttribute("ADDRESS");
        if (addrStr == null) {
            throw new SAXParseException("ADDRESS attribute missing for BOOKMARK element", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
        Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
        if (addr == null) {
            throw new AddressFormatException("Incompatible Bookmark Address: " + addrStr);
        }
        String type = element.getAttribute("TYPE");
        if (type == null) {
            type = "Note";
        }
        if ((category = element.getAttribute("CATEGORY")) == null) {
            category = "";
        }
        if ((comment = element.getAttribute("DESCRIPTION")) == null) {
            comment = "";
        }
        try {
            boolean hasExistingBookmark;
            boolean bl = hasExistingBookmark = this.bookmarkMgr.getBookmark(addr, type, category) != null;
            if (overwrite || !hasExistingBookmark) {
                this.bookmarkMgr.setBookmark(addr, type, category, comment);
            }
            if (!overwrite && hasExistingBookmark) {
                this.log.appendMsg("Conflicting '" + type + "' BOOKMARK ignored at: " + addr);
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            parser.discardSubTree(element);
            return;
        }
        element = parser.next();
        if (element.isStart() || !element.getName().equals("BOOKMARK")) {
            throw new SAXParseException("Expected BOOKMARK end tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing BOOKMARKS ...");
        writer.startElement("BOOKMARKS");
        this.writeBookmarks(writer, set, monitor);
        writer.endElement("BOOKMARKS");
    }

    private void writeBookmarks(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        BookmarkType[] types = this.bookmarkMgr.getBookmarkTypes();
        for (int i = 0; i < types.length; ++i) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            String typeStr = types[i].getTypeString();
            AddressSetView bmSet = this.bookmarkMgr.getBookmarkAddresses(typeStr);
            if (set != null) {
                bmSet = set.intersect(bmSet);
            }
            AddressIterator iter = bmSet.getAddresses(true);
            while (iter.hasNext()) {
                Address addr = iter.next();
                Bookmark[] bookmarks = this.bookmarkMgr.getBookmarks(addr, typeStr);
                for (int n = 0; n < bookmarks.length; ++n) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    XmlAttributes attrs = new XmlAttributes();
                    attrs.addAttribute("ADDRESS", XmlProgramUtilities.toString((Address)addr));
                    attrs.addAttribute("TYPE", typeStr);
                    String category = bookmarks[n].getCategory();
                    String comment = bookmarks[n].getComment();
                    if (category != null && category.length() != 0) {
                        attrs.addAttribute("CATEGORY", category);
                    }
                    if (comment != null && comment.length() != 0) {
                        attrs.addAttribute("DESCRIPTION", comment);
                    }
                    writer.startElement("BOOKMARK", attrs);
                    writer.endElement("BOOKMARK");
                }
            }
        }
    }
}

