/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.multilisting;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.MultiRowLayout;
import docking.widgets.fieldpanel.support.RowLayout;
import ghidra.app.util.viewer.field.DummyFieldFactory;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.proxy.EmptyProxy;

class MultiLayout {
    private Layout[] layouts;

    public MultiLayout() {
    }

    public MultiLayout(Layout[] layouts, FormatManager formatMgr, DummyFieldFactory factory) {
        MultiRowLayout layout;
        int i;
        this.layouts = layouts;
        int[] rowHeights = new int[formatMgr.getMaxNumRows()];
        int id = this.getDefaultID(layouts);
        for (i = 0; i < layouts.length; ++i) {
            layout = (MultiRowLayout)layouts[i];
            if (layout == null) {
                layout = new MultiRowLayout(new RowLayout(new Field[]{factory.getField(EmptyProxy.EMPTY_PROXY, 0)}, id), 1);
                layouts[i] = layout;
            }
            layout.fillHeights(rowHeights);
        }
        for (i = 0; i < layouts.length; ++i) {
            layout = (MultiRowLayout)layouts[i];
            layout.align(rowHeights);
        }
    }

    private int getDefaultID(Layout[] layouts1) {
        for (Layout layout : layouts1) {
            if (layout == null) continue;
            MultiRowLayout multiRowLayout = (MultiRowLayout)layout;
            return multiRowLayout.getFirstRowID();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.layouts == null;
    }

    public Layout getLayout(int modelID) {
        return this.layouts[modelID];
    }
}

